/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.navigation;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class NavigationHistoryPanel
extends JComponent {
    private JComboBox comboBox;
    private NavigationHistoryManager manager;

    public NavigationHistoryPanel(NavigationHistoryManager manager) {
        this.manager = manager;
        JToolBar toolBar = OWLUI.createToolBar();
        JButton backButton = ComponentFactory.addToolBarButton((JToolBar)toolBar, (Action)manager.getBackAction());
        manager.getBackAction().activateComboBox(backButton);
        JButton forwardButton = ComponentFactory.addToolBarButton((JToolBar)toolBar, (Action)manager.getForwardAction());
        manager.getForwardAction().activateComboBox(forwardButton);
        this.comboBox = new JComboBox(manager){

            public Dimension getPreferredSize() {
                Dimension s = super.getPreferredSize();
                return new Dimension(200, s.height + 1);
            }
        };
        this.comboBox.setRenderer(new ResourceRenderer());
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigationHistoryPanel.this.handleComboBoxChange();
            }
        });
        manager.addIndexListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigationHistoryPanel.this.comboBox.setSelectedIndex(NavigationHistoryPanel.this.manager.getSelectedIndex());
                NavigationHistoryPanel.this.comboBox.repaint();
            }
        });
        this.setLayout(new FlowLayout());
        this.add(toolBar);
    }

    private void handleComboBoxChange() {
        Object frame = this.comboBox.getSelectedItem();
        if (frame instanceof Frame) {
            this.manager.setSelectedItem((Frame)frame);
        }
    }
}

