/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.domain;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.properties.domain.AddClassToDomainAction;
import edu.stanford.smi.protegex.owl.ui.properties.domain.OWLDomainTable;
import edu.stanford.smi.protegex.owl.ui.properties.domain.OWLDomainTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class OWLDomainWidget
extends AbstractPropertyWidget {
    private AddClassToDomainAction addAction;
    private AllowableAction removeAction;
    private OWLDomainTable table;
    private OWLDomainTableModel tableModel;

    public void initialize() {
        this.tableModel = new OWLDomainTableModel(null);
        this.table = new OWLDomainTable(this.tableModel);
        this.table.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                OWLDomainWidget.this.updateActions();
            }
        });
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.table));
        JViewport viewPort = scrollPane.getViewport();
        viewPort.setBackground(this.table.getBackground());
        OWLLabeledComponent lc = new OWLLabeledComponent("Domain  \u2294", scrollPane);
        WidgetUtilities.addViewButton(lc, (Action)new ViewAction("View class", (Selectable)this.table){

            public void onView(Object o) {
                OWLDomainWidget.this.getProject().show((Instance)o);
            }
        });
        this.addAction = new AddClassToDomainAction(this);
        this.updateActions();
        lc.addHeaderButton(this.addAction);
        this.removeAction = new AllowableAction("Remove from Domain", OWLIcons.getRemoveIcon("PrimitiveClass"), (Selectable)this.table){

            public void actionPerformed(ActionEvent e) {
                RDFProperty property = (RDFProperty)OWLDomainWidget.this.getEditedResource();
                Collection sel = OWLDomainWidget.this.table.getSelection();
                for (RDFSClass cls : sel) {
                    OWLDomainWidget.this.removeFromDomain(cls, property);
                }
            }

            public void onSelectionChange() {
                Collection sel = OWLDomainWidget.this.table.getSelection();
                boolean allowed = false;
                if (!sel.isEmpty()) {
                    RDFProperty prop = (RDFProperty)OWLDomainWidget.this.getEditedResource();
                    for (RDFSClass cls : sel) {
                        if (cls == cls.getOWLModel().getOWLThingClass() || !prop.getUnionDomain(false).contains(cls)) continue;
                        allowed = true;
                    }
                }
                this.setAllowed(allowed);
            }
        };
        lc.addHeaderButton((Action)this.removeAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)lc));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals(":DIRECT-DOMAIN");
    }

    private void removeFromDomain(RDFSClass cls, RDFProperty property) {
        try {
            try {
                this.beginTransaction("Remove " + cls.getBrowserText() + " from the domain of " + property.getBrowserText());
                if (property.isDomainDefined()) {
                    property.removeUnionDomainClass(cls);
                } else {
                    ArrayList classes = new ArrayList(property.getUnionDomain(true));
                    if (classes.remove(cls)) {
                        if (classes.size() == 1) {
                            property.setDomain((RDFSClass)classes.iterator().next());
                        } else {
                            System.out.println("classes = " + classes);
                            OWLUnionClass domain = cls.getOWLModel().createOWLUnionClass(classes);
                            property.setDomain(domain);
                        }
                    }
                }
                property.synchronizeDomainAndRangeOfInverse();
            }
            catch (Exception ex) {
                OWLUI.handleError(this.getOWLModel(), ex);
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
        this.addAction.setEnabled(b);
        this.removeAction.setAllowed(b);
    }

    public void setInstance(Instance newInstance) {
        super.setInstance(newInstance);
        if (newInstance instanceof RDFProperty) {
            RDFProperty newProperty = (RDFProperty)newInstance;
            this.tableModel.setSlot(newProperty);
        } else {
            this.tableModel.setSlot(null);
        }
        this.updateActions();
    }

    public void setValues(Collection values) {
        super.setValues(values);
        this.updateActions();
    }

    private void updateActions() {
        RDFProperty property = this.tableModel.getSlot();
        boolean enabled = property != null && property.isEditable();
        this.addAction.setEnabled(enabled);
    }
}

