/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.wizard;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.AbstractRepositoryWizardPage;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryCreatorWizardPlugin;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SelectRepositoryTypeWizardPage
extends AbstractRepositoryWizardPage {
    private ButtonGroup buttonGroup;
    private OWLModel owlModel;
    private RepositoryCreatorWizardPlugin selectedPlugin;

    public SelectRepositoryTypeWizardPage(RepositoryWizard wizard, OWLModel model) {
        super("Select repository type", wizard);
        this.owlModel = model;
        Box box = new Box(1);
        JPanel holder = new JPanel(new BorderLayout(7, 7));
        holder.add((Component)new JLabel("Please select the type of repository that you would like to create"), "North");
        holder.add((Component)box, "Center");
        this.buttonGroup = new ButtonGroup();
        String helpText = "";
        for (RepositoryCreatorWizardPlugin curPlugin : wizard.getPlugins()) {
            JRadioButton radioButton = new JRadioButton(new PluginSelectedAction(curPlugin));
            radioButton.setToolTipText(curPlugin.getDescription());
            radioButton.setEnabled(curPlugin.isSuitable(this.owlModel));
            box.add(radioButton);
            this.buttonGroup.add(radioButton);
            helpText = String.valueOf(helpText) + "<p>";
            helpText = String.valueOf(helpText) + "<b>" + curPlugin.getName() + "</b><font size=\"-2\"> " + curPlugin.getDescription();
            helpText = String.valueOf(helpText) + "</font></p>";
        }
        box.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.getContentComponent().add((Component)holder, "North");
        this.setHelpText("Please select the type of repository that you would like to add:", helpText);
    }

    public void nextPressed() {
        this.getRepositoryWizard().setSelectedPlugin(this.selectedPlugin);
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    private class PluginSelectedAction
    extends AbstractAction {
        private RepositoryCreatorWizardPlugin plugin;

        public PluginSelectedAction(RepositoryCreatorWizardPlugin plugin) {
            super(plugin.getName());
            this.plugin = plugin;
        }

        public void actionPerformed(ActionEvent e) {
            SelectRepositoryTypeWizardPage.this.selectedPlugin = this.plugin;
        }
    }
}

