/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.subsumption.ChangedClassItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ChangedClassesTableModel
extends AbstractTableModel
implements Disposable {
    public static final int COL_CLS = 0;
    public static final int COL_TEXT = 1;
    public static final int COL_COUNT = 2;
    private List items = new ArrayList();
    private Hashtable itemsByCls = new Hashtable();
    private ModelListener modelListener = new ModelAdapter(){

        public void classDeleted(RDFSClass cls) {
            ChangedClassesTableModel.this.refill();
        }
    };
    private OWLModel owlModel;

    public ChangedClassesTableModel(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.refill();
        owlModel.addModelListener(this.modelListener);
    }

    void assertChange(OWLNamedClass cls) {
        ChangedClassItem changedClassItem = this.getOrCreateItem(cls);
        this.assertChange(changedClassItem);
    }

    private void assertChange(ChangedClassItem item) {
        item.assertChange();
        int index = this.items.indexOf(item);
        this.items.remove(index);
        this.itemsByCls.remove(item.getCls());
        this.fireTableRowsDeleted(index, index);
    }

    void assertChanges(int[] rows) {
        ArrayList<ChangedClassItem> is = new ArrayList<ChangedClassItem>();
        int i = 0;
        while (i < rows.length) {
            int row = rows[i];
            ChangedClassItem item = (ChangedClassItem)this.items.get(row);
            OWLNamedClass cls = item.getCls();
            if (!OWLUtil.isInconsistent(cls) && cls.isEditable()) {
                is.add(item);
            }
            ++i;
        }
        this.assertChanges(is);
    }

    private void assertChanges(Collection items) {
        this.owlModel.beginTransaction("Assert classification changes");
        for (ChangedClassItem item : items) {
            this.assertChange(item);
        }
        this.owlModel.endTransaction();
    }

    public boolean contains(Cls cls) {
        return this.itemsByCls.containsKey(cls);
    }

    public void dispose() {
        this.owlModel.removeModelListener(this.modelListener);
    }

    private void fillItems(Collection assertedSubClses, Collection computedSubClses, Cls cls) {
        ChangedClassItem item;
        this.removeDuplicates(assertedSubClses, computedSubClses);
        for (OWLNamedClass namedCls : assertedSubClses) {
            if (namedCls.isMetaclass()) continue;
            item = this.getOrCreateItem(namedCls);
            item.addRemovedSuperCls(cls);
        }
        for (OWLNamedClass namedCls : computedSubClses) {
            if (namedCls.isMetaclass()) continue;
            item = this.getOrCreateItem(namedCls);
            item.addAddedSuperCls(cls);
        }
    }

    public String getChangeText(Cls cls) {
        ChangedClassItem item = (ChangedClassItem)this.itemsByCls.get(cls);
        if (item != null) {
            return item.toString();
        }
        return null;
    }

    public Cls getCls(int row) {
        return (Cls)this.getValueAt(row, 0);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Frame.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Class";
        }
        return "Changed direct superclasses";
    }

    private ChangedClassItem getOrCreateItem(OWLNamedClass cls) {
        ChangedClassItem item = (ChangedClassItem)this.itemsByCls.get(cls);
        if (item == null) {
            item = new ChangedClassItem(cls);
            this.items.add(item);
            this.itemsByCls.put(cls, item);
        }
        return item;
    }

    public int getRowCount() {
        return this.items.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ChangedClassItem item = (ChangedClassItem)this.items.get(rowIndex);
        if (columnIndex == 0) {
            return item.getCls();
        }
        return item.toString();
    }

    public void refill() {
        this.items = new ArrayList();
        this.itemsByCls = new Hashtable();
        for (OWLNamedClass cls : this.owlModel.getChangedInferredClasses()) {
            ChangedClassItem item = this.getOrCreateItem(cls);
            ArrayList asserted = new ArrayList(cls.getNamedSuperclasses());
            ArrayList inferred = new ArrayList(cls.getInferredSuperclasses());
            this.removeDuplicates(asserted, inferred);
            for (RDFSNamedClass superCls : asserted) {
                if (superCls.isMetaclass()) continue;
                item.addRemovedSuperCls(superCls);
            }
            for (RDFSNamedClass superCls : inferred) {
                if (superCls.isMetaclass()) continue;
                item.addAddedSuperCls(superCls);
            }
        }
        for (OWLNamedClass cls : this.owlModel.getInconsistentClasses()) {
            this.getOrCreateItem(cls);
        }
        Collections.sort(this.items);
        this.fireTableDataChanged();
    }

    private void removeDuplicates(Collection a, Collection b) {
        ArrayList copyA = new ArrayList(a);
        a.removeAll(b);
        b.removeAll(copyA);
    }
}

