/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.subsumption.SubsumptionTreePanel;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;

public abstract class EditableSubsumptionTreePanel
extends SubsumptionTreePanel {
    public EditableSubsumptionTreePanel(Cls root, Slot subclassesSlot, Slot superclassesSlot) {
        super(root, subclassesSlot, superclassesSlot, false);
        Action deleteAction;
        Action createAction = this.createCreateAction();
        if (createAction != null) {
            this.getLabeledComponent().addHeaderButton(createAction);
        }
        if ((deleteAction = this.createDeleteAction()) != null) {
            this.getLabeledComponent().addHeaderButton(deleteAction);
        }
    }

    protected Action createCreateAction() {
        AllowableAction action = new AllowableAction("Create subclass", null, Icons.getCreateIcon(), this){

            public void actionPerformed(ActionEvent e) {
                Collection parents = this.getSelection();
                if (!parents.isEmpty()) {
                    RDFSNamedClass cls = EditableSubsumptionTreePanel.this.getOWLModel().createSubclass(null, parents);
                    EditableSubsumptionTreePanel.this.extendSelection(cls);
                }
            }

            public void onSelectionChange() {
                super.onSelectionChange();
                this.setAllowed(!this.getSelection().isEmpty());
            }
        };
        action.setEnabled(false);
        return action;
    }

    protected Action createDeleteAction() {
        DeleteInstancesAction action = new DeleteInstancesAction(this){

            public void onAboutToDelete() {
                EditableSubsumptionTreePanel.this.removeSelection();
            }

            public void onSelectionChange() {
                boolean isEditable = false;
                Frame frame = (Frame)CollectionUtilities.getFirstItem((Collection)this.getSelection());
                if (frame != null) {
                    isEditable = frame.isEditable();
                }
                this.setAllowed(isEditable);
            }
        };
        action.setEnabled(false);
        return action;
    }
}

