/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestResultsTableModelColumns;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class OWLTestResultsTableModel
extends AbstractTableModel
implements Disposable,
OWLTestResultsTableModelColumns {
    private List items;
    private OWLModel owlModel;
    private ModelListener listener = new ModelAdapter(){

        public void classDeleted(RDFSClass cls) {
            OWLTestResultsTableModel.this.deleteItemsWith((Frame)cls);
        }

        public void propertyDeleted(RDFProperty property) {
            OWLTestResultsTableModel.this.deleteItemsWith((Frame)property);
        }

        public void individualDeleted(RDFResource resource) {
            OWLTestResultsTableModel.this.deleteItemsWith((Frame)resource);
        }
    };

    public OWLTestResultsTableModel(OWLModel owlModel, Collection items) {
        this.items = new ArrayList(items);
        this.owlModel = owlModel;
        owlModel.addModelListener(this.listener);
    }

    private void deleteItemsWith(Frame frame) {
        int i = this.items.size() - 1;
        while (i >= 0) {
            OWLTestResult item = this.getOWLTestResult(i);
            if (frame.equals(item.getHost())) {
                this.items.remove(i);
                this.fireTableRowsDeleted(i, i);
            }
            --i;
        }
    }

    public void dispose() {
        this.owlModel.removeModelListener(this.listener);
    }

    public Class getColumnClass(int column) {
        if (column == 1) {
            return RDFResource.class;
        }
        if (column == 2) {
            return String.class;
        }
        if (column == 0) {
            return Icon.class;
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        if (column == 1) {
            return "Source";
        }
        if (column == 2) {
            return "Test Result";
        }
        if (column == 0) {
            return "Type";
        }
        return null;
    }

    RDFResource getSource(int row) {
        return this.getOWLTestResult(row).getHost();
    }

    public OWLTestResult getOWLTestResult(int row) {
        return (OWLTestResult)this.items.get(row);
    }

    public int getRowCount() {
        return this.items.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            return this.getOWLTestResult(rowIndex).getMessage();
        }
        if (columnIndex == 1) {
            return this.getSource(rowIndex);
        }
        if (columnIndex == 0) {
            return this.getOWLTestResult(rowIndex).getIcon();
        }
        return null;
    }

    public void removeRow(int row) {
        this.items.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public String saveToFile(File file) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            for (OWLTestResult testResult : this.items) {
                pw.println(testResult.toString());
            }
            pw.close();
            return null;
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    public void setItems(Collection items) {
        this.items = new ArrayList(items);
        this.fireTableDataChanged();
    }
}

