/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.Set;

public class MultiUnion
extends Polyadic {
    public MultiUnion() {
    }

    public MultiUnion(Graph[] graphArray) {
        super(graphArray);
    }

    public MultiUnion(Iterator iterator) {
        super(iterator);
    }

    public Reifier getReifier() {
        Graph graph = this.getBaseGraph();
        return graph == null ? super.getReifier() : graph.getReifier();
    }

    public void performAdd(Triple triple) {
        try {
            this.getBaseGraph().add(triple);
        }
        catch (NullPointerException nullPointerException) {
            throw new JenaException("Tried to add to a union graph that has no component graphs.");
        }
    }

    public void performDelete(Triple triple) {
        try {
            this.getBaseGraph().delete(triple);
        }
        catch (NullPointerException nullPointerException) {
            throw new JenaException("Tried to delete from a union graph that has no component graphs.");
        }
    }

    public boolean graphBaseContains(Triple triple) {
        Iterator iterator = this.m_subGraphs.iterator();
        while (iterator.hasNext()) {
            if (!((Graph)iterator.next()).contains(triple)) continue;
            return true;
        }
        return false;
    }

    public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
        Set set = CollectionFactory.createHashedSet();
        ExtendedIterator extendedIterator = NullIterator.instance;
        Iterator iterator = this.m_subGraphs.iterator();
        while (iterator.hasNext()) {
            ExtendedIterator extendedIterator2 = MultiUnion.recording(MultiUnion.rejecting(((Graph)iterator.next()).find(tripleMatch), set), set);
            extendedIterator = extendedIterator.andThen(extendedIterator2);
        }
        return SimpleEventManager.notifyingRemove(this, extendedIterator);
    }

    public void addGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            this.m_subGraphs.add(graph);
        }
    }
}

