/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.Dyadic;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.StringTokenizer;
import junit.framework.TestSuite;

public class TestDyadic
extends GraphTestBase {
    public TestDyadic(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDyadic.class);
    }

    private static ExtendedIterator things(final String string) {
        return new NiceIterator(){
            private StringTokenizer tokens;
            {
                this.tokens = new StringTokenizer(string);
            }

            public boolean hasNext() {
                return this.tokens.hasMoreTokens();
            }

            public Object next() {
                return this.tokens.nextToken();
            }
        };
    }

    public void testDyadic() {
        ExtendedIterator extendedIterator = TestDyadic.things("now is the time");
        ExtendedIterator extendedIterator2 = TestDyadic.things("now is the time");
        ExtendedIterator extendedIterator3 = TestDyadic.things("");
        ExtendedIterator extendedIterator4 = TestDyadic.things("");
        TestDyadic.assertEquals((String)"mt1.hasNext()", (boolean)false, (boolean)extendedIterator3.hasNext());
        TestDyadic.assertEquals((String)"mt2.hasNext()", (boolean)false, (boolean)extendedIterator4.hasNext());
        TestDyadic.assertEquals((String)"andThen(mt1,mt2).hasNext()", (boolean)false, (boolean)extendedIterator3.andThen(extendedIterator4).hasNext());
        TestDyadic.assertEquals((String)"butNot(it1,it2).hasNext()", (boolean)false, (boolean)Dyadic.butNot(extendedIterator, extendedIterator2).hasNext());
        TestDyadic.assertEquals((String)"x y z @butNot z", (boolean)true, (boolean)Dyadic.butNot(TestDyadic.things("x y z"), TestDyadic.things("z")).hasNext());
        TestDyadic.assertEquals((String)"x y z @butNot a", (boolean)true, (boolean)Dyadic.butNot(TestDyadic.things("x y z"), TestDyadic.things("z")).hasNext());
    }

    public void testDyadicOperands() {
        GraphMem graphMem = new GraphMem();
        GraphMem graphMem2 = new GraphMem();
        Dyadic dyadic = new Dyadic(graphMem, graphMem2){

            public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
                return null;
            }
        };
        TestDyadic.assertSame((Object)graphMem, (Object)dyadic.getL());
        TestDyadic.assertSame((Object)graphMem2, (Object)dyadic.getR());
    }
}

