/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.regexptrees;

import com.hp.hpl.jena.graph.query.regexptrees.Alternatives;
import com.hp.hpl.jena.graph.query.regexptrees.AnyOf;
import com.hp.hpl.jena.graph.query.regexptrees.BackReference;
import com.hp.hpl.jena.graph.query.regexptrees.NoneOf;
import com.hp.hpl.jena.graph.query.regexptrees.OneOrMore;
import com.hp.hpl.jena.graph.query.regexptrees.Optional;
import com.hp.hpl.jena.graph.query.regexptrees.Paren;
import com.hp.hpl.jena.graph.query.regexptrees.RegexpTree;
import com.hp.hpl.jena.graph.query.regexptrees.RegexpTreeGenerator;
import com.hp.hpl.jena.graph.query.regexptrees.Sequence;
import com.hp.hpl.jena.graph.query.regexptrees.Text;
import com.hp.hpl.jena.graph.query.regexptrees.ZeroOrMore;
import java.util.List;

public class SimpleGenerator
implements RegexpTreeGenerator {
    public RegexpTree getAnySingle() {
        return RegexpTree.ANY;
    }

    public RegexpTree getStartOfLine() {
        return RegexpTree.SOL;
    }

    public RegexpTree getEndOfLine() {
        return RegexpTree.EOL;
    }

    public RegexpTree getNothing() {
        return RegexpTree.NON;
    }

    public RegexpTree getText(char c) {
        return Text.create(c);
    }

    public RegexpTree getZeroOrMore(RegexpTree regexpTree) {
        return new ZeroOrMore(regexpTree);
    }

    public RegexpTree getOneOrMore(RegexpTree regexpTree) {
        return new OneOrMore(regexpTree);
    }

    public RegexpTree getOptional(RegexpTree regexpTree) {
        return new Optional(regexpTree);
    }

    public RegexpTree getSequence(List list) {
        return Sequence.create(list);
    }

    public RegexpTree getAlternatives(List list) {
        return Alternatives.create(list);
    }

    public RegexpTree getBackReference(int n) {
        return new BackReference(n);
    }

    public RegexpTree getClass(String string, boolean bl) {
        return bl ? new NoneOf(string) : new AnyOf(string);
    }

    public RegexpTree getParen(RegexpTree regexpTree, int n) {
        return new Paren(regexpTree, n);
    }
}

