/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.HashSet;

public class OntPropertyImpl
extends OntResourceImpl
implements OntProperty {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new OntPropertyImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node + " to OntProperty");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            Profile profile;
            Profile profile2 = profile = enhGraph instanceof OntModel ? ((OntModel)((Object)enhGraph)).getProfile() : null;
            return profile != null && profile.isSupported(node, enhGraph, class$com$hp$hpl$jena$ontology$OntProperty == null ? (class$com$hp$hpl$jena$ontology$OntProperty = OntPropertyImpl.class$("com.hp.hpl.jena.ontology.OntProperty")) : class$com$hp$hpl$jena$ontology$OntProperty);
        }
    };

    public OntPropertyImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public boolean isProperty() {
        return true;
    }

    public int getOrdinal() {
        return ((Property)this.as(Property.class)).getOrdinal();
    }

    public void setSuperProperty(Property property) {
        this.setPropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", property);
    }

    public void addSuperProperty(Property property) {
        this.addPropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", property);
    }

    public OntProperty getSuperProperty() {
        return this.objectAsProperty(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF");
    }

    public ExtendedIterator listSuperProperties() {
        return this.listSuperProperties(false);
    }

    public ExtendedIterator listSuperProperties(boolean bl) {
        return this.listDirectPropertyValues(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", OntProperty.class, this.getProfile().SUB_PROPERTY_OF(), bl, false);
    }

    public boolean hasSuperProperty(Property property, boolean bl) {
        return this.hasPropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", property);
    }

    public void removeSuperProperty(Property property) {
        this.removePropertyValue(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", property);
    }

    public void setSubProperty(Property property) {
        this.checkProfile(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF");
        StmtIterator stmtIterator = this.getModel().listStatements(null, this.getProfile().SUB_PROPERTY_OF(), this);
        while (stmtIterator.hasNext()) {
            stmtIterator.removeNext();
        }
        ((OntProperty)property.as(OntProperty.class)).addSuperProperty(this);
    }

    public void addSubProperty(Property property) {
        ((OntProperty)property.as(OntProperty.class)).addSuperProperty(this);
    }

    public OntProperty getSubProperty() {
        this.checkProfile(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF");
        return (OntProperty)this.getModel().listStatements(null, this.getProfile().SUB_PROPERTY_OF(), this).nextStatement().getSubject().as(OntProperty.class);
    }

    public ExtendedIterator listSubProperties() {
        return this.listSubProperties(false);
    }

    public ExtendedIterator listSubProperties(boolean bl) {
        return this.listDirectPropertyValues(this.getProfile().SUB_PROPERTY_OF(), "SUB_PROPERTY_OF", OntProperty.class, this.getProfile().SUB_PROPERTY_OF(), bl, true);
    }

    public boolean hasSubProperty(Property property, boolean bl) {
        return ((OntProperty)property.as(OntProperty.class)).hasSuperProperty(this, bl);
    }

    public void removeSubProperty(Property property) {
        ((OntProperty)property.as(OntProperty.class)).removeSuperProperty(this);
    }

    public void setDomain(Resource resource) {
        this.setPropertyValue(this.getProfile().DOMAIN(), "DOMAIN", resource);
    }

    public void addDomain(Resource resource) {
        this.addPropertyValue(this.getProfile().DOMAIN(), "DOMAIN", resource);
    }

    public OntResource getDomain() {
        return this.objectAsResource(this.getProfile().DOMAIN(), "DOMAIN");
    }

    public ExtendedIterator listDomain() {
        return this.listAs(this.getProfile().DOMAIN(), "DOMAIN", OntClass.class);
    }

    public boolean hasDomain(Resource resource) {
        return this.hasPropertyValue(this.getProfile().DOMAIN(), "DOMAIN", resource);
    }

    public void removeDomain(Resource resource) {
        this.removePropertyValue(this.getProfile().DOMAIN(), "DOMAIN", resource);
    }

    public void setRange(Resource resource) {
        this.setPropertyValue(this.getProfile().RANGE(), "RANGE", resource);
    }

    public void addRange(Resource resource) {
        this.addPropertyValue(this.getProfile().RANGE(), "RANGE", resource);
    }

    public OntResource getRange() {
        return this.objectAsResource(this.getProfile().RANGE(), "RANGE");
    }

    public ExtendedIterator listRange() {
        return this.listAs(this.getProfile().RANGE(), "RANGE", OntClass.class);
    }

    public boolean hasRange(Resource resource) {
        return this.hasPropertyValue(this.getProfile().RANGE(), "RANGE", resource);
    }

    public void removeRange(Resource resource) {
        this.removePropertyValue(this.getProfile().RANGE(), "RANGE", resource);
    }

    public void setEquivalentProperty(Property property) {
        this.setPropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", property);
    }

    public void addEquivalentProperty(Property property) {
        this.addPropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", property);
    }

    public OntProperty getEquivalentProperty() {
        return this.objectAsProperty(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY");
    }

    public ExtendedIterator listEquivalentProperties() {
        return this.listAs(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", OntProperty.class);
    }

    public boolean hasEquivalentProperty(Property property) {
        return this.hasPropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", property);
    }

    public void removeEquivalentProperty(Property property) {
        this.removePropertyValue(this.getProfile().EQUIVALENT_PROPERTY(), "EQUIVALENT_PROPERTY", property);
    }

    public void setInverseOf(Property property) {
        this.setPropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", property);
    }

    public void addInverseOf(Property property) {
        this.addPropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", property);
    }

    public OntProperty getInverseOf() {
        return this.objectAsProperty(this.getProfile().INVERSE_OF(), "INVERSE_OF");
    }

    public ExtendedIterator listInverseOf() {
        return this.listAs(this.getProfile().INVERSE_OF(), "INVERSE_OF", OntProperty.class);
    }

    public boolean isInverseOf(Property property) {
        return this.hasPropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", property);
    }

    public void removeInverseProperty(Property property) {
        this.removePropertyValue(this.getProfile().INVERSE_OF(), "INVERSE_OF", property);
    }

    public FunctionalProperty asFunctionalProperty() {
        return (FunctionalProperty)this.as(FunctionalProperty.class);
    }

    public DatatypeProperty asDatatypeProperty() {
        return (DatatypeProperty)this.as(DatatypeProperty.class);
    }

    public ObjectProperty asObjectProperty() {
        return (ObjectProperty)this.as(ObjectProperty.class);
    }

    public TransitiveProperty asTransitiveProperty() {
        return (TransitiveProperty)this.as(TransitiveProperty.class);
    }

    public InverseFunctionalProperty asInverseFunctionalProperty() {
        return (InverseFunctionalProperty)this.as(InverseFunctionalProperty.class);
    }

    public SymmetricProperty asSymmetricProperty() {
        return (SymmetricProperty)this.as(SymmetricProperty.class);
    }

    public FunctionalProperty convertToFunctionalProperty() {
        return (FunctionalProperty)this.convertToType(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY", FunctionalProperty.class);
    }

    public DatatypeProperty convertToDatatypeProperty() {
        return (DatatypeProperty)this.convertToType(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY", DatatypeProperty.class);
    }

    public ObjectProperty convertToObjectProperty() {
        return (ObjectProperty)this.convertToType(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY", ObjectProperty.class);
    }

    public TransitiveProperty convertToTransitiveProperty() {
        return (TransitiveProperty)this.convertToType(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY", TransitiveProperty.class);
    }

    public InverseFunctionalProperty convertToInverseFunctionalProperty() {
        return (InverseFunctionalProperty)this.convertToType(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY", InverseFunctionalProperty.class);
    }

    public SymmetricProperty convertToSymmetricProperty() {
        return (SymmetricProperty)this.convertToType(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY", SymmetricProperty.class);
    }

    public boolean isFunctionalProperty() {
        return this.hasRDFType(this.getProfile().FUNCTIONAL_PROPERTY(), "FUNCTIONAL_PROPERTY", false);
    }

    public boolean isDatatypeProperty() {
        return this.hasRDFType(this.getProfile().DATATYPE_PROPERTY(), "DATATYPE_PROPERTY", false);
    }

    public boolean isObjectProperty() {
        return this.hasRDFType(this.getProfile().OBJECT_PROPERTY(), "OBJECT_PROPERTY", false);
    }

    public boolean isTransitiveProperty() {
        return this.hasRDFType(this.getProfile().TRANSITIVE_PROPERTY(), "TRANSITIVE_PROPERTY", false);
    }

    public boolean isInverseFunctionalProperty() {
        return this.hasRDFType(this.getProfile().INVERSE_FUNCTIONAL_PROPERTY(), "INVERSE_FUNCTIONAL_PROPERTY", false);
    }

    public boolean isSymmetricProperty() {
        return this.hasRDFType(this.getProfile().SYMMETRIC_PROPERTY(), "SYMMETRIC_PROPERTY", false);
    }

    public OntProperty getInverse() {
        ExtendedIterator extendedIterator = this.listInverse();
        OntProperty ontProperty = extendedIterator.hasNext() ? (OntProperty)extendedIterator.next() : null;
        extendedIterator.close();
        return ontProperty;
    }

    public ExtendedIterator listInverse() {
        return this.getModel().listStatements(null, this.getProfile().INVERSE_OF(), this).mapWith(new OntResourceImpl.SubjectAsMapper(OntProperty.class));
    }

    public boolean hasInverse() {
        ExtendedIterator extendedIterator = this.listInverse();
        boolean bl = extendedIterator.hasNext();
        extendedIterator.close();
        return bl;
    }

    public ExtendedIterator listDeclaringClasses() {
        return this.listDeclaringClasses(false);
    }

    public ExtendedIterator listDeclaringClasses(boolean bl) {
        HashSet<OntClass> hashSet = new HashSet<OntClass>();
        ExtendedIterator extendedIterator = this.listDomain();
        while (extendedIterator.hasNext()) {
            ArrayList arrayList = new ArrayList();
            arrayList.add(extendedIterator.next());
            while (!arrayList.isEmpty()) {
                OntClass ontClass = (OntClass)arrayList.remove(0);
                if (ontClass.isOntLanguageTerm() || hashSet.contains(ontClass)) continue;
                hashSet.add(ontClass);
                ExtendedIterator extendedIterator2 = ontClass.listSubClasses();
                while (extendedIterator2.hasNext()) {
                    arrayList.add(extendedIterator2.next());
                }
            }
        }
        if (hashSet.isEmpty()) {
            if (!bl) {
                return ((OntModel)this.getModel()).listClasses().filterDrop(new Filter(){

                    public boolean accept(Object object) {
                        return ((OntClass)object).isOntLanguageTerm();
                    }
                });
            }
            return ((OntModel)this.getModel()).listHierarchyRootClasses();
        }
        return WrappedIterator.create(hashSet.iterator()).filterKeep(new FilterDeclaringClass(this, bl));
    }

    public RDFNode inModel(Model model) {
        return this.getModel() == model ? this : model.createProperty(this.getURI());
    }

    private class FilterDeclaringClass
    implements Filter {
        private boolean m_direct;
        private Property m_prop;

        private FilterDeclaringClass(Property property, boolean bl) {
            this.m_prop = property;
            this.m_direct = bl;
        }

        public boolean accept(Object object) {
            return ((OntClass)object).hasDeclaredProperty(this.m_prop, this.m_direct);
        }
    }
}

