/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.ProfileException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.RDFListImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OntResourceImpl
extends ResourceImpl
implements OntResource {
    public static final String[] KNOWN_LANGUAGES = new String[]{"http://www.w3.org/2002/07/owl#", RDF.getURI(), RDFS.getURI(), "http://www.daml.org/2001/03/daml+oil#", "http://www.w3.org/2001/XMLSchema"};
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new OntResourceImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to OntResource");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return node.isURI() || node.isBlank();
        }
    };
    private static final Log log = LogFactory.getLog((Class)OntResourceImpl.class);

    public OntResourceImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public Profile getProfile() {
        return ((OntModel)this.getModel()).getProfile();
    }

    public boolean isOntLanguageTerm() {
        if (!this.isAnon()) {
            for (int i = 0; i < KNOWN_LANGUAGES.length; ++i) {
                if (!this.getURI().startsWith(KNOWN_LANGUAGES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void setSameAs(Resource resource) {
        this.setPropertyValue(this.getProfile().SAME_AS(), "SAME_AS", resource);
    }

    public void addSameAs(Resource resource) {
        this.addPropertyValue(this.getProfile().SAME_AS(), "SAME_AS", resource);
    }

    public OntResource getSameAs() {
        return this.objectAsResource(this.getProfile().SAME_AS(), "SAME_AS");
    }

    public ExtendedIterator listSameAs() {
        return this.listAs(this.getProfile().SAME_AS(), "SAME_AS", OntResource.class);
    }

    public boolean isSameAs(Resource resource) {
        return this.hasPropertyValue(this.getProfile().SAME_AS(), "SAME_AS", resource);
    }

    public void removeSameAs(Resource resource) {
        this.removePropertyValue(this.getProfile().SAME_AS(), "SAME_AS", resource);
    }

    public void setDifferentFrom(Resource resource) {
        this.setPropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", resource);
    }

    public void addDifferentFrom(Resource resource) {
        this.addPropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", resource);
    }

    public OntResource getDifferentFrom() {
        return this.objectAsResource(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM");
    }

    public ExtendedIterator listDifferentFrom() {
        return this.listAs(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", OntResource.class);
    }

    public boolean isDifferentFrom(Resource resource) {
        return this.hasPropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", resource);
    }

    public void removeDifferentFrom(Resource resource) {
        this.removePropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", resource);
    }

    public void setSeeAlso(Resource resource) {
        this.setPropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", resource);
    }

    public void addSeeAlso(Resource resource) {
        this.addPropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", resource);
    }

    public Resource getSeeAlso() {
        return this.objectAsResource(this.getProfile().SEE_ALSO(), "SEE_ALSO");
    }

    public ExtendedIterator listSeeAlso() {
        this.checkProfile(this.getProfile().SEE_ALSO(), "SEE_ALSO");
        return WrappedIterator.create(this.listProperties(this.getProfile().SEE_ALSO())).mapWith(new ObjectMapper());
    }

    public boolean hasSeeAlso(Resource resource) {
        return this.hasPropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", resource);
    }

    public void removeSeeAlso(Resource resource) {
        this.removePropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", resource);
    }

    public void setIsDefinedBy(Resource resource) {
        this.setPropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", resource);
    }

    public void addIsDefinedBy(Resource resource) {
        this.addPropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", resource);
    }

    public Resource getIsDefinedBy() {
        return this.objectAsResource(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY");
    }

    public ExtendedIterator listIsDefinedBy() {
        this.checkProfile(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY");
        return WrappedIterator.create(this.listProperties(this.getProfile().IS_DEFINED_BY())).mapWith(new ObjectMapper());
    }

    public boolean isDefinedBy(Resource resource) {
        return this.hasPropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", resource);
    }

    public void removeDefinedBy(Resource resource) {
        this.removePropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", resource);
    }

    public void setVersionInfo(String string) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        this.removeAll(this.getProfile().VERSION_INFO());
        this.addVersionInfo(string);
    }

    public void addVersionInfo(String string) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        this.addProperty(this.getProfile().VERSION_INFO(), this.getModel().createLiteral(string));
    }

    public String getVersionInfo() {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        try {
            return this.getRequiredProperty(this.getProfile().VERSION_INFO()).getString();
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            return null;
        }
    }

    public ExtendedIterator listVersionInfo() {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        return WrappedIterator.create(this.listProperties(this.getProfile().VERSION_INFO())).mapWith(new ObjectAsStringMapper());
    }

    public boolean hasVersionInfo(String string) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        return this.hasProperty(this.getProfile().VERSION_INFO(), string);
    }

    public void removeVersionInfo(String string) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        StmtIterator stmtIterator = this.getModel().listStatements((Resource)this, this.getProfile().VERSION_INFO(), string);
        if (stmtIterator.hasNext()) {
            stmtIterator.nextStatement().remove();
        }
        stmtIterator.close();
    }

    public void setLabel(String string, String string2) {
        this.checkProfile(this.getProfile().LABEL(), "LABEL");
        this.removeAll(this.getProfile().LABEL());
        this.addLabel(string, string2);
    }

    public void addLabel(String string, String string2) {
        this.addLabel(this.getModel().createLiteral(string, string2));
    }

    public void addLabel(Literal literal) {
        this.addPropertyValue(this.getProfile().LABEL(), "LABEL", literal);
    }

    public String getLabel(String string) {
        this.checkProfile(this.getProfile().LABEL(), "LABEL");
        if (string == null || string.length() == 0) {
            try {
                return this.getRequiredProperty(this.getProfile().LABEL()).getString();
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                return null;
            }
        }
        return this.selectLang(this.listProperties(this.getProfile().LABEL()), string);
    }

    public ExtendedIterator listLabels(String string) {
        this.checkProfile(this.getProfile().LABEL(), "LABEL");
        return WrappedIterator.create(this.listProperties(this.getProfile().LABEL())).filterKeep(new LangTagFilter(string)).mapWith(new ObjectMapper());
    }

    public boolean hasLabel(String string, String string2) {
        return this.hasLabel(this.getModel().createLiteral(string, string2));
    }

    public boolean hasLabel(Literal literal) {
        boolean bl = false;
        ExtendedIterator extendedIterator = this.listLabels(literal.getLanguage());
        while (!bl && extendedIterator.hasNext()) {
            bl = ((Object)literal).equals(extendedIterator.next());
        }
        extendedIterator.close();
        return bl;
    }

    public void removeLabel(String string, String string2) {
        this.removeLabel(this.getModel().createLiteral(string, string2));
    }

    public void removeLabel(Literal literal) {
        this.removePropertyValue(this.getProfile().LABEL(), "LABEL", literal);
    }

    public void setComment(String string, String string2) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        this.removeAll(this.getProfile().COMMENT());
        this.addComment(string, string2);
    }

    public void addComment(String string, String string2) {
        this.addComment(this.getModel().createLiteral(string, string2));
    }

    public void addComment(Literal literal) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        this.addProperty(this.getProfile().COMMENT(), literal);
    }

    public String getComment(String string) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        if (string == null) {
            try {
                return this.getRequiredProperty(this.getProfile().COMMENT()).getString();
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                return null;
            }
        }
        return this.selectLang(this.listProperties(this.getProfile().COMMENT()), string);
    }

    public ExtendedIterator listComments(String string) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        return WrappedIterator.create(this.listProperties(this.getProfile().COMMENT())).filterKeep(new LangTagFilter(string)).mapWith(new ObjectMapper());
    }

    public boolean hasComment(String string, String string2) {
        return this.hasComment(this.getModel().createLiteral(string, string2));
    }

    public boolean hasComment(Literal literal) {
        boolean bl = false;
        ExtendedIterator extendedIterator = this.listComments(literal.getLanguage());
        while (!bl && extendedIterator.hasNext()) {
            bl = ((Object)literal).equals(extendedIterator.next());
        }
        extendedIterator.close();
        return bl;
    }

    public void removeComment(String string, String string2) {
        this.removeComment(this.getModel().createLiteral(string, string2));
    }

    public void removeComment(Literal literal) {
        this.removePropertyValue(this.getProfile().COMMENT(), "COMMENT", literal);
    }

    public void setRDFType(Resource resource) {
        this.setPropertyValue(RDF.type, "rdf:type", resource);
    }

    public void addRDFType(Resource resource) {
        this.addPropertyValue(RDF.type, "rdf:type", resource);
    }

    public Resource getRDFType() {
        return this.getRDFType(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getRDFType(boolean bl) {
        ExtendedIterator extendedIterator = null;
        try {
            extendedIterator = this.listRDFTypes(bl);
            Resource resource = extendedIterator.hasNext() ? (Resource)extendedIterator.next() : null;
            return resource;
        }
        finally {
            extendedIterator.close();
        }
    }

    public ExtendedIterator listRDFTypes(boolean bl) {
        ExtendedIterator extendedIterator = this.listDirectPropertyValues(RDF.type, "rdf:type", null, this.getProfile().SUB_CLASS_OF(), bl, false);
        ExtendedIterator extendedIterator2 = WrappedIterator.create(extendedIterator);
        return UniqueExtendedIterator.create(extendedIterator2);
    }

    public boolean hasRDFType(String string) {
        return this.hasRDFType(this.getModel().getResource(string));
    }

    public boolean hasRDFType(Resource resource) {
        return this.hasRDFType(resource, "unknown", false);
    }

    public boolean hasRDFType(Resource resource, boolean bl) {
        return this.hasRDFType(resource, "unknown", bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasRDFType(Resource resource, String string, boolean bl) {
        this.checkProfile(resource, string);
        if (!bl) {
            return this.hasPropertyValue(RDF.type, "rdf:type", resource);
        }
        ExtendedIterator extendedIterator = null;
        try {
            extendedIterator = this.listRDFTypes(true);
            while (extendedIterator.hasNext()) {
                if (!((Object)resource).equals(extendedIterator.next())) continue;
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            extendedIterator.close();
        }
    }

    public void removeRDFType(Resource resource) {
        this.removePropertyValue(RDF.type, "rdf:type", resource);
    }

    public int getCardinality(Property property) {
        int n = 0;
        ExtendedIterator extendedIterator = UniqueExtendedIterator.create(this.listPropertyValues(property));
        while (extendedIterator.hasNext()) {
            extendedIterator.next();
            ++n;
        }
        return n;
    }

    public void setPropertyValue(Property property, RDFNode rDFNode) {
        this.removeAll(property);
        if (rDFNode != null) {
            this.addProperty(property, rDFNode);
        }
    }

    public RDFNode getPropertyValue(Property property) {
        try {
            return this.getRequiredProperty(property).getObject();
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            return null;
        }
    }

    public NodeIterator listPropertyValues(Property property) {
        return new NodeIteratorImpl((Iterator)this.listProperties(property).mapWith(new ObjectMapper()), null);
    }

    public void remove() {
        Object object;
        HashSet hashSet = new HashSet();
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Property property = this.getProfile().FIRST();
        Iterator iterator = this.listProperties();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        iterator = this.getModel().listStatements(null, null, this);
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Resource resource;
            object = (Statement)iterator.next();
            if (object.getPredicate().equals(property) && object.getObject().equals(this)) {
                log.debug((Object)(this.toString() + " is referened from an RDFList, so will not be fully removed"));
                arrayList2.add(object);
                continue;
            }
            if (!(object.getObject() instanceof Resource) || !(resource = object.getResource()).canAs(class$com$hp$hpl$jena$rdf$model$RDFList == null ? OntResourceImpl.class$("com.hp.hpl.jena.rdf.model.RDFList") : class$com$hp$hpl$jena$rdf$model$RDFList)) continue;
            arrayList.add(resource);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (Resource)iterator.next();
            hashSet.addAll(((RDFListImpl)object.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? OntResourceImpl.class$("com.hp.hpl.jena.rdf.model.RDFList") : class$com$hp$hpl$jena$rdf$model$RDFList)).collectStatements());
        }
        hashSet.removeAll(arrayList2);
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((Statement)iterator.next()).remove();
        }
    }

    public void removeProperty(Property property, RDFNode rDFNode) {
        HashSet<Statement> hashSet = new HashSet<Statement>();
        Iterator iterator = this.getModel().listStatements((Resource)this, property, rDFNode);
        while (iterator.hasNext()) {
            hashSet.add(iterator.nextStatement());
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((Statement)iterator.next()).remove();
        }
    }

    public AnnotationProperty asAnnotationProperty() {
        return (AnnotationProperty)this.as(AnnotationProperty.class);
    }

    public OntProperty asProperty() {
        return (OntProperty)this.as(OntProperty.class);
    }

    public ObjectProperty asObjectProperty() {
        return (ObjectProperty)this.as(ObjectProperty.class);
    }

    public DatatypeProperty asDatatypeProperty() {
        return (DatatypeProperty)this.as(DatatypeProperty.class);
    }

    public Individual asIndividual() {
        return (Individual)this.as(Individual.class);
    }

    public OntClass asClass() {
        return (OntClass)this.as(OntClass.class);
    }

    public Ontology asOntology() {
        return (Ontology)this.as(Ontology.class);
    }

    public AllDifferent asAllDifferent() {
        return (AllDifferent)this.as(AllDifferent.class);
    }

    public DataRange asDataRange() {
        return (DataRange)this.as(DataRange.class);
    }

    public boolean isAnnotationProperty() {
        return this.getProfile().ANNOTATION_PROPERTY() != null && this.canAs(AnnotationProperty.class);
    }

    public boolean isProperty() {
        return this.canAs(OntProperty.class);
    }

    public boolean isObjectProperty() {
        return this.getProfile().OBJECT_PROPERTY() != null && this.canAs(ObjectProperty.class);
    }

    public boolean isDatatypeProperty() {
        return this.getProfile().DATATYPE_PROPERTY() != null && this.canAs(DatatypeProperty.class);
    }

    public boolean isIndividual() {
        OntModel ontModel;
        OntModel ontModel2 = ontModel = this.getModel() instanceof OntModel ? (OntModel)this.getModel() : null;
        if (ontModel != null) {
            if (!(ontModel.getGraph() instanceof BasicForwardRuleInfGraph) || ontModel.getProfile().THING() == null) {
                StmtIterator stmtIterator = this.listProperties(RDF.type);
                while (stmtIterator.hasNext()) {
                    Resource resource = stmtIterator.nextStatement().getResource();
                    StmtIterator stmtIterator2 = resource.listProperties(RDF.type);
                    while (stmtIterator2.hasNext()) {
                        if (!((Object)stmtIterator2.nextStatement().getResource()).equals(this.getProfile().CLASS())) continue;
                        return true;
                    }
                }
                return false;
            }
            return this.hasProperty(RDF.type, this.getProfile().THING());
        }
        return this.canAs(Individual.class);
    }

    public boolean isClass() {
        return this.canAs(OntClass.class);
    }

    public boolean isOntology() {
        return this.getProfile().ONTOLOGY() != null && this.canAs(Ontology.class);
    }

    public boolean isDataRange() {
        return this.getProfile().DATARANGE() != null && this.canAs(DataRange.class);
    }

    public boolean isAllDifferent() {
        return this.getProfile().ALL_DIFFERENT() != null && this.canAs(AllDifferent.class);
    }

    protected static boolean hasType(Node node, EnhGraph enhGraph, Resource resource) {
        boolean bl = false;
        ExtendedIterator extendedIterator = enhGraph.asGraph().find(node, RDF.type.asNode(), resource.asNode());
        bl = extendedIterator.hasNext();
        extendedIterator.close();
        return bl;
    }

    protected void checkProfile(Object object, String string) {
        if (object == null) {
            throw new ProfileException(string, this.getProfile());
        }
    }

    protected String selectLang(StmtIterator stmtIterator, String string) {
        String string2 = null;
        while (stmtIterator.hasNext()) {
            RDFNode rDFNode = stmtIterator.nextStatement().getObject();
            if (!(rDFNode instanceof Literal)) continue;
            Literal literal = (Literal)rDFNode;
            String string3 = literal.getLanguage();
            if (string.equalsIgnoreCase(string3)) {
                string2 = literal.getString();
                break;
            }
            if (string3 != null && string3.length() > 1 && string.equalsIgnoreCase(string3.substring(0, 2))) {
                string2 = literal.getString();
                continue;
            }
            if (string2 != null || string3 != null) continue;
            string2 = literal.getString();
        }
        stmtIterator.close();
        return string2;
    }

    protected boolean langTagMatch(String string, String string2) {
        return string == null || string.equalsIgnoreCase(string2) || string2.length() > string.length() && string.equalsIgnoreCase(string2.substring(string.length()));
    }

    protected Object objectAs(Property property, String string, Class clazz) {
        this.checkProfile(property, string);
        try {
            return this.getRequiredProperty(property).getObject().as(clazz);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            return null;
        }
    }

    protected OntResource objectAsResource(Property property, String string) {
        return (OntResource)this.objectAs(property, string, OntResource.class);
    }

    protected OntProperty objectAsProperty(Property property, String string) {
        return (OntProperty)this.objectAs(property, string, OntProperty.class);
    }

    protected int objectAsInt(Property property, String string) {
        this.checkProfile(property, string);
        return this.getRequiredProperty(property).getInt();
    }

    protected ExtendedIterator listAs(Property property, String string, Class clazz) {
        this.checkProfile(property, string);
        return WrappedIterator.create(this.listProperties(property)).mapWith(new ObjectAsMapper(clazz));
    }

    protected void addPropertyValue(Property property, String string, RDFNode rDFNode) {
        this.checkProfile(property, string);
        this.addProperty(property, rDFNode);
    }

    protected void setPropertyValue(Property property, String string, RDFNode rDFNode) {
        this.checkProfile(property, string);
        this.removeAll(property);
        this.addProperty(property, rDFNode);
    }

    protected boolean hasPropertyValue(Property property, String string, RDFNode rDFNode) {
        this.checkProfile(property, string);
        return this.hasProperty(property, rDFNode);
    }

    protected void addListPropertyValue(Property property, String string, RDFNode rDFNode) {
        this.checkProfile(property, string);
        if (this.hasProperty(property)) {
            RDFList rDFList;
            RDFNode rDFNode2 = this.getRequiredProperty(property).getObject();
            if (!rDFNode2.canAs(RDFList.class)) {
                throw new OntologyException("Tried to add a value to a list-valued property " + property + " but the current value is not a list: " + rDFNode2);
            }
            RDFList rDFList2 = (RDFList)rDFNode2.as(RDFList.class);
            if (!rDFList2.contains(rDFNode) && (rDFList = rDFList2.with(rDFNode)) != rDFList2) {
                this.removeAll(property);
                this.addProperty(property, rDFList);
            }
        } else {
            this.addProperty(property, ((OntModel)this.getModel()).createList(new RDFNode[]{rDFNode}));
        }
    }

    protected RDFNode convertToType(Resource resource, String string, Class clazz) {
        this.checkProfile(resource, string);
        if (this.canAs(clazz)) {
            return this.as(clazz);
        }
        this.addProperty(RDF.type, resource);
        return this.as(clazz);
    }

    protected ExtendedIterator listDirectPropertyValues(Property property, String string, Class clazz, Property property2, boolean bl, boolean bl2) {
        Iterator iterator = null;
        this.checkProfile(property, string);
        Property property3 = property;
        if (bl) {
            property3 = this.getModel().getProperty(ReasonerRegistry.makeDirect(property3.getNode()).getURI());
        }
        OntResourceImpl ontResourceImpl = bl2 ? null : this;
        OntResourceImpl ontResourceImpl2 = bl2 ? this : null;
        Map1 map1 = bl2 ? new SubjectAsMapper(clazz) : new ObjectAsMapper(clazz);
        OntModel ontModel = (OntModel)((Object)this.getGraph());
        InfGraph infGraph = null;
        if (ontModel.getGraph() instanceof InfGraph) {
            infGraph = (InfGraph)ontModel.getGraph();
        }
        iterator = !bl || infGraph != null && infGraph.getReasoner().supportsProperty(property3) ? this.getModel().listStatements((Resource)ontResourceImpl, property3, ontResourceImpl2).mapWith(map1) : this.computeDirectValues(property, property2, bl2, ontResourceImpl, ontResourceImpl2, map1);
        return UniqueExtendedIterator.create(iterator);
    }

    private Iterator computeDirectValues(Property property, Property property2, boolean bl, Resource resource, Resource resource2, Map1 map1) {
        Resource resource3;
        Object object;
        ExtendedIterator extendedIterator = this.getModel().listStatements(resource, property, resource2).mapWith(map1);
        List<Resource> list = new ArrayList();
        while (extendedIterator.hasNext()) {
            list.add((Resource)extendedIterator.next());
        }
        ResourceUtils.removeEquiv(list, property2, this);
        boolean bl2 = list.remove(this);
        List list2 = ResourceUtils.partition(list, property2);
        HashMap<Resource, Object> hashMap = new HashMap<Resource, Object>();
        list.clear();
        Object object2 = list2.iterator();
        while (object2.hasNext()) {
            object = (List)object2.next();
            if (object.size() == 1) {
                list.add((Resource)object.get(0));
                continue;
            }
            resource3 = (Resource)object.remove(0);
            hashMap.put(resource3, object);
            list.add(resource3);
        }
        list = ResourceUtils.maximalLowerElements(list, property2, bl);
        object2 = new ArrayList();
        object = list.iterator();
        while (object.hasNext()) {
            resource3 = (Resource)object.next();
            object2.add(resource3);
            if (!hashMap.containsKey(resource3)) continue;
            object2.addAll((List)hashMap.get(resource3));
        }
        if (bl2) {
            object2.add(this);
        }
        return object2.iterator();
    }

    protected void removePropertyValue(Property property, String string, RDFNode rDFNode) {
        this.checkProfile(property, string);
        StmtIterator stmtIterator = this.getModel().listStatements((Resource)this, property, rDFNode);
        if (stmtIterator.hasNext()) {
            stmtIterator.nextStatement().remove();
        }
        stmtIterator.close();
    }

    protected class SingleEqualityFilter
    implements Filter {
        private Object m_obj;

        public SingleEqualityFilter(Object object) {
            this.m_obj = object;
        }

        public boolean accept(Object object) {
            return this.m_obj.equals(object);
        }
    }

    protected class LangTagFilter
    implements Filter {
        protected String m_lang;

        public LangTagFilter(String string) {
            this.m_lang = string;
        }

        public boolean accept(Object object) {
            if (object instanceof Literal) {
                return OntResourceImpl.this.langTagMatch(this.m_lang, ((Literal)object).getLanguage());
            }
            if (object instanceof Statement) {
                return this.accept(((Statement)object).getObject());
            }
            return false;
        }
    }

    protected static class ObjectMapper
    implements Map1 {
        public Object map1(Object object) {
            return object instanceof Statement ? ((Statement)object).getObject() : object;
        }
    }

    protected class ObjectAsStringMapper
    implements Map1 {
        protected ObjectAsStringMapper() {
        }

        public Object map1(Object object) {
            return object instanceof Statement ? ((Statement)object).getString() : object;
        }
    }

    protected static class ObjectAsMapper
    implements Map1 {
        private Class m_as;

        public ObjectAsMapper(Class clazz) {
            this.m_as = clazz;
        }

        public Object map1(Object object) {
            if (object instanceof Statement) {
                RDFNode rDFNode = ((Statement)object).getObject();
                return this.m_as == null ? rDFNode : rDFNode.as(this.m_as);
            }
            return object;
        }
    }

    protected static class SubjectMapper
    implements Map1 {
        protected SubjectMapper() {
        }

        public Object map1(Object object) {
            return object instanceof Statement ? ((Statement)object).getSubject() : object;
        }
    }

    protected static class SubjectAsMapper
    implements Map1 {
        private Class m_as;

        public SubjectAsMapper(Class clazz) {
            this.m_as = clazz;
        }

        public Object map1(Object object) {
            if (object instanceof Statement) {
                Resource resource = ((Statement)object).getSubject();
                return this.m_as == null ? resource : resource.as(this.m_as);
            }
            return object;
        }
    }

    protected static class AsMapper
    implements Map1 {
        private Class m_as;

        public AsMapper(Class clazz) {
            this.m_as = clazz;
        }

        public Object map1(Object object) {
            return object instanceof Resource ? ((Resource)object).as(this.m_as) : object;
        }
    }
}

