/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;

public class ResourceFactory {
    protected static Interface instance = new Impl();

    private ResourceFactory() {
    }

    public static Interface getInstance() {
        return instance;
    }

    public static Interface setInstance(Interface interface_) {
        Interface interface_2 = instance;
        instance = interface_;
        return interface_2;
    }

    public static Resource createResource() {
        return instance.createResource();
    }

    public static Resource createResource(String string) {
        return instance.createResource(string);
    }

    public static Literal createPlainLiteral(String string) {
        return instance.createPlainLiteral(string);
    }

    public static Property createProperty(String string) {
        return instance.createProperty(string);
    }

    public static Property createProperty(String string, String string2) {
        return instance.createProperty(string, string2);
    }

    public static Statement createStatement(Resource resource, Property property, RDFNode rDFNode) {
        return instance.createStatement(resource, property, rDFNode);
    }

    static class Impl
    implements Interface {
        Impl() {
        }

        public Resource createResource() {
            return new ResourceImpl();
        }

        public Resource createResource(String string) {
            return new ResourceImpl(string);
        }

        public Literal createPlainLiteral(String string) {
            return new LiteralImpl(string);
        }

        public Property createProperty(String string) {
            return new PropertyImpl(string);
        }

        public Property createProperty(String string, String string2) {
            return new PropertyImpl(string, string2);
        }

        public Statement createStatement(Resource resource, Property property, RDFNode rDFNode) {
            return new StatementImpl(resource, property, rDFNode);
        }
    }

    public static interface Interface {
        public Resource createResource();

        public Resource createResource(String var1);

        public Literal createPlainLiteral(String var1);

        public Property createProperty(String var1);

        public Property createProperty(String var1, String var2);

        public Statement createStatement(Resource var1, Property var2, RDFNode var3);
    }
}

