/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelMakerCreator;
import com.hp.hpl.jena.rdf.model.ModelMakerCreatorRegistry;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecFactory;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import java.util.HashMap;
import java.util.Map;

public abstract class ModelSpecImpl
implements ModelSpec {
    protected ModelMaker maker;
    private static Map values = new HashMap();
    public static final Model emptyModel = ModelFactory.createDefaultModel();
    public static final Model defaultModel = ModelFactory.createDefaultModel();
    public static final Resource emptyResource = emptyModel.createResource();
    protected Model description = emptyModel;
    protected Resource root = ResourceFactory.createResource("");

    public ModelSpecImpl(ModelMaker modelMaker) {
        if (modelMaker == null) {
            throw new RuntimeException("null maker not allowed");
        }
        this.maker = modelMaker;
    }

    public ModelSpecImpl(Resource resource, Model model) {
        this(ModelSpecImpl.createMaker(ModelSpecImpl.getMaker(resource, model), model));
        this.root = resource;
        this.description = model;
    }

    public abstract Model createModel();

    public Model getModel() {
        return defaultModel;
    }

    public abstract Model createModelOver(String var1);

    public abstract Property getMakerProperty();

    public Model openModel(String string) {
        return ModelFactory.createDefaultModel();
    }

    public Model openModelIfPresent(String string) {
        return null;
    }

    public static Resource getMaker(Resource resource, Model model) {
        StmtIterator stmtIterator = model.listStatements(resource, JenaModelSpec.maker, (RDFNode)null);
        if (stmtIterator.hasNext()) {
            return stmtIterator.nextStatement().getResource();
        }
        Resource resource2 = model.createResource();
        model.add(resource, JenaModelSpec.maker, resource2);
        return resource2;
    }

    public ModelMaker getModelMaker() {
        return this.maker;
    }

    public Model getDescription() {
        return this.getDescription(ResourceFactory.createResource());
    }

    public Model getDescription(Resource resource) {
        return this.addDescription(ModelFactory.createDefaultModel(), resource);
    }

    public Model addDescription(Model model, Resource resource) {
        Resource resource2 = model.createResource();
        model.add(resource, JenaModelSpec.maker, resource2);
        this.maker.addDescription(model, resource2);
        return model;
    }

    public static Resource createValue(Object object) {
        Resource resource = ResourceFactory.createResource();
        values.put(resource, object);
        return resource;
    }

    public static Object getValue(RDFNode rDFNode) {
        return values.get(rDFNode);
    }

    public static Resource findRootByType(Model model, Resource resource) {
        return ModelSpecFactory.findRootByType(ModelSpecFactory.withSchema(model), resource);
    }

    public static ModelMaker createMaker(Model model) {
        Model model2 = ModelSpecFactory.withSchema(model);
        return ModelSpecImpl.createMakerByRoot(ModelSpecFactory.findRootByType(model2, JenaModelSpec.MakerSpec), model2);
    }

    public static ModelMaker createMaker(Resource resource, Model model) {
        return ModelSpecImpl.createMakerByRoot(resource, ModelSpecFactory.withSchema(model));
    }

    public static ModelMaker createMakerByRoot(Resource resource, Model model) {
        Resource resource2 = ModelSpecFactory.findSpecificType((Resource)resource.inModel(model), JenaModelSpec.MakerSpec);
        ModelMakerCreator modelMakerCreator = ModelMakerCreatorRegistry.findCreator(resource2);
        if (modelMakerCreator == null) {
            throw new RuntimeException("no maker type");
        }
        return modelMakerCreator.create(model, resource);
    }

    public static Model readModel(Resource resource) {
        String string = resource.getURI();
        return FileManager.get().loadModel(string);
    }

    protected Model loadFiles(Model model) {
        StmtIterator stmtIterator = this.description.listStatements(this.root, JenaModelSpec.loadWith, (RDFNode)null);
        while (stmtIterator.hasNext()) {
            FileManager.get().readModel(model, stmtIterator.nextStatement().getResource().getURI());
        }
        return model;
    }
}

