/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public class ModelTestBase
extends GraphTestBase {
    protected static Model aModel = ModelTestBase.extendedModel();
    protected static final Model empty = ModelFactory.createDefaultModel();

    public ModelTestBase(String string) {
        super(string);
    }

    protected static Model extendedModel() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefixes(PrefixMapping.Extended);
        return model;
    }

    protected static String nice(RDFNode rDFNode) {
        return ModelTestBase.nice(rDFNode.asNode());
    }

    public static Statement statement(Model model, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Resource resource = ModelTestBase.resource(model, stringTokenizer.nextToken());
        Property property = ModelTestBase.property(model, stringTokenizer.nextToken());
        RDFNode rDFNode = ModelTestBase.rdfNode(model, stringTokenizer.nextToken());
        return model.createStatement(resource, property, rDFNode);
    }

    public static Statement statement(String string) {
        return ModelTestBase.statement(aModel, string);
    }

    public static RDFNode rdfNode(Model model, String string) {
        Node node = Node.create(model, string);
        Class clazz = node.isLiteral() ? Literal.class : Resource.class;
        return (RDFNode)((Object)((ModelCom)model).getNodeAs(node, clazz));
    }

    protected static Resource resource() {
        return ResourceFactory.createResource();
    }

    public static Resource resource(String string) {
        return ModelTestBase.resource(aModel, string);
    }

    public static Resource resource(Model model, String string) {
        return (Resource)ModelTestBase.rdfNode(model, string);
    }

    public static Property property(String string) {
        return ModelTestBase.property(aModel, string);
    }

    public static Property property(Model model, String string) {
        return (Property)ModelTestBase.rdfNode(model, string, Property.class);
    }

    public static Literal literal(Model model, String string) {
        return (Literal)ModelTestBase.rdfNode(model, string, Literal.class);
    }

    public static RDFNode rdfNode(Model model, String string, Class clazz) {
        Node node = Node.create(model, string);
        return (RDFNode)((Object)((ModelCom)model).getNodeAs(node, clazz));
    }

    public static Statement[] statements(Model model, String string) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(ModelTestBase.statement(model, stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new Statement[arrayList.size()]);
    }

    public static Resource[] resources(Model model, String string) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(ModelTestBase.resource(model, stringTokenizer.nextToken()));
        }
        return arrayList.toArray(new Resource[arrayList.size()]);
    }

    public static Model modelAdd(Model model, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            model.add(ModelTestBase.statement(model, stringTokenizer.nextToken()));
        }
        return model;
    }

    public static Model modelWithStatements(String string) {
        return ModelTestBase.modelWithStatements(ReificationStyle.Standard, string);
    }

    public static Model modelWithStatements(ReificationStyle reificationStyle, String string) {
        return ModelTestBase.modelAdd(ModelTestBase.createModel(reificationStyle), string);
    }

    public static Model createModel(ReificationStyle reificationStyle) {
        Model model = ModelFactory.createDefaultModel(reificationStyle);
        model.setNsPrefixes(PrefixMapping.Extended);
        return model;
    }

    public static Model createMemModel() {
        return ModelFactory.createDefaultModel();
    }

    public void assertIsoModels(String string, Model model, Model model2) {
        if (!model.isIsomorphicWith(model2)) {
            Map map = CollectionFactory.createHashedMap();
            ModelTestBase.fail((String)(string + ": expected " + ModelTestBase.nice(model.getGraph(), map) + "\n but had " + ModelTestBase.nice(model2.getGraph(), map)));
        }
    }

    public void assertIsoModels(Model model, Model model2) {
        this.assertIsoModels("models must be isomorphic", model, model2);
    }
}

