/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.impl.EnvironmentFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleClauseCode;
import java.util.ArrayList;
import java.util.List;

public class EnvironmentFrameWithDerivation
extends EnvironmentFrame {
    Node[] argVars = new Node[8];
    Triple[] matches;

    public EnvironmentFrameWithDerivation(RuleClauseCode ruleClauseCode) {
        super(ruleClauseCode);
        if (ruleClauseCode.getRule() != null) {
            this.matches = new Triple[ruleClauseCode.getRule().bodyLength()];
        }
    }

    public void noteMatch(TriplePattern triplePattern, int n) {
        Triple triple = new Triple(LPInterpreter.deref(triplePattern.getSubject()), LPInterpreter.deref(triplePattern.getPredicate()), LPInterpreter.deref(triplePattern.getObject()));
        int n2 = this.clause.termIndex(n);
        if (n2 >= 0) {
            this.matches[n2] = triple;
        }
    }

    public Triple getResult() {
        return new Triple(LPInterpreter.deref(this.argVars[0]), LPInterpreter.deref(this.argVars[1]), LPInterpreter.derefPossFunctor(this.argVars[2]));
    }

    public List getMatchList() {
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        for (int i = 0; i < this.matches.length; ++i) {
            arrayList.add(this.matches[i]);
        }
        return arrayList;
    }

    public void initDerivationRecord(Node[] nodeArray) {
        System.arraycopy(nodeArray, 0, this.argVars, 0, 8);
    }
}

