/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleDerivation;
import com.hp.hpl.jena.reasoner.rulesys.impl.BFRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingStack;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngineI;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FRuleEngine
implements FRuleEngineI {
    protected ForwardRuleInfGraphI infGraph;
    protected List rules;
    protected OneToManyMap clauseIndex;
    protected HashSet predicatesUsed;
    protected boolean wildcardRule;
    protected boolean recordDerivations;
    int nRulesTriggered = 0;
    long nRulesFired = 0L;
    long nAxiomRulesFired = -1L;
    boolean processedAxioms = false;
    protected static Log logger = LogFactory.getLog((Class)FRuleEngine.class);

    public FRuleEngine(ForwardRuleInfGraphI forwardRuleInfGraphI, List list) {
        this.infGraph = forwardRuleInfGraphI;
        this.rules = list;
    }

    public FRuleEngine(ForwardRuleInfGraphI forwardRuleInfGraphI) {
        this.infGraph = forwardRuleInfGraphI;
    }

    public void init(boolean bl, Finder finder) {
        if (this.clauseIndex == null) {
            this.compile(this.rules, bl);
        }
        this.findAndProcessAxioms();
        this.nAxiomRulesFired = this.nRulesFired;
        logger.debug((Object)("Axioms fired " + this.nAxiomRulesFired + " rules"));
        this.fastInit(finder);
    }

    public void fastInit(Finder finder) {
        this.findAndProcessActions();
        BFRuleContext bFRuleContext = new BFRuleContext(this.infGraph);
        if (this.wildcardRule) {
            ExtendedIterator extendedIterator = finder.find(new TriplePattern(null, null, null));
            while (extendedIterator.hasNext()) {
                bFRuleContext.addTriple((Triple)extendedIterator.next());
            }
        } else {
            Iterator iterator = this.predicatesUsed.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                ExtendedIterator extendedIterator = finder.find(new TriplePattern(null, node, null));
                while (extendedIterator.hasNext()) {
                    bFRuleContext.addTriple((Triple)extendedIterator.next());
                }
            }
        }
        this.addSet(bFRuleContext);
    }

    public synchronized void add(Triple triple) {
        BFRuleContext bFRuleContext = new BFRuleContext(this.infGraph);
        bFRuleContext.addTriple(triple);
        this.addSet(bFRuleContext);
    }

    public synchronized boolean delete(Triple triple) {
        return false;
    }

    public long getNRulesFired() {
        return this.nRulesFired;
    }

    public boolean shouldTrace() {
        return true;
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public Object getRuleStore() {
        return new RuleStore(this.clauseIndex, this.predicatesUsed, this.wildcardRule);
    }

    public void setRuleStore(Object object) {
        RuleStore ruleStore = (RuleStore)object;
        this.clauseIndex = ruleStore.clauseIndex;
        this.predicatesUsed = ruleStore.predicatesUsed;
        this.wildcardRule = ruleStore.wildcardRule;
    }

    public void addSet(BFRuleContext bFRuleContext) {
        Triple triple;
        while ((triple = bFRuleContext.getNextTriple()) != null) {
            if (this.infGraph.shouldTrace()) {
                logger.info((Object)("Processing: " + PrintUtil.print(triple)));
            }
            HashSet<Rule> hashSet = new HashSet<Rule>();
            Iterator iterator = this.clauseIndex.getAll(triple.getPredicate());
            Iterator iterator2 = this.clauseIndex.getAll(Node.ANY);
            ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(iterator, iterator2);
            while (concatenatedIterator.hasNext()) {
                ClausePointer clausePointer = (ClausePointer)concatenatedIterator.next();
                if (hashSet.contains(clausePointer.rule)) continue;
                bFRuleContext.resetEnv();
                TriplePattern triplePattern = (TriplePattern)clausePointer.rule.getBodyElement(clausePointer.index);
                if (!FRuleEngine.match(triplePattern, triple, bFRuleContext.getEnvStack())) continue;
                ++this.nRulesTriggered;
                bFRuleContext.setRule(clausePointer.rule);
                if (!this.matchRuleBody(clausePointer.index, bFRuleContext)) continue;
                hashSet.add(clausePointer.rule);
                ++this.nRulesFired;
            }
        }
    }

    public void compile(List list, boolean bl) {
        this.clauseIndex = new OneToManyMap();
        this.predicatesUsed = new HashSet();
        this.wildcardRule = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (bl && rule.isBackward()) continue;
            ClauseEntry[] clauseEntryArray = rule.getBody();
            for (int i = 0; i < clauseEntryArray.length; ++i) {
                if (!(clauseEntryArray[i] instanceof TriplePattern)) continue;
                Node node = ((TriplePattern)clauseEntryArray[i]).getPredicate();
                ClausePointer clausePointer = new ClausePointer(rule, i);
                if (node.isVariable()) {
                    this.clauseIndex.put(Node.ANY, clausePointer);
                    this.wildcardRule = true;
                    continue;
                }
                this.clauseIndex.put(node, clausePointer);
                if (this.wildcardRule) continue;
                this.predicatesUsed.add(node);
            }
        }
        if (this.wildcardRule) {
            this.predicatesUsed = null;
        }
    }

    protected void findAndProcessAxioms() {
        BFRuleContext bFRuleContext = new BFRuleContext(this.infGraph);
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (rule.bodyLength() != 0) continue;
            for (int i = 0; i < rule.headLength(); ++i) {
                ClauseEntry clauseEntry = rule.getHeadElement(i);
                if (!(clauseEntry instanceof TriplePattern)) continue;
                TriplePattern triplePattern = (TriplePattern)clauseEntry;
                Triple triple = new Triple(triplePattern.getSubject(), triplePattern.getPredicate(), triplePattern.getObject());
                bFRuleContext.addTriple(triple);
                this.infGraph.getDeductionsGraph().add(triple);
            }
        }
        this.addSet(bFRuleContext);
        this.processedAxioms = true;
    }

    protected void findAndProcessActions() {
        BFRuleContext bFRuleContext = new BFRuleContext(this.infGraph);
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (rule.bodyLength() != 0) continue;
            for (int i = 0; i < rule.headLength(); ++i) {
                ClauseEntry clauseEntry = rule.getHeadElement(i);
                if (!(clauseEntry instanceof Functor)) continue;
                Functor functor = (Functor)clauseEntry;
                Builtin builtin = functor.getImplementor();
                if (builtin != null) {
                    bFRuleContext.setRule(rule);
                    builtin.headAction(functor.getArgs(), functor.getArgLength(), bFRuleContext);
                    continue;
                }
                throw new ReasonerException("Invoking undefined Functor " + functor.getName() + " in " + rule.toShortString());
            }
        }
    }

    private boolean matchRuleBody(int n, BFRuleContext bFRuleContext) {
        boolean bl;
        Rule rule = bFRuleContext.getRule();
        ClauseEntry[] clauseEntryArray = rule.getBody();
        int n2 = clauseEntryArray.length;
        ArrayList<ClauseEntry> arrayList = new ArrayList<ClauseEntry>(n2 - 1);
        if (n2 > 1) {
            if (n2 == 2) {
                ClauseEntry clauseEntry = clauseEntryArray[n == 0 ? 1 : 0];
                if (clauseEntry instanceof TriplePattern) {
                    arrayList.add(clauseEntry);
                }
            } else {
                int n4;
                int n5 = 0;
                int n6 = -1;
                for (n4 = 0; n4 < n2; ++n4) {
                    TriplePattern triplePattern;
                    int n7;
                    if (n4 == n) continue;
                    BindingStack bindingStack = bFRuleContext.getEnvStack();
                    if (!(clauseEntryArray[n4] instanceof TriplePattern) || (n7 = FRuleEngine.scoreNodeBoundness((triplePattern = (TriplePattern)clauseEntryArray[n4]).getSubject(), bindingStack) * 3 + FRuleEngine.scoreNodeBoundness(triplePattern.getPredicate(), bindingStack) * 2 + FRuleEngine.scoreNodeBoundness(triplePattern.getObject(), bindingStack) * 3) <= n5) continue;
                    n5 = n7;
                    n6 = n4;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    if (n4 == n || n4 == n6 || !(clauseEntryArray[n4] instanceof TriplePattern)) continue;
                    arrayList.add(clauseEntryArray[n4]);
                }
                if (n6 != -1) {
                    arrayList.add(clauseEntryArray[n6]);
                }
            }
        }
        if (bl = this.matchClauseList(arrayList, bFRuleContext)) {
            bFRuleContext.flushPending();
        }
        return bl;
    }

    private boolean matchClauseList(List list, BFRuleContext bFRuleContext) {
        Rule rule = bFRuleContext.getRule();
        BindingStack bindingStack = bFRuleContext.getEnvStack();
        int n = list.size() - 1;
        if (n == -1) {
            ClauseEntry clauseEntry;
            for (int i = 0; i < rule.bodyLength(); ++i) {
                ClauseEntry clauseEntry2 = rule.getBodyElement(i);
                if (!(clauseEntry2 instanceof Functor) || ((Functor)clauseEntry2).evalAsBodyClause(bFRuleContext)) continue;
                return false;
            }
            if (this.infGraph.shouldTrace()) {
                logger.info((Object)("Fired rule: " + rule.toShortString() + " = " + rule.instantiate(bindingStack)));
            }
            ArrayList<Triple> arrayList = null;
            if (this.recordDerivations) {
                arrayList = new ArrayList<Triple>(rule.bodyLength());
                for (int i = 0; i < rule.bodyLength(); ++i) {
                    clauseEntry = rule.getBodyElement(i);
                    if (!(clauseEntry instanceof TriplePattern)) continue;
                    arrayList.add(bindingStack.instantiate((TriplePattern)clauseEntry));
                }
            }
            for (int i = 0; i < rule.headLength(); ++i) {
                Object object;
                clauseEntry = rule.getHeadElement(i);
                if (clauseEntry instanceof TriplePattern) {
                    object = bindingStack.instantiate((TriplePattern)clauseEntry);
                    if (((Triple)object).getSubject().isLiteral() || bFRuleContext.contains((Triple)object)) continue;
                    bFRuleContext.add((Triple)object);
                    if (!this.recordDerivations) continue;
                    this.infGraph.logDerivation((Triple)object, new RuleDerivation(rule, (Triple)object, arrayList, this.infGraph));
                    continue;
                }
                if (clauseEntry instanceof Functor) {
                    object = (Functor)clauseEntry;
                    Builtin builtin = ((Functor)object).getImplementor();
                    if (builtin != null) {
                        builtin.headAction(((Functor)object).getBoundArgs(bindingStack), ((Functor)object).getArgLength(), bFRuleContext);
                        continue;
                    }
                    throw new ReasonerException("Invoking undefined Functor " + ((Functor)object).getName() + " in " + rule.toShortString());
                }
                if (!(clauseEntry instanceof Rule)) continue;
                object = (Rule)clauseEntry;
                if (((Rule)object).isBackward()) {
                    this.infGraph.addBRule(((Rule)object).instantiate(bindingStack));
                    continue;
                }
                throw new ReasonerException("Found non-backward subrule : " + object);
            }
            return true;
        }
        ArrayList arrayList = (ArrayList)((ArrayList)list).clone();
        TriplePattern triplePattern = (TriplePattern)arrayList.remove(n);
        Node node = bindingStack.getBinding(triplePattern.getObject());
        if (Functor.isFunctor(node)) {
            node = null;
        }
        ExtendedIterator extendedIterator = this.infGraph.findDataMatches(bindingStack.getBinding(triplePattern.getSubject()), bindingStack.getBinding(triplePattern.getPredicate()), bindingStack.getBinding(node));
        boolean bl = false;
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            bindingStack.push();
            if (FRuleEngine.match(triplePattern.getPredicate(), triple.getPredicate(), bindingStack) && FRuleEngine.match(triplePattern.getObject(), triple.getObject(), bindingStack) && FRuleEngine.match(triplePattern.getSubject(), triple.getSubject(), bindingStack)) {
                bl |= this.matchClauseList(arrayList, bFRuleContext);
            }
            bindingStack.unwind();
        }
        return bl;
    }

    public static int scoreNodeBoundness(Node node, BindingEnvironment bindingEnvironment) {
        if (node instanceof Node_ANY) {
            return 0;
        }
        if (node instanceof Node_RuleVariable) {
            Node node2 = bindingEnvironment.getGroundVersion(node);
            if (node2 == null) {
                return 1;
            }
            if (node2.equals(RDF.type.asNode())) {
                return 2;
            }
            return 3;
        }
        return 3;
    }

    public static boolean match(TriplePattern triplePattern, Triple triple, BindingStack bindingStack) {
        boolean bl;
        bindingStack.push();
        boolean bl2 = bl = FRuleEngine.match(triplePattern.getPredicate(), triple.getPredicate(), bindingStack) && FRuleEngine.match(triplePattern.getObject(), triple.getObject(), bindingStack) && FRuleEngine.match(triplePattern.getSubject(), triple.getSubject(), bindingStack);
        if (bl) {
            bindingStack.commit();
            return true;
        }
        bindingStack.unwind();
        return false;
    }

    public static boolean match(Node node, Node node2, BindingStack bindingStack) {
        if (node instanceof Node_RuleVariable) {
            int n = ((Node_RuleVariable)node).getIndex();
            return bindingStack.bind(n, node2);
        }
        if (node instanceof Node_ANY) {
            return true;
        }
        if (Functor.isFunctor(node)) {
            Node[] nodeArray;
            if (!Functor.isFunctor(node2)) {
                return false;
            }
            Functor functor = (Functor)node.getLiteral().getValue();
            Functor functor2 = (Functor)node2.getLiteral().getValue();
            if (!functor.getName().equals(functor2.getName())) {
                return false;
            }
            Node[] nodeArray2 = functor.getArgs();
            if (nodeArray2.length != (nodeArray = functor2.getArgs()).length) {
                return false;
            }
            bindingStack.push();
            boolean bl = true;
            for (int i = 0; i < nodeArray2.length; ++i) {
                if (FRuleEngine.match(nodeArray2[i], nodeArray[i], bindingStack)) continue;
                bl = false;
                break;
            }
            if (bl) {
                bindingStack.commit();
                return true;
            }
            bindingStack.unwind();
            return false;
        }
        return node.sameValueAs(node2);
    }

    public static class RuleStore {
        protected OneToManyMap clauseIndex;
        protected HashSet predicatesUsed;
        protected boolean wildcardRule;

        RuleStore(OneToManyMap oneToManyMap, HashSet hashSet, boolean bl) {
            this.clauseIndex = oneToManyMap;
            this.predicatesUsed = hashSet;
            this.wildcardRule = bl;
        }
    }

    protected static class ClausePointer {
        protected Rule rule;
        protected int index;

        ClausePointer(Rule rule, int n) {
            this.rule = rule;
            this.index = n;
        }

        TriplePattern getClause() {
            return (TriplePattern)this.rule.getBodyElement(this.index);
        }
    }
}

