/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleClauseCode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LPRuleStore
extends RuleStore {
    protected boolean isCompiled = false;
    protected Map predicateToCodeMap;
    protected ArrayList allRuleClauseCodes;
    protected Map indexPredicateToCodeMap;
    protected HashSet tabledPredicates = new HashSet();
    private static final int INDEX_THRESHOLD = 20;
    protected boolean allTabled = false;

    public LPRuleStore(List list) {
        super(list);
    }

    public LPRuleStore() {
    }

    public void addAll(LPRuleStore lPRuleStore) {
        super.addAll(lPRuleStore);
        this.tabledPredicates.addAll(lPRuleStore.tabledPredicates);
        this.allTabled = this.tabledPredicates.contains(Node.ANY);
    }

    public synchronized void tablePredicate(Node node) {
        this.tabledPredicates.add(node);
        if (node == Node.ANY) {
            this.allTabled = true;
        }
    }

    public List codeFor(Node node) {
        if (!this.isCompiled) {
            this.compileAll();
        }
        if (node.isVariable()) {
            return this.allRuleClauseCodes;
        }
        List list = (List)this.predicateToCodeMap.get(node);
        if (list == null) {
            list = (List)this.predicateToCodeMap.get(Node_RuleVariable.WILD);
        }
        return list;
    }

    public List codeFor(TriplePattern triplePattern) {
        List list;
        List list2 = this.codeFor(triplePattern.getPredicate());
        if (list2 == null) {
            return list2;
        }
        Map map = (Map)this.indexPredicateToCodeMap.get(triplePattern.getPredicate());
        if (map != null && (list = (List)map.get(triplePattern.getObject())) != null) {
            return list;
        }
        return list2;
    }

    public boolean isIndexedPredicate(Node node) {
        return this.indexPredicateToCodeMap.get(node) != null;
    }

    public boolean isTabled(TriplePattern triplePattern) {
        return this.isTabled(triplePattern.getPredicate());
    }

    public boolean isTabled(Node node) {
        if (this.allTabled) {
            return true;
        }
        if (node.isVariable() && !this.tabledPredicates.isEmpty()) {
            return true;
        }
        return this.tabledPredicates.contains(node);
    }

    protected void compileAll() {
        ArrayList<Object> arrayList;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.isCompiled = true;
        this.predicateToCodeMap = new HashMap();
        this.allRuleClauseCodes = new ArrayList();
        this.indexPredicateToCodeMap = new HashMap();
        Object object5 = this.getAllRules().iterator();
        while (object5.hasNext()) {
            object4 = (Rule)object5.next();
            object3 = ((Rule)object4).getHeadElement(0);
            if (!(object3 instanceof TriplePattern)) continue;
            object2 = new RuleClauseCode((Rule)object4);
            this.allRuleClauseCodes.add(object2);
            object = ((TriplePattern)object3).getPredicate();
            if (((Node)object).isVariable()) {
                object = Node_RuleVariable.WILD;
            }
            if ((arrayList = (ArrayList<Object>)this.predicateToCodeMap.get(object)) == null) {
                arrayList = new ArrayList<Object>();
                this.predicateToCodeMap.put(object, arrayList);
            }
            arrayList.add(object2);
            if (arrayList.size() <= 20) continue;
            this.indexPredicateToCodeMap.put(object, new HashMap());
        }
        object5 = (List)this.predicateToCodeMap.get(Node_RuleVariable.WILD);
        if (object5 != null) {
            object4 = this.predicateToCodeMap.entrySet().iterator();
            while (object4.hasNext()) {
                object3 = (Map.Entry)object4.next();
                object2 = (Node)object3.getKey();
                object = (List)object3.getValue();
                if (object2 == Node_RuleVariable.WILD) continue;
                object.addAll(object5);
            }
        }
        this.indexPredicateToCodeMap.put(Node_RuleVariable.WILD, new HashMap());
        object4 = this.indexPredicateToCodeMap.entrySet().iterator();
        while (object4.hasNext()) {
            Object object6;
            Object object7;
            object3 = object4.next();
            object2 = (Node)object3.getKey();
            object = (HashMap)object3.getValue();
            arrayList = new ArrayList();
            ArrayList arrayList2 = ((Node)object2).isVariable() ? this.allRuleClauseCodes : (List)this.predicateToCodeMap.get(object2);
            Iterator<Object> iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Node node;
                object7 = (RuleClauseCode)iterator.next();
                object6 = ((RuleClauseCode)object7).getRule().getHeadElement(0);
                boolean bl = false;
                if (object6 instanceof TriplePattern && !(node = ((TriplePattern)object6).getObject()).isVariable() && !Functor.isFunctor(node)) {
                    ArrayList<Object> arrayList3 = (ArrayList<Object>)((HashMap)object).get(node);
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<Object>();
                        ((HashMap)object).put(node, arrayList3);
                    }
                    arrayList3.add(object7);
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(object7);
            }
            iterator = ((HashMap)object).entrySet().iterator();
            while (iterator.hasNext()) {
                object7 = (Map.Entry)iterator.next();
                object6 = (Node)object7.getKey();
                List list = (List)object7.getValue();
                list.addAll(arrayList);
            }
        }
        object4 = this.allRuleClauseCodes.iterator();
        while (object4.hasNext()) {
            object3 = (RuleClauseCode)((Object)object4.next());
            ((RuleClauseCode)object3).compile(this);
        }
    }

    protected void doAddRemoveRule(Rule rule, boolean bl) {
        this.isCompiled = false;
        super.doAddRemoveRule(rule, bl);
    }
}

