/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.math.BigInteger;

class DiHyperCube {
    private final Resource[] corners;
    private final int dim;
    private final Model model;
    private int id = 2000;

    public DiHyperCube(int n, Model model) {
        int n2;
        this.dim = n;
        this.model = model;
        this.corners = new Resource[1 << this.dim];
        for (n2 = 0; n2 < this.corners.length; ++n2) {
            this.corners[n2] = model.createResource();
        }
        for (n2 = 0; n2 < this.corners.length; ++n2) {
            this.addDown(n2, this.corners[n2]);
        }
    }

    private void addDown(int n, Resource resource) {
        for (int i = 0; i < this.dim; ++i) {
            int n2 = 1 << i;
            if ((n & n2) == 0) continue;
            this.model.add(resource, RDF.value, this.corners[n ^ n2]);
        }
    }

    DiHyperCube dupe(int n) {
        Resource resource = this.model.createResource();
        for (int i = 0; i < this.dim; ++i) {
            int n2 = 1 << i;
            if ((n & n2) != 0) {
                this.model.add(resource, RDF.value, this.corners[n ^ n2]);
                continue;
            }
            this.model.add(this.corners[n ^ n2], RDF.value, resource);
        }
        return this;
    }

    static int bitCount(int n) {
        return BigInteger.valueOf(n).bitCount();
    }

    static boolean equal(int n, int n2) {
        return DiHyperCube.bitCount(n) == DiHyperCube.bitCount(n2);
    }

    static boolean equal(int n, int n2, int n4, int n5) {
        return DiHyperCube.bitCount(n ^ n2) == DiHyperCube.bitCount(n4 ^ n5) && DiHyperCube.bitCount(n & n2) == DiHyperCube.bitCount(n4 & n5) && DiHyperCube.bitCount(n | n2) == DiHyperCube.bitCount(n4 | n5) && Math.min(DiHyperCube.bitCount(n), DiHyperCube.bitCount(n2)) == Math.min(DiHyperCube.bitCount(n4), DiHyperCube.bitCount(n5));
    }
}

