/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.Locator;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LocatorZip
implements Locator {
    static Log log = LogFactory.getLog((Class)LocatorZip.class);
    String zipFileName = null;
    ZipFile zipFile = null;

    public LocatorZip(String string) {
        try {
            this.zipFileName = string;
            this.zipFile = new ZipFile(this.zipFileName);
        }
        catch (IOException iOException) {
            throw new JenaException("Problems accessing " + this.zipFileName, iOException);
        }
    }

    public InputStream open(String string) {
        ZipEntry zipEntry = this.zipFile.getEntry(string);
        if (zipEntry == null) {
            if (FileManager.logAllLookups && log.isDebugEnabled()) {
                log.debug((Object)("Not found: " + this.zipFileName + " : " + string));
            }
            return null;
        }
        try {
            InputStream inputStream = this.zipFile.getInputStream(zipEntry);
            if (inputStream == null) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace((Object)("Not found: " + string));
                }
                return null;
            }
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Found: " + string));
            }
            return inputStream;
        }
        catch (IOException iOException) {
            log.warn((Object)("IO Exception opening zip entry: " + string));
            return null;
        }
    }

    public String getName() {
        return "LocatorZip(" + this.zipFileName + ")";
    }
}

