/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryElement;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.query.core.TripleCollector;
import com.hp.hpl.jena.query.util.ListUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementGroup
extends Element
implements TripleCollector {
    static Log log = LogFactory.getLog((Class)ElementGroup.class);
    List elements = new ArrayList();

    public void addElement(QueryElement queryElement) {
        this.elements.add(queryElement);
    }

    public void addTriple(Triple triple) {
        this.elements.add(new ElementTriplePattern(triple));
    }

    public int mark() {
        return this.elements.size();
    }

    public void addTriple(int n, Triple triple) {
        this.elements.add(n, new ElementTriplePattern(triple));
    }

    public List getElements() {
        return this.elements;
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator, DataSet dataSet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("Group: " + this.elements.size() + " elements"));
        }
        if (this.elements.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)mark.msg("exec: Empty group"));
            }
            return queryIterator;
        }
        if (this.elements.size() == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)mark.msg("  exec: Only one element in group"));
            }
            QueryElement queryElement = (QueryElement)this.elements.get(0);
            Mark mark2 = new Mark(mark);
            mark2.incDepth();
            return queryElement.exec(mark2, queryIterator, dataSet);
        }
        int n = 0;
        int n2 = mark.getDepth() + 1;
        ListIterator listIterator = this.elements.listIterator();
        QueryIterator queryIterator2 = queryIterator;
        while (listIterator.hasNext()) {
            QueryIterator queryIterator3;
            QueryElement queryElement = (QueryElement)listIterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)mark.msg("[" + n + "] create element iterator"));
            }
            Mark mark3 = new Mark(n2, n);
            queryIterator2 = queryIterator3 = queryElement.exec(mark3, queryIterator2, dataSet);
            ++n;
        }
        return queryIterator2;
    }

    public void phase2(Query query2) {
        boolean bl = false;
        Object object = this.getElements().iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            element.phase2(query2);
            if (!(element instanceof ElementTriplePattern)) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.compressTriplePatterns();
        ListUtils.removeNulls(this.elements);
        if (this.elements.size() == 1 && this.elements.get(0) instanceof ElementGroup) {
            System.out.println("reducing");
            object = (ElementGroup)this.elements.get(0);
            this.elements = ((ElementGroup)object).elements;
        }
    }

    private void compressTriplePatterns() {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element element;
            int n;
            Element element2 = (Element)this.elements.get(i);
            if (!(element2 instanceof ElementTriplePattern)) continue;
            ElementTriplePattern elementTriplePattern = (ElementTriplePattern)element2;
            ElementBasePattern elementBasePattern = new ElementBasePattern();
            elementBasePattern.addTriple(elementTriplePattern.getTriple());
            this.elements.set(i, elementBasePattern);
            for (n = i + 1; n < this.elements.size() && (element = (Element)this.elements.get(n)) instanceof ElementTriplePattern; ++n) {
                ElementTriplePattern elementTriplePattern2 = (ElementTriplePattern)element;
                elementBasePattern.addTriple(elementTriplePattern2.getTriple());
                this.elements.set(n, null);
            }
            i = n;
        }
    }

    protected void varsRequired(Set set) {
        Iterator iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.varsRequired(set);
        }
    }

    protected void varsBound(Set set) {
        Iterator iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            element.varsBound(set);
        }
    }

    public void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }
}

