/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.resultset.ResultSetProcessor;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class XMLOutput
implements ResultSetProcessor {
    static final int INDENT = 2;
    String stylesheetURL = null;
    IndentedWriter out;
    int bNodeCounter = 0;
    Map bNodeMap = new HashMap();
    boolean xmlInst = true;
    public static final String dfNamespace = "http://www.w3.org/2001/sw/DataAccess/rf1/result";
    public static final String dfRootTag = "sparql";
    public static final String dfHead = "head";
    public static final String dfVariable = "variable";
    public static final String dfAttrVarName = "name";
    public static final String dfResults = "results";
    public static final String dfSolution = "result";

    public XMLOutput(OutputStream outputStream, String string) {
        this(new IndentedWriter(outputStream), string);
    }

    public XMLOutput(IndentedWriter indentedWriter, String string) {
        this.out = indentedWriter;
        this.stylesheetURL = string;
    }

    public void start(ResultSet resultSet) {
        if (this.xmlInst) {
            this.out.println("<?xml version=\"1.0\"?>");
        }
        if (this.stylesheetURL != null) {
            this.out.println("<?xml-stylesheet type=\"text/xsl\" href=\"" + this.stylesheetURL + "\"?>");
        }
        this.out.println("<sparql");
        this.out.incIndent(2);
        this.out.println("xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        this.out.println("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"");
        this.out.println("xmlns=\"http://www.w3.org/2001/sw/DataAccess/rf1/result\" >");
        this.out.decIndent(2);
        this.out.incIndent(2);
        this.out.println("<head>");
        Iterator iterator = resultSet.getResultVars().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.out.incIndent(2);
            this.out.print("<");
            this.out.print(dfVariable);
            this.out.print(" name=\"" + string + "\"");
            this.out.println("/>");
            this.out.decIndent(2);
        }
        this.out.println("</head>");
        this.out.decIndent(2);
        this.out.incIndent(2);
        this.out.println("<results>");
        this.out.incIndent(2);
    }

    public void finish(ResultSet resultSet) {
        this.out.decIndent(2);
        this.out.println("</results>");
        this.out.decIndent(2);
        this.out.println("</sparql>");
        this.out.flush();
    }

    public void start(QuerySolution querySolution) {
        this.out.println("<result>");
        this.out.incIndent(2);
    }

    public void finish(QuerySolution querySolution) {
        this.out.decIndent(2);
        this.out.println("</result>");
    }

    public void binding(String string, RDFNode rDFNode) {
        this.out.print("<");
        this.out.print(string);
        if (rDFNode == null) {
            this.out.println(" bound=\"false\"/>");
            return;
        }
        if (rDFNode instanceof Literal) {
            this.printLiteral((Literal)rDFNode);
            this.out.print("</" + string + ">");
            this.out.println();
            return;
        }
        if (rDFNode instanceof Resource) {
            this.printResource((Resource)rDFNode);
            this.out.println();
            return;
        }
        LogFactory.getLog(this.getClass()).warn((Object)("Unknown RDFNode type in result set: " + rDFNode.getClass()));
        this.out.println("/>");
    }

    void printLiteral(Literal literal) {
        String string = literal.getDatatypeURI();
        String string2 = literal.getLanguage();
        if (string2 != null && string2.length() != 0) {
            this.out.print(" xml:lang=\"" + string2 + "\"");
        }
        if (string != null && !string.equals("")) {
            this.out.print(" rdf:datatype=\"" + string + "\"");
        }
        this.out.print(">");
        this.out.print(XMLOutput.xml_escape(literal.getLexicalForm()));
    }

    void printResource(Resource resource) {
        if (resource.isAnon()) {
            if (!this.bNodeMap.containsKey(resource)) {
                this.bNodeMap.put(resource, "b" + this.bNodeCounter++);
            }
            String string = (String)this.bNodeMap.get(resource);
            this.out.print(" bnodeid=\"" + string + "\"/>");
        } else {
            this.out.print(" uri=\"" + XMLOutput.xml_escape(resource.getURI()) + "\"/>");
        }
    }

    static String xml_escape(String string) {
        String string2 = string;
        string2 = string2.replaceAll("&", "&amp;");
        string2 = string2.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        return string2;
    }
}

