/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.query.util.ClosureTest;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Closure {
    private static Log logger = LogFactory.getLog((String)Closure.class.getName());

    public static Model closure(Statement statement) {
        return Closure.closure(statement, new ClosureBNode());
    }

    public static Model closure(Statement statement, ClosureTest closureTest) {
        return Closure.closure(statement, closureTest, ModelFactory.createDefaultModel());
    }

    public static Model closure(Statement statement, Model model) {
        return Closure.closure(statement, (ClosureTest)new ClosureBNode(), model);
    }

    public static Model closure(Statement statement, ClosureTest closureTest, Model model) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("closure: " + statement));
        }
        ArrayList arrayList = new ArrayList();
        Closure.closure(statement, model, arrayList, closureTest);
        return model;
    }

    public static Model closure(Resource resource, boolean bl) {
        return Closure.closure(resource, (ClosureTest)new ClosureBNode(), bl);
    }

    public static Model closure(Resource resource, ClosureTest closureTest, boolean bl) {
        return Closure.closure(resource, closureTest, bl, ModelFactory.createDefaultModel());
    }

    public static Model closure(Resource resource, boolean bl, Model model) {
        return Closure.closure(resource, new ClosureBNode(), bl, model);
    }

    public static Model closure(Resource resource, ClosureTest closureTest, boolean bl, Model model) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("closure: " + resource));
        }
        ArrayList arrayList = new ArrayList();
        if (!bl) {
            Closure.closureNoTest(resource, model, arrayList, closureTest);
        } else {
            Closure.closure((RDFNode)resource, model, arrayList, closureTest);
        }
        return model;
    }

    private static void closure(Statement statement, Model model, Collection collection, ClosureTest closureTest) {
        if (logger.isDebugEnabled()) {
            logger.trace((Object)statement.toString());
        }
        if (closureTest.includeStmt(statement)) {
            model.add(statement);
        }
        Closure.closure((RDFNode)statement.getSubject(), model, collection, closureTest);
        Closure.closure(statement.getObject(), model, collection, closureTest);
    }

    private static void closure(RDFNode rDFNode, Model model, Collection collection, ClosureTest closureTest) {
        if (!(rDFNode instanceof Resource)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("  Not a resource: " + rDFNode));
            }
            return;
        }
        Resource resource = (Resource)rDFNode;
        if (collection.contains(resource)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("  Already visited: " + resource));
            }
            return;
        }
        if (!closureTest.traverse(resource)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("  End traverse: " + resource));
            }
            return;
        }
        Closure.closureNoTest(resource, model, collection, closureTest);
    }

    private static void closureNoTest(Resource resource, Model model, Collection collection, ClosureTest closureTest) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("@ " + resource + " :: " + model.size() + " //" + Closure.dbg_string(collection)));
        }
        collection.add(resource);
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Closure.closure(statement, model, collection, closureTest);
        }
    }

    private static String dbg_string(Collection collection) {
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = string + " " + iterator.next().toString();
        }
        return string;
    }

    public static class ClosureReachable
    implements ClosureTest {
        public boolean traverse(Resource resource) {
            return true;
        }

        public boolean includeStmt(Statement statement) {
            return true;
        }
    }

    public static class ClosureBNode
    implements ClosureTest {
        public boolean traverse(Resource resource) {
            return resource.isAnon();
        }

        public boolean includeStmt(Statement statement) {
            return true;
        }
    }
}

