/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util;

import com.hp.hpl.jena.query.util.JenaURIException;
import com.hp.hpl.jena.query.util.RelativeURIException;
import com.hp.hpl.jena.query.util.URIException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.LogFactory;

public class RelURI {
    private static String globalBase = null;

    public static String resolve(String string, String string2) {
        if (string2 == null) {
            throw new JenaURIException("Null base for relative URI resolution");
        }
        if (string2.length() == 0) {
            throw new JenaURIException("Empty base for relative URI resolution");
        }
        if (string2.endsWith("#")) {
            throw new JenaURIException("Base URI ends in #");
        }
        if (string.equals("")) {
            if (string2.endsWith("#")) {
                return string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        URI uRI = null;
        try {
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new URIException("Illegal URI (base): " + string2);
        }
        if (!uRI.isAbsolute()) {
            throw new RelativeURIException("Relative URI for base: " + string2);
        }
        if (uRI.isOpaque()) {
            throw new RelativeURIException("Can't resolve a relative URI against an opaquer URI: rel=" + string + " : base=" + string2);
        }
        URI uRI2 = null;
        try {
            uRI2 = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new URIException("Illegal relative URI: " + string);
        }
        URI uRI3 = RelURI.resolve(uRI2, uRI);
        if (uRI3 == null) {
            return null;
        }
        String string3 = uRI3.toString();
        if (string3.startsWith("file:/") && !string3.startsWith("file:///")) {
            string3 = (string3 = string3.substring("file:".length())).startsWith("//") ? "file:/" + string3 : "file://" + string3;
        }
        return string3;
    }

    private static URI resolve(URI uRI, URI uRI2) {
        URI uRI3 = uRI2.resolve(uRI);
        if (!uRI3.isAbsolute()) {
            return null;
        }
        return uRI3;
    }

    public static String resolve(String string) {
        if (globalBase == null) {
            globalBase = RelURI.chooseBaseURI();
        }
        return RelURI.resolve(string, globalBase);
    }

    public static void setBaseURI(String string) {
        if (string != null && string.startsWith("file:/") && !string.startsWith("file:///")) {
            LogFactory.getLog((Class)RelURI.class).warn((Object)"setBaseURI: File URIs should look like 'file:///path' (or at least file://host/path)");
        }
        globalBase = string;
    }

    public static String getBaseURI() {
        return globalBase;
    }

    public static String chooseBaseURI() {
        return RelURI.chooseBaseURI(null);
    }

    public static String chooseBaseURI(String string) {
        String string2;
        if (string == null) {
            string = "file:.";
        }
        if ((string2 = FileUtils.getScheme((String)string)) == null) {
            string2 = "file";
            string = "file:" + string;
        }
        if (string2.equals("file") && !string.startsWith("file:///")) {
            try {
                String string3 = string.substring("file:".length());
                File file = new File(string3);
                String string4 = file.getCanonicalPath();
                string4 = string4.replace('\\', '/');
                if (string4.indexOf(32) >= 0) {
                    string4 = string4.replaceAll(" ", "%20");
                }
                string = string4.startsWith("/") ? "file://" + string4 : "file:///" + string4;
                if (file.isDirectory() && !string.endsWith("/")) {
                    string = string + "/";
                }
            }
            catch (IOException iOException) {
                LogFactory.getLog((Class)RelURI.class).warn((Object)"IOException in chooseBase - ignored");
                return null;
            }
        }
        return string;
    }

    public static String resolveFileURL(String string) {
        String string2 = string;
        try {
            if (string2.indexOf(92) > -1) {
                string2 = string2.replace('\\', '/');
            }
            if (string2.startsWith("file:///")) {
                return string2;
            }
            if (string2.startsWith("file://")) {
                return string2;
            }
            if (string2.startsWith("file:/")) {
                string2 = string.substring("file:/".length());
                return "file:///" + string2;
            }
            if (string2.startsWith("file:")) {
                string2 = string.substring("file:".length());
            }
            File file = new File(string2);
            string2 = string2.endsWith("/") ? file.getAbsolutePath() + "/" : file.getCanonicalPath();
            string2 = string2.replace('\\', '/');
            string2 = string2.startsWith("/") ? "file://" + string2 : "file:///" + string2;
            return string2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(RelURI.resolveFileURL("file:a"));
        System.out.println(RelURI.resolveFileURL("."));
        System.out.println(RelURI.resolveFileURL("/home/afs"));
        System.out.println();
        RelURI.t(null);
        RelURI.t(".");
        RelURI.t("file:.");
        RelURI.t("/foo");
        RelURI.t("/foo/");
        RelURI.t("foo");
    }

    static void t(String string) {
        System.out.println("Choose base: " + string + " => " + RelURI.chooseBaseURI(string));
    }
}

