/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util.iterator;

import com.hp.hpl.jena.query.core.ARQInternalErrorException;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.query.core.QueryIteratorUtil;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterFilter
implements QueryIterator {
    private static Log log = LogFactory.getLog((Class)QueryIterFilter.class);
    QueryIterator iter;
    Filter f;
    Object nextObject;
    boolean finished;

    public QueryIterFilter(Filter filter, QueryIterator queryIterator) {
        this.iter = queryIterator;
        this.f = filter;
        this.nextObject = null;
        this.finished = false;
    }

    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.nextObject != null) {
            return true;
        }
        if (this.iter == null) {
            LogFactory.getLog((Class)QueryIterFilter.class).fatal((Object)"Null iterator");
            throw new ARQInternalErrorException(QueryIterFilter.class.getName() + ": Null iterator");
        }
        while (this.iter.hasNext()) {
            this.nextObject = this.iter.next();
            if (!this.f.accept(this.nextObject)) continue;
            QueryIteratorUtil.reportHasNext(log, null, true);
            return true;
        }
        this.iter.close();
        this.nextObject = null;
        this.close();
        return false;
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    public Object next() {
        if (this.hasNext()) {
            Object object = this.nextObject;
            this.nextObject = null;
            return object;
        }
        throw new NoSuchElementException();
    }

    public void close() {
        if (this.finished) {
            return;
        }
        if (this.iter != null) {
            this.iter.close();
        }
        this.finished = true;
    }

    public static interface Filter {
        public static final Filter any = new Filter(){

            public final boolean accept(Object object) {
                return true;
            }
        };

        public boolean accept(Object var1);
    }
}

