/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import java.util.Collection;

public class FacetCheckingFrameStore
extends FrameStoreAdapter {
    public void setFrameName(Frame frame, String string) {
        this.getDelegate().setFrameName(frame, string);
    }

    private static void checkAbstract(Collection collection) {
        for (Cls cls : collection) {
            if (!cls.isAbstract()) continue;
            throw new AbstractClassException();
        }
    }

    public Cls createCls(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        FacetCheckingFrameStore.checkAbstract(collection);
        return this.getDelegate().createCls(frameID, string, collection, collection2, bl);
    }

    public Slot createSlot(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        FacetCheckingFrameStore.checkAbstract(collection);
        return this.getDelegate().createSlot(frameID, string, collection, collection2, bl);
    }

    public Facet createFacet(FrameID frameID, String string, Collection collection, boolean bl) {
        FacetCheckingFrameStore.checkAbstract(collection);
        return this.getDelegate().createFacet(frameID, string, collection, bl);
    }

    public SimpleInstance createSimpleInstance(FrameID frameID, String string, Collection collection, boolean bl) {
        FacetCheckingFrameStore.checkAbstract(collection);
        return this.getDelegate().createSimpleInstance(frameID, string, collection, bl);
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        this.checkOwnSlotValues(frame, slot, collection);
        this.getDelegate().setDirectOwnSlotValues(frame, slot, collection);
    }

    private void checkOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        for (Facet facet : this.getOwnFacets(frame, slot)) {
            if (facet.areValidValues(frame, slot, collection)) continue;
            throw new FacetException();
        }
    }

    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        this.checkTemplateSlotValues(cls, slot, collection);
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, collection);
    }

    private void checkTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        for (Facet facet : this.getTemplateFacets(cls, slot)) {
            if (facet.areValidValues(cls, slot, collection)) continue;
            throw new FacetException();
        }
    }

    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        this.checkTemplateFacetValues(cls, slot, facet, collection);
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, collection);
    }

    private void checkTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        Slot slot2 = facet.getAssociatedSlot();
        if (slot2 == null) {
            throw new FacetException();
        }
        this.checkOwnSlotValues(slot, slot2, collection);
    }

    public static class FacetException
    extends IllegalArgumentException {
    }

    public static class AbstractClassException
    extends IllegalArgumentException {
    }
}

