/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ServerProjectPanel
extends JPanel {
    private RemoteServer _server;
    private RemoteSession _session;
    private JTable _projectTable;

    public ServerProjectPanel(RemoteServer remoteServer, RemoteSession remoteSession) {
        this._server = remoteServer;
        this._session = remoteSession;
        this._projectTable = ComponentFactory.createTable(null);
        this.setLayout(new BorderLayout());
        this.add(ComponentFactory.createScrollPane(this._projectTable));
        this.loadTable();
        this.setMinimumSize(new Dimension(400, 300));
    }

    private void loadTable() {
        try {
            Collection collection = this._server.getAvailableProjectNames(this._session);
            Iterator iterator = collection.iterator();
            Object[][] objectArray = new Object[collection.size()][2];
            for (int i = 0; i < collection.size(); ++i) {
                String string = (String)iterator.next();
                objectArray[i][0] = string;
                objectArray[i][1] = ServerProjectPanel.sessionsToString(this._server.getCurrentSessions(string, this._session));
            }
            Object[] objectArray2 = new Object[]{"Project", "Current Users"};
            this._projectTable.setModel(new DefaultTableModel(objectArray, objectArray2));
            this._projectTable.createDefaultColumnsFromModel();
            this._projectTable.setRowSelectionInterval(0, 0);
        }
        catch (RemoteException remoteException) {
            Log.getLogger().severe(Log.toString(remoteException));
        }
    }

    private static String sessionsToString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Session session : collection) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(session.getUserName() + " (" + session.getUserIpAddress() + ")");
        }
        return stringBuffer.toString();
    }

    public String getProjectName() {
        int n = this._projectTable.getSelectedRow();
        String string = n < 0 ? null : (String)this._projectTable.getValueAt(n, 0);
        return string;
    }
}

