/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.narrowframestore;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.server.narrowframestore.RemoteServerNarrowFrameStore;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteClientInvocationHandler
implements InvocationHandler {
    private static transient Logger log;
    private KnowledgeBase kb;
    private RemoteServerNarrowFrameStore delegate;
    private static Map<Method, Method> methodMap;

    public RemoteClientInvocationHandler(KnowledgeBase knowledgeBase, RemoteServerNarrowFrameStore remoteServerNarrowFrameStore) {
        this.kb = knowledgeBase;
        this.delegate = remoteServerNarrowFrameStore;
    }

    public NarrowFrameStore getNarrowFrameStore() {
        return (NarrowFrameStore)Proxy.newProxyInstance(NarrowFrameStore.class.getClassLoader(), new Class[]{NarrowFrameStore.class}, (InvocationHandler)this);
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        ClassLoader classLoader;
        Object object2;
        Object[] objectArray2;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Client invoking remote operation " + method.getName() + " on object " + this.delegate.getClass());
            if (objectArray != null) {
                objectArray2 = objectArray;
                int n = objectArray2.length;
                for (int i = 0; i < n; ++i) {
                    object2 = objectArray2[i];
                    log.fine("\tArgument = " + object2);
                }
            } else {
                log.fine("No arguments");
            }
        }
        if ((objectArray2 = Thread.currentThread().getContextClassLoader()) != (classLoader = this.kb.getClass().getClassLoader())) {
            if (log.isLoggable(Level.FINE)) {
                Log.getLogger().fine("Changing loader from " + objectArray2 + " to " + classLoader);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            Method method2 = methodMap.get(method);
            object2 = method2.invoke((Object)this.delegate, objectArray);
            LocalizeUtils.localize(object2, this.kb);
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            object2 = invocationTargetException.getCause();
            if (object2 instanceof RemoteException) {
                throw new RuntimeException((Throwable)object2);
            }
            throw object2;
        }
    }

    static {
        Method[] methodArray;
        log = Log.getLogger(RemoteClientInvocationHandler.class);
        methodMap = new HashMap<Method, Method>();
        for (Method method : methodArray = NarrowFrameStore.class.getMethods()) {
            try {
                Method method2 = RemoteServerNarrowFrameStore.class.getMethod(method.getName(), method.getParameterTypes());
                methodMap.put(method, method2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Mapped " + method + " to " + method2);
                }
            }
            catch (Exception exception) {
                log.warning("NarrowFrameStore method " + method + " not found in RemoteServerNarrowFrameStore");
            }
            method.getParameterTypes();
        }
    }
}

