/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.storage.xml.Element;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLHandler
extends DefaultHandler {
    private KnowledgeBase kb;
    private boolean isIncluded;
    private Collection errors;
    private LinkedList openElements = new LinkedList();

    public XMLHandler(KnowledgeBase knowledgeBase, boolean bl, Collection collection) {
        this.kb = knowledgeBase;
        this.errors = collection;
        this.isIncluded = bl;
    }

    public void error(SAXParseException sAXParseException) {
        this.handle(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.handle(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        this.handle(sAXParseException);
    }

    private void handle(Exception exception) {
        this.errors.add(exception);
        Log.getLogger().severe(Log.toString(exception));
    }

    private Element getCurrentElement() {
        return this.openElements.isEmpty() ? null : (Element)this.openElements.get(this.openElements.size() - 1);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (!string3.equals("knowledge_base")) {
            Element element = new Element(string3, attributes);
            if (this.openElements.isEmpty()) {
                this.openElements.add(element);
            } else {
                this.getCurrentElement().addElement(element);
                this.openElements.add(element);
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (!string3.equals("knowledge_base")) {
            Element element = (Element)this.openElements.remove(this.openElements.size() - 1);
            if (this.openElements.isEmpty()) {
                this.createFrame(element);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        Element element = this.getCurrentElement();
        if (element != null) {
            element.addCharacters(new String(cArray, n, n2));
        }
    }

    private Collection getElementClsValues(Element element, String string) {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        for (String string2 : element.getSubelementValues(string)) {
            arrayList.add(this.getCls(string2));
        }
        return arrayList;
    }

    private Collection getElementSlotValues(Element element, String string) {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (String string2 : element.getSubelementValues(string)) {
            arrayList.add(this.getSlot(string2));
        }
        return arrayList;
    }

    private Cls getCls(String string) {
        Cls cls = this.kb.getCls(string);
        if (cls == null) {
            cls = this.kb.createCls(null, string, Collections.EMPTY_LIST, Collections.EMPTY_LIST, false);
        }
        return cls;
    }

    private Slot getSlot(String string) {
        Slot slot = this.kb.getSlot(string);
        if (slot == null) {
            slot = this.kb.createSlot(string, null, Collections.EMPTY_LIST, false);
        }
        return slot;
    }

    private Facet getFacet(String string) {
        Facet facet = this.kb.getFacet(string);
        if (facet == null) {
            facet = this.kb.createFacet(string, null, false);
        }
        return facet;
    }

    private SimpleInstance getSimpleInstance(String string) {
        SimpleInstance simpleInstance = this.kb.getSimpleInstance(string);
        if (simpleInstance == null) {
            simpleInstance = this.kb.createSimpleInstance(null, string, Collections.EMPTY_LIST, false);
        }
        return simpleInstance;
    }

    private void createFrame(Element element) {
        Instance instance;
        String string = element.getName();
        String string2 = element.getSubelementValue("name");
        Collection collection = this.getElementClsValues(element, "type");
        if (string.equals("class")) {
            instance = this.createCls(string2, collection, element);
        } else if (string.equals("slot")) {
            instance = this.createSlot(string2, collection, element);
        } else if (string.equals("facet")) {
            instance = this.createFacet(string2, collection, element);
        } else if (string.equals("simple_instance")) {
            instance = this.createSimpleInstance(string2, collection, element);
        } else {
            Log.getLogger().warning("bad frame type: " + string);
            instance = null;
        }
        if (instance != null) {
            this.addOwnSlotValues(instance, element);
        }
    }

    private void addTemplateFacetValues(Cls cls, Element element) {
        for (Element element2 : element.getSubelements("template_facet_value")) {
            this.addTemplateFacetValue(cls, element2);
        }
    }

    private void addTemplateFacetValue(Cls cls, Element element) {
        Slot slot = null;
        Facet facet = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Element element2 : element.getSubelements()) {
            String string = element2.getName();
            if (string.equals("slot_reference")) {
                slot = this.getSlot(element2.getValue());
                continue;
            }
            if (string.equals("facet_reference")) {
                facet = this.getFacet(element2.getValue());
                continue;
            }
            Object object = this.getValue(element2);
            if (object == null) continue;
            arrayList.add(object);
        }
        cls.setTemplateFacetValues(slot, facet, arrayList);
    }

    private void addOwnSlotValues(Frame frame, Element element) {
        for (Element element2 : element.getSubelements("own_slot_value")) {
            this.addOwnSlotValue(frame, element2);
        }
    }

    private void addOwnSlotValue(Frame frame, Element element) {
        Slot slot = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Element element2 : element.getSubelements()) {
            if (element2.getName().equals("slot_reference")) {
                slot = this.getSlot(element2.getValue());
                continue;
            }
            Object object = this.getValue(element2);
            if (object == null) continue;
            arrayList.add(object);
        }
        frame.setOwnSlotValues(slot, arrayList);
    }

    private Object getValue(Element element) {
        Object object;
        String string = element.getValue();
        String string2 = element.getAttributeValue("value_type");
        if (string2.equals("class")) {
            object = this.getCls(string);
        } else if (string2.equals("slot")) {
            object = this.getSlot(string);
        } else if (string2.equals("facet")) {
            object = this.getFacet(string);
        } else if (string2.equals("simple_instance")) {
            object = this.getSimpleInstance(string);
        } else if (string2.equals("string")) {
            object = string;
        } else if (string2.equals("boolean")) {
            object = Boolean.valueOf(string);
        } else if (string2.equals("integer")) {
            object = new Integer(string);
        } else if (string2.equals("float")) {
            object = new Float(string);
        } else {
            Log.getLogger().warning("bad value type: " + string2);
            object = null;
        }
        return object;
    }

    private static void addSuperclasses(Cls cls, Collection collection) {
        if (!collection.isEmpty()) {
            Collection collection2 = cls.getDirectSuperclasses();
            for (Cls cls2 : collection) {
                if (collection2.contains(cls2)) continue;
                cls.addDirectSuperclass(cls2);
            }
        }
    }

    private static void addTypes(Instance instance, Collection collection) {
        if (!collection.isEmpty()) {
            Collection collection2 = instance.getDirectTypes();
            for (Cls cls : collection) {
                if (collection2.contains(cls)) continue;
                instance.addDirectType(cls);
            }
        }
    }

    private Cls createCls(String string, Collection collection, Element element) {
        Collection collection2 = this.getElementClsValues(element, "superclass");
        Cls cls = this.kb.getCls(string);
        if (cls == null) {
            cls = this.kb.createCls(null, string, collection2, collection, false);
            this.setIncluded(cls);
        } else {
            XMLHandler.addTypes(cls, collection);
            XMLHandler.addSuperclasses(cls, collection2);
        }
        Collection collection3 = this.getElementSlotValues(element, "template_slot");
        for (Slot slot : collection3) {
            cls.addDirectTemplateSlot(slot);
        }
        this.addTemplateFacetValues(cls, element);
        return cls;
    }

    private Slot createSlot(String string, Collection collection, Element element) {
        Slot slot = this.kb.getSlot(string);
        if (slot == null) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
            slot = this.kb.createSlot(string, cls, Collections.EMPTY_LIST, false);
            this.setIncluded(slot);
        } else {
            XMLHandler.addTypes(slot, collection);
        }
        return slot;
    }

    private Facet createFacet(String string, Collection collection, Element element) {
        Facet facet = this.kb.getFacet(string);
        if (facet == null) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
            facet = this.kb.createFacet(string, cls, false);
            this.setIncluded(facet);
        } else {
            XMLHandler.addTypes(facet, collection);
        }
        return facet;
    }

    private SimpleInstance createSimpleInstance(String string, Collection collection, Element element) {
        SimpleInstance simpleInstance = (SimpleInstance)this.kb.getInstance(string);
        if (simpleInstance == null) {
            simpleInstance = this.kb.createSimpleInstance(null, string, collection, false);
            this.setIncluded(simpleInstance);
        } else {
            XMLHandler.addTypes(simpleInstance, collection);
        }
        return simpleInstance;
    }

    private void setIncluded(Frame frame) {
        if (this.isIncluded) {
            frame.setIncluded(true);
        }
    }
}

