/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protege.widget.UglyClsWidget;
import edu.stanford.smi.protege.widget.UglySlotWidget;
import edu.stanford.smi.protege.widget.UglyTabWidget;
import edu.stanford.smi.protege.widget.Widget;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.swing.JComponent;

public class WidgetUtilities {
    private static final String IS_TAB_SUITABLE_NAME = "isSuitable";
    private static final Class[] IS_TAB_SUITABLE_ARG_CLASSES = new Class[]{Project.class, Collection.class};
    private static final String IS_EXPORT_SUITABLE_METHOD_NAME = "isSuitable";
    private static final Class[] IS_EXPORT_SUITABLE_METHODS_ARGS = new Class[]{Project.class};

    public static ClsWidget createClsWidget(WidgetDescriptor widgetDescriptor, boolean bl, Project project, Cls cls) {
        ClsWidget clsWidget;
        try {
            Assert.assertNotNull("descriptor", widgetDescriptor);
            Assert.assertNotNull("project", project);
            clsWidget = (ClsWidget)SystemUtilities.newInstance(widgetDescriptor.getWidgetClassName());
            if (clsWidget == null) {
                clsWidget = new UglyClsWidget();
            }
            clsWidget.setup(widgetDescriptor, bl, project, cls);
            clsWidget.initialize();
        }
        catch (Exception exception) {
            Log.getLogger().warning(Log.toString(exception));
            clsWidget = new UglyClsWidget();
        }
        return clsWidget;
    }

    public static SlotWidget createSlotWidget(WidgetDescriptor widgetDescriptor, boolean bl, Project project, Cls cls, Slot slot) {
        SlotWidget slotWidget;
        try {
            Assert.assertNotNull("descriptor", widgetDescriptor);
            Assert.assertNotNull("project", project);
            slotWidget = (SlotWidget)SystemUtilities.newInstance(widgetDescriptor.getWidgetClassName());
            if (slotWidget == null) {
                slotWidget = new UglySlotWidget();
            }
            WidgetUtilities.setupSlotWidget(slotWidget, widgetDescriptor, bl, project, cls, slot);
        }
        catch (Exception exception) {
            Log.getLogger().warning(Log.toString(exception));
            slotWidget = new UglySlotWidget(widgetDescriptor.getWidgetClassName());
            WidgetUtilities.setupSlotWidget(slotWidget, widgetDescriptor, bl, project, cls, slot);
        }
        return slotWidget;
    }

    public static TabWidget createTabWidget(WidgetDescriptor widgetDescriptor, Project project) {
        TabWidget tabWidget;
        try {
            Assert.assertNotNull("descriptor", widgetDescriptor);
            Assert.assertNotNull("project", project);
            tabWidget = (TabWidget)SystemUtilities.newInstance(widgetDescriptor.getWidgetClassName());
            if (tabWidget == null) {
                tabWidget = new UglyTabWidget();
            }
            tabWidget.setup(widgetDescriptor, project);
            tabWidget.initialize();
        }
        catch (Exception exception) {
            Log.getLogger().warning(Log.toString(exception));
            tabWidget = new UglyTabWidget();
            tabWidget.setup(widgetDescriptor, project);
            tabWidget.initialize();
        }
        return tabWidget;
    }

    private static void fixBounds(Widget widget) {
        WidgetDescriptor widgetDescriptor = widget.getDescriptor();
        if (widgetDescriptor.getBounds() == null) {
            JComponent jComponent = (JComponent)((Object)widget);
            Rectangle rectangle = new Rectangle(new Point(), jComponent.getPreferredSize());
            widgetDescriptor.setBounds(rectangle);
            jComponent.setBounds(rectangle);
        }
    }

    private static void setupComponent(JComponent jComponent, WidgetDescriptor widgetDescriptor) {
        Rectangle rectangle = widgetDescriptor.getBounds();
        if (rectangle != null) {
            jComponent.setBounds(rectangle);
        }
    }

    private static void setupSlotWidget(SlotWidget slotWidget, WidgetDescriptor widgetDescriptor, boolean bl, Project project, Cls cls, Slot slot) {
        WidgetUtilities.setupComponent((JComponent)((Object)slotWidget), widgetDescriptor);
        slotWidget.setup(widgetDescriptor, bl, project, cls, slot);
        slotWidget.initialize();
        WidgetUtilities.fixBounds(slotWidget);
    }

    public static boolean isSuitableTab(String string, Project project, Collection collection) {
        boolean bl = false;
        try {
            Class clazz = SystemUtilities.forName(string);
            Method method = clazz.getMethod("isSuitable", IS_TAB_SUITABLE_ARG_CLASSES);
            Object[] objectArray = new Object[]{project, collection};
            Boolean bl2 = (Boolean)method.invoke(null, objectArray);
            bl = bl2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isSuitableExport(Project project, ExportPlugin exportPlugin) {
        boolean bl;
        try {
            Method method = exportPlugin.getClass().getMethod("isSuitable", IS_EXPORT_SUITABLE_METHODS_ARGS);
            Boolean bl2 = (Boolean)method.invoke((Object)exportPlugin, project);
            bl = bl2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            Log.getLogger().warning(exception.getMessage());
        }
        return bl;
    }
}

