/*
 * Decompiled with CFR 0.152.
 */
package org.daml.kazuki.datatypes;

import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.iterator.Map1;
import org.daml.kazuki.Datatypes;

public class XSDgMonth {
    private int month = 0;
    private static final int MIN_MONTH = 1;
    private static final int MAX_MONTH = 12;
    public static Map1 objectMapper = new ObjectMapper();

    public XSDgMonth(XSDDateTime xSDDateTime) {
        this.setMonth(xSDDateTime.getMonths());
    }

    public XSDgMonth(int n) {
        this.setMonth(n);
    }

    public void setMonth(int n) {
        if (1 <= n && n <= 12) {
            this.month = n;
        }
    }

    public int getMonth() {
        return this.month;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("--");
        if (this.month < 10) {
            stringBuffer.append("0");
            stringBuffer.append(this.month);
        } else {
            stringBuffer.append(this.month);
        }
        stringBuffer.append("--");
        return stringBuffer.toString();
    }

    protected static class ObjectMapper
    implements Map1 {
        protected ObjectMapper() {
        }

        public Object map1(Object object) {
            if (object instanceof Statement) {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getgMonth(literal);
            }
            throw new IllegalArgumentException("RDF Statement expected while converting an XSDgMonth.");
        }
    }
}

