/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;

class SetFrameNameCommand
extends AbstractCommand {
    private String name;
    private Frame frame;
    private String oldName;

    SetFrameNameCommand(FrameStore frameStore, String string, Frame frame) {
        super(frameStore);
        this.name = string;
        this.frame = frame;
        this.oldName = this.getDelegate().getFrameName(frame);
        this.setDescription("Change frame name from " + this.oldName + " to " + string);
    }

    public Object doIt() {
        this.getDelegate().setFrameName(this.frame, this.name);
        return null;
    }

    public void undoIt() {
        this.getDelegate().setFrameName(this.frame, this.oldName);
    }

    public void redoIt() {
        this.getDelegate().setFrameName(this.frame, this.name);
    }
}

