/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectPlugin;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public abstract class AbstractCreateProjectPlugin
implements CreateProjectPlugin {
    private String name;
    private KnowledgeBaseFactory knowledgeBaseFactory;
    private boolean useExistingSources;

    protected AbstractCreateProjectPlugin(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
    }

    protected void handleErrors(Collection collection) {
        if (!collection.isEmpty()) {
            ProjectManager.getProjectManager().displayErrors("Create Project Errors", collection);
            for (Object e : collection) {
                if (e instanceof Exception) {
                    Log.getLogger().log(Level.SEVERE, "Severe error (exception)", (Exception)e);
                    continue;
                }
                Log.getLogger().severe("Error found = " + e);
            }
        }
    }

    public void setKnowledgeBaseFactory(KnowledgeBaseFactory knowledgeBaseFactory) {
        this.knowledgeBaseFactory = knowledgeBaseFactory;
    }

    public void setUseExistingSources(boolean bl) {
        this.useExistingSources = bl;
    }

    public Project createProject() {
        Project project = null;
        project = this.useExistingSources ? this.buildNewProject(this.knowledgeBaseFactory) : this.createNewProject(this.knowledgeBaseFactory);
        return project;
    }

    protected Project createNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        ArrayList arrayList = new ArrayList();
        Project project = Project.createNewProject(knowledgeBaseFactory, arrayList);
        this.handleErrors(arrayList);
        return project;
    }

    protected void initialize(Project project) {
        this.initializeSources(project.getSources());
    }

    protected Project buildNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        ArrayList arrayList = new ArrayList();
        Project project = Project.createBuildProject(knowledgeBaseFactory, arrayList);
        this.initialize(project);
        URI uRI = this.getBuildProjectURI();
        if (uRI != null) {
            project.setProjectURI(uRI);
        }
        project.createDomainKnowledgeBase(knowledgeBaseFactory, arrayList, true);
        this.handleErrors(arrayList);
        return project;
    }

    protected URI getBuildProjectURI() {
        return null;
    }

    protected void initializeSources(PropertyList propertyList) {
        throw new UnsupportedOperationException();
    }
}

