/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.server.RemoteSession;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RemoteServerFrameStore
extends Remote {
    public int getClsCount(RemoteSession var1) throws RemoteException;

    public int getSlotCount(RemoteSession var1) throws RemoteException;

    public int getFacetCount(RemoteSession var1) throws RemoteException;

    public int getSimpleInstanceCount(RemoteSession var1) throws RemoteException;

    public int getFrameCount(RemoteSession var1) throws RemoteException;

    public Set getClses(RemoteSession var1) throws RemoteException;

    public Set getSlots(RemoteSession var1) throws RemoteException;

    public Set getFacets(RemoteSession var1) throws RemoteException;

    public Set getFrames(RemoteSession var1) throws RemoteException;

    public Frame getFrame(String var1, RemoteSession var2) throws RemoteException;

    public String getFrameName(Frame var1, RemoteSession var2) throws RemoteException;

    public void setFrameName(Frame var1, String var2, RemoteSession var3) throws RemoteException;

    public Cls createCls(FrameID var1, String var2, Collection var3, Collection var4, boolean var5, RemoteSession var6) throws RemoteException;

    public Slot createSlot(FrameID var1, String var2, Collection var3, Collection var4, boolean var5, RemoteSession var6) throws RemoteException;

    public Facet createFacet(FrameID var1, String var2, Collection var3, boolean var4, RemoteSession var5) throws RemoteException;

    public SimpleInstance createSimpleInstance(FrameID var1, String var2, Collection var3, boolean var4, RemoteSession var5) throws RemoteException;

    public void deleteCls(Cls var1, RemoteSession var2) throws RemoteException;

    public void deleteSlot(Slot var1, RemoteSession var2) throws RemoteException;

    public void deleteFacet(Facet var1, RemoteSession var2) throws RemoteException;

    public void deleteSimpleInstance(SimpleInstance var1, RemoteSession var2) throws RemoteException;

    public Set getOwnSlots(Frame var1, RemoteSession var2) throws RemoteException;

    public Collection getOwnSlotValues(Frame var1, Slot var2, RemoteSession var3) throws RemoteException;

    public List getDirectOwnSlotValues(Frame var1, Slot var2, RemoteSession var3) throws RemoteException;

    public int getDirectOwnSlotValuesCount(Frame var1, Slot var2, RemoteSession var3) throws RemoteException;

    public void moveDirectOwnSlotValue(Frame var1, Slot var2, int var3, int var4, RemoteSession var5) throws RemoteException;

    public void setDirectOwnSlotValues(Frame var1, Slot var2, Collection var3, RemoteSession var4) throws RemoteException;

    public Set getOwnFacets(Frame var1, Slot var2, RemoteSession var3) throws RemoteException;

    public Collection getOwnFacetValues(Frame var1, Slot var2, Facet var3, RemoteSession var4) throws RemoteException;

    public Set getTemplateSlots(Cls var1, RemoteSession var2) throws RemoteException;

    public List getDirectTemplateSlots(Cls var1, RemoteSession var2) throws RemoteException;

    public List getDirectDomain(Slot var1, RemoteSession var2) throws RemoteException;

    public Set getDomain(Slot var1, RemoteSession var2) throws RemoteException;

    public Set getOverriddenTemplateSlots(Cls var1, RemoteSession var2) throws RemoteException;

    public Set getDirectlyOverriddenTemplateSlots(Cls var1, RemoteSession var2) throws RemoteException;

    public void addDirectTemplateSlot(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public void removeDirectTemplateSlot(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public void moveDirectTemplateSlot(Cls var1, Slot var2, int var3, RemoteSession var4) throws RemoteException;

    public Collection getTemplateSlotValues(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public List getDirectTemplateSlotValues(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public void setDirectTemplateSlotValues(Cls var1, Slot var2, Collection var3, RemoteSession var4) throws RemoteException;

    public Set getTemplateFacets(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public Set getOverriddenTemplateFacets(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public Set getDirectlyOverriddenTemplateFacets(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public void removeDirectTemplateFacetOverrides(Cls var1, Slot var2, RemoteSession var3) throws RemoteException;

    public Collection getTemplateFacetValues(Cls var1, Slot var2, Facet var3, RemoteSession var4) throws RemoteException;

    public List getDirectTemplateFacetValues(Cls var1, Slot var2, Facet var3, RemoteSession var4) throws RemoteException;

    public void setDirectTemplateFacetValues(Cls var1, Slot var2, Facet var3, Collection var4, RemoteSession var5) throws RemoteException;

    public List getDirectSuperclasses(Cls var1, RemoteSession var2) throws RemoteException;

    public Set getSuperclasses(Cls var1, RemoteSession var2) throws RemoteException;

    public List getDirectSubclasses(Cls var1, RemoteSession var2) throws RemoteException;

    public Set getSubclasses(Cls var1, RemoteSession var2) throws RemoteException;

    public void addDirectSuperclass(Cls var1, Cls var2, RemoteSession var3) throws RemoteException;

    public void removeDirectSuperclass(Cls var1, Cls var2, RemoteSession var3) throws RemoteException;

    public void moveDirectSubclass(Cls var1, Cls var2, int var3, RemoteSession var4) throws RemoteException;

    public List getDirectSuperslots(Slot var1, RemoteSession var2) throws RemoteException;

    public Set getSuperslots(Slot var1, RemoteSession var2) throws RemoteException;

    public List getDirectSubslots(Slot var1, RemoteSession var2) throws RemoteException;

    public Set getSubslots(Slot var1, RemoteSession var2) throws RemoteException;

    public void addDirectSuperslot(Slot var1, Slot var2, RemoteSession var3) throws RemoteException;

    public void removeDirectSuperslot(Slot var1, Slot var2, RemoteSession var3) throws RemoteException;

    public void moveDirectSubslot(Slot var1, Slot var2, int var3, RemoteSession var4) throws RemoteException;

    public List getDirectTypes(Instance var1, RemoteSession var2) throws RemoteException;

    public Set getTypes(Instance var1, RemoteSession var2) throws RemoteException;

    public List getDirectInstances(Cls var1, RemoteSession var2) throws RemoteException;

    public Set getInstances(Cls var1, RemoteSession var2) throws RemoteException;

    public void addDirectType(Instance var1, Cls var2, RemoteSession var3) throws RemoteException;

    public void removeDirectType(Instance var1, Cls var2, RemoteSession var3) throws RemoteException;

    public void moveDirectType(Instance var1, Cls var2, int var3, RemoteSession var4) throws RemoteException;

    public List<EventObject> getEvents(RemoteSession var1) throws RemoteException;

    public Set getReferences(Object var1, RemoteSession var2) throws RemoteException;

    public Set getClsesWithMatchingBrowserText(String var1, Collection var2, int var3, RemoteSession var4) throws RemoteException;

    public Set getMatchingReferences(String var1, int var2, RemoteSession var3) throws RemoteException;

    public Set getFramesWithDirectOwnSlotValue(Slot var1, Object var2, RemoteSession var3) throws RemoteException;

    public Set getFramesWithAnyDirectOwnSlotValue(Slot var1, RemoteSession var2) throws RemoteException;

    public Set getFramesWithMatchingDirectOwnSlotValue(Slot var1, String var2, int var3, RemoteSession var4) throws RemoteException;

    public Set getClsesWithDirectTemplateSlotValue(Slot var1, Object var2, RemoteSession var3) throws RemoteException;

    public Set getClsesWithAnyDirectTemplateSlotValue(Slot var1, RemoteSession var2) throws RemoteException;

    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot var1, String var2, int var3, RemoteSession var4) throws RemoteException;

    public Set getClsesWithDirectTemplateFacetValue(Slot var1, Facet var2, Object var3, RemoteSession var4) throws RemoteException;

    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot var1, Facet var2, String var3, int var4, RemoteSession var5) throws RemoteException;

    public Set executeQuery(Query var1, RemoteSession var2) throws RemoteException;

    public Set getDirectOwnSlotValuesClosure(Frame var1, Slot var2, RemoteSession var3) throws RemoteException;

    public void close(RemoteSession var1) throws RemoteException;

    public boolean beginTransaction(String var1, RemoteSession var2) throws RemoteException;

    public boolean commitTransaction(RemoteSession var1) throws RemoteException;

    public boolean rollbackTransaction(RemoteSession var1) throws RemoteException;

    public Frame getFrame(FrameID var1, RemoteSession var2) throws RemoteException;

    public Map getFrameValues(Collection var1, RemoteSession var2) throws RemoteException;

    public Map preload(boolean var1, RemoteSession var2) throws RemoteException;
}

