/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.server.Registration;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFrameStore
extends UnicastRemoteObject
implements RemoteServerFrameStore {
    private static transient Logger log = Log.getLogger(ServerFrameStore.class);
    private FrameStore _delegate;
    private FrameStore _wrappedDelegate;
    private KnowledgeBase _kb;
    private List _events = new ArrayList();
    private Map<RemoteSession, Registration> _sessionToRegistrationMap = new HashMap<RemoteSession, Registration>();
    private boolean _isDirty;
    private static final int DELAY_MSEC = Integer.getInteger("server.delay", 0);
    private static final int MAX_VALUES = 20;
    private static final int MIN_PRELOAD_FRAMES = Integer.getInteger("preload.frame.limit", 5000);
    private Map<Sft, Sft> sftMap = new HashMap<Sft, Sft>();
    private int nDelayedCalls = 0;
    private static RemoteSession currentSession;
    private static final int LIMIT = 100;

    public ServerFrameStore(FrameStore frameStore, KnowledgeBase knowledgeBase) throws RemoteException {
        this._delegate = frameStore;
        this._kb = knowledgeBase;
        knowledgeBase.setDispatchEventsEnabled(false);
        if (DELAY_MSEC != 0) {
            Log.getLogger().config("Simulated delay of " + DELAY_MSEC + " msec/call");
        }
    }

    private FrameStore getDelegate() {
        return this._delegate;
    }

    private void delay() {
        if (DELAY_MSEC != 0) {
            SystemUtilities.sleepMsec(DELAY_MSEC);
            if (++this.nDelayedCalls % 10 == 0) {
                Log.getLogger().info(this.nDelayedCalls + " delayed calls");
            }
        }
    }

    private void recordCall(RemoteSession remoteSession) {
        this.delay();
        currentSession = remoteSession;
    }

    public static RemoteSession getCurrentSession() {
        return currentSession;
    }

    @Override
    public synchronized int getClsCount(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getClsCount();
    }

    @Override
    public synchronized int getSlotCount(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getSlotCount();
    }

    @Override
    public synchronized int getFacetCount(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getFacetCount();
    }

    @Override
    public synchronized int getSimpleInstanceCount(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getSimpleInstanceCount();
    }

    @Override
    public synchronized int getFrameCount(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getFrameCount();
    }

    @Override
    public synchronized List getDirectTemplateSlots(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectTemplateSlots(cls);
    }

    @Override
    public synchronized void removeDirectTemplateSlot(Cls cls, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
        this.markDirty();
    }

    @Override
    public synchronized void moveDirectTemplateSlot(Cls cls, Slot slot, int n, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().moveDirectTemplateSlot(cls, slot, n);
        this.markDirty();
    }

    @Override
    public synchronized void addDirectSuperclass(Cls cls, Cls cls2, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().addDirectSuperclass(cls, cls2);
        this.markDirty();
    }

    @Override
    public synchronized void removeDirectSuperslot(Slot slot, Slot slot2, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().removeDirectSuperslot(slot, slot2);
        this.markDirty();
    }

    @Override
    public synchronized void removeDirectSuperclass(Cls cls, Cls cls2, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().removeDirectSuperclass(cls, cls2);
        this.markDirty();
    }

    @Override
    public synchronized void moveDirectSubclass(Cls cls, Cls cls2, int n, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().moveDirectSubclass(cls, cls2, n);
        this.markDirty();
    }

    @Override
    public synchronized List getDirectTemplateSlotValues(Cls cls, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectTemplateSlotValues(cls, slot);
    }

    @Override
    public synchronized Set getSuperslots(Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getSuperslots(slot);
    }

    @Override
    public synchronized Set getOwnSlots(Frame frame, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getOwnSlots(frame);
    }

    @Override
    public synchronized Set getInstances(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getInstances(cls);
    }

    @Override
    public synchronized Set getFramesWithDirectOwnSlotValue(Slot slot, Object object, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getFramesWithDirectOwnSlotValue(slot, object);
    }

    @Override
    public synchronized Set getClsesWithDirectTemplateSlotValue(Slot slot, Object object, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getClsesWithDirectTemplateSlotValue(slot, object);
    }

    @Override
    public synchronized Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object object, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getClsesWithDirectTemplateFacetValue(slot, facet, object);
    }

    @Override
    public synchronized Set getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getFramesWithMatchingDirectOwnSlotValue(slot, string, n);
    }

    @Override
    public synchronized Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String string, int n, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, string, n);
    }

    @Override
    public synchronized Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String string, int n, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getClsesWithMatchingDirectTemplateSlotValue(slot, string, n);
    }

    @Override
    public synchronized List getDirectSuperclasses(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectSuperclasses(cls);
    }

    @Override
    public synchronized Collection getTemplateSlotValues(Cls cls, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getTemplateSlotValues(cls, slot);
    }

    @Override
    public synchronized List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public synchronized Set getClses(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getClses();
    }

    @Override
    public synchronized Set getTemplateFacets(Cls cls, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getTemplateFacets(cls, slot);
    }

    @Override
    public synchronized Frame getFrame(String string, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getFrame(string);
    }

    @Override
    public synchronized Frame getFrame(FrameID frameID, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getFrame(frameID);
    }

    @Override
    public synchronized Collection getOwnSlotValues(Frame frame, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getOwnSlotValues(frame, slot);
    }

    @Override
    public synchronized int getDirectOwnSlotValuesCount(Frame frame, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectOwnSlotValuesCount(frame, slot);
    }

    @Override
    public synchronized List getDirectOwnSlotValues(Frame frame, Slot slot, RemoteSession remoteSession) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("getDirectOwnSlotValues for frame " + frame.getFrameID() + " slot " + slot.getFrameID());
        }
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectOwnSlotValues(frame, slot);
    }

    @Override
    public synchronized List getDirectInstances(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectInstances(cls);
    }

    @Override
    public synchronized Set getSubclasses(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getSubclasses(cls);
    }

    @Override
    public synchronized Set getSlots(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getSlots();
    }

    @Override
    public synchronized Set getSuperclasses(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getSuperclasses(cls);
    }

    @Override
    public synchronized Set getSubslots(Slot slot, RemoteSession remoteSession) {
        return this.getDelegate().getSubslots(slot);
    }

    @Override
    public synchronized void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, collection);
        this.markDirty();
    }

    @Override
    public synchronized Facet createFacet(FrameID frameID, String string, Collection collection, boolean bl, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.markDirty();
        return this.getDelegate().createFacet(frameID, string, collection, bl);
    }

    @Override
    public synchronized List getDirectSubclasses(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectSubclasses(cls);
    }

    @Override
    public synchronized Set getFrames(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getFrames();
    }

    @Override
    public synchronized void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.markDirty();
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, collection);
    }

    @Override
    public synchronized Set getTypes(Instance instance, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getTypes(instance);
    }

    @Override
    public synchronized Set getTemplateSlots(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getTemplateSlots(cls);
    }

    @Override
    public synchronized Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public synchronized void deleteCls(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().deleteCls(cls);
        this.markDirty();
    }

    @Override
    public synchronized void deleteSlot(Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().deleteSlot(slot);
        this.markDirty();
    }

    @Override
    public synchronized void deleteFacet(Facet facet, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().deleteFacet(facet);
        this.markDirty();
    }

    @Override
    public synchronized void deleteSimpleInstance(SimpleInstance simpleInstance, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().deleteSimpleInstance(simpleInstance);
        this.markDirty();
    }

    @Override
    public synchronized Slot createSlot(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.markDirty();
        return this.getDelegate().createSlot(frameID, string, collection, collection2, bl);
    }

    @Override
    public synchronized List getDirectTypes(Instance instance, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectTypes(instance);
    }

    @Override
    public synchronized List getDirectSubslots(Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectSubslots(slot);
    }

    @Override
    public synchronized void addDirectSuperslot(Slot slot, Slot slot2, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().addDirectSuperslot(slot, slot2);
        this.markDirty();
    }

    @Override
    public synchronized void addDirectTemplateSlot(Cls cls, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().addDirectTemplateSlot(cls, slot);
        this.markDirty();
    }

    @Override
    public synchronized void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, n, n2);
        this.markDirty();
    }

    @Override
    public synchronized void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().setDirectOwnSlotValues(frame, slot, collection);
        this.markDirty();
    }

    @Override
    public synchronized Cls createCls(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.markDirty();
        return this.getDelegate().createCls(frameID, string, collection, collection2, bl);
    }

    @Override
    public synchronized Set getFacets(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getFacets();
    }

    @Override
    public synchronized Set executeQuery(Query query, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().executeQuery(query);
    }

    @Override
    public synchronized void removeDirectType(Instance instance, Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().removeDirectType(instance, cls);
        this.markDirty();
    }

    @Override
    public synchronized Set getReferences(Object object, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getReferences(object);
    }

    @Override
    public synchronized Set getMatchingReferences(String string, int n, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getMatchingReferences(string, n);
    }

    @Override
    public synchronized Set getClsesWithMatchingBrowserText(String string, Collection collection, int n, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getClsesWithMatchingBrowserText(string, collection, n);
    }

    @Override
    public synchronized SimpleInstance createSimpleInstance(FrameID frameID, String string, Collection collection, boolean bl, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.markDirty();
        return this.getDelegate().createSimpleInstance(frameID, string, collection, bl);
    }

    @Override
    public synchronized void addDirectType(Instance instance, Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().addDirectType(instance, cls);
        this.markDirty();
    }

    @Override
    public synchronized void moveDirectType(Instance instance, Cls cls, int n, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().moveDirectType(instance, cls, n);
        this.markDirty();
    }

    @Override
    public synchronized List getDirectSuperslots(Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectSuperslots(slot);
    }

    @Override
    public synchronized String getFrameName(Frame frame, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getFrameName(frame);
    }

    @Override
    public synchronized void setFrameName(Frame frame, String string, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().setFrameName(frame, string);
        this.markDirty();
    }

    @Override
    public synchronized Set getOwnFacets(Frame frame, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getOwnFacets(frame, slot);
    }

    @Override
    public synchronized Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getOwnFacetValues(frame, slot, facet);
    }

    @Override
    public synchronized Set getOverriddenTemplateSlots(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getOverriddenTemplateSlots(cls);
    }

    @Override
    public synchronized Set getDirectlyOverriddenTemplateSlots(Cls cls, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectlyOverriddenTemplateSlots(cls);
    }

    @Override
    public synchronized Set getOverriddenTemplateFacets(Cls cls, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getOverriddenTemplateFacets(cls, slot);
    }

    @Override
    public synchronized Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getOverriddenTemplateFacets(cls, slot);
    }

    @Override
    public synchronized void removeDirectTemplateFacetOverrides(Cls cls, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
        this.markDirty();
    }

    @Override
    public synchronized void close(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
    }

    public synchronized void register(RemoteSession remoteSession) {
        Registration registration = new Registration(this._events.size());
        this._sessionToRegistrationMap.put(remoteSession, registration);
    }

    @Override
    public String toString() {
        return "ServerFrameStoreImpl";
    }

    @Override
    public synchronized List<EventObject> getEvents(RemoteSession remoteSession) {
        ArrayList arrayList;
        this.recordCall(remoteSession);
        ArrayList arrayList2 = this.getDelegate().getEvents();
        if (remoteSession == null) {
            arrayList = arrayList2;
        } else {
            this._events.addAll(arrayList2);
            Registration registration = this._sessionToRegistrationMap.get(remoteSession);
            if (registration == null) {
                throw new IllegalStateException("Not registered");
            }
            int n = registration.getLastEvent();
            int n2 = this._events.size();
            registration.setLastEvent(n2);
            if (n == n2) {
                arrayList = Collections.EMPTY_LIST;
            } else {
                arrayList = new ArrayList(this._events.subList(n, n2));
                if (log.isLoggable(Level.FINE)) {
                    log.fine("" + remoteSession + " events=" + arrayList);
                }
            }
        }
        return arrayList;
    }

    @Override
    public synchronized boolean beginTransaction(String string, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().beginTransaction(string);
    }

    @Override
    public synchronized boolean commitTransaction(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().commitTransaction();
    }

    @Override
    public synchronized boolean rollbackTransaction(RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().rollbackTransaction();
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    private void markDirty() {
        this._isDirty = true;
    }

    public void markClean() {
        this._isDirty = false;
    }

    @Override
    public synchronized List getDirectDomain(Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectDomain(slot);
    }

    @Override
    public synchronized Set getDomain(Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDomain(slot);
    }

    @Override
    public synchronized void moveDirectSubslot(Slot slot, Slot slot2, int n, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        this.getDelegate().moveDirectSubslot(slot, slot2, n);
    }

    @Override
    public synchronized Set getFramesWithAnyDirectOwnSlotValue(Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getFramesWithAnyDirectOwnSlotValue(slot);
    }

    @Override
    public synchronized Set getClsesWithAnyDirectTemplateSlotValue(Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getClsesWithAnyDirectTemplateSlotValue(slot);
    }

    @Override
    public synchronized Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot, RemoteSession remoteSession) {
        this.recordCall(remoteSession);
        return this.getDelegate().getDirectOwnSlotValuesClosure(frame, slot);
    }

    private Collection supplementFrames(Collection linkedHashSet) {
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        if (linkedHashSet.size() == 1) {
            Object object = CollectionUtilities.getFirstItem(linkedHashSet);
            if (object instanceof Cls) {
                Cls cls = (Cls)object;
                Cls cls2 = (Cls)CollectionUtilities.getFirstItem(this.getDelegate().getDirectSuperclasses(cls));
                if (cls2 != null) {
                    Slot slot = (Slot)this.getDelegate().getFrame(":DIRECT-SUBCLASSES");
                    linkedHashSet2 = new LinkedHashSet(linkedHashSet);
                    if (this.getDelegate().getDirectOwnSlotValuesCount(cls2, slot) < 100) {
                        List list = this.getDelegate().getDirectSubclasses(cls2);
                        linkedHashSet2.addAll(list);
                    }
                }
            }
            if (linkedHashSet2.size() != 1) {
                // empty if block
            }
        }
        return linkedHashSet2;
    }

    @Override
    public synchronized Map getFrameValues(Collection collection, RemoteSession remoteSession) {
        long l = 0L;
        if (log.isLoggable(Level.FINE)) {
            log.fine("calling getFrameValues");
            l = System.currentTimeMillis();
        }
        this.recordCall(remoteSession);
        Map map = this.getFrameValues(collection, false);
        if (log.isLoggable(Level.FINE)) {
            log.fine("getFrameValues took " + (System.currentTimeMillis() - l) + " milliseconds");
        }
        return map;
    }

    private void localize(Collection collection) {
        LocalizeUtils.localize(collection, this._kb);
    }

    private Map getFrameValues(Collection collection, boolean bl) {
        this.localize(collection);
        collection = this.supplementFrames(collection);
        if (log.isLoggable(Level.FINER)) {
            log.fine(this._kb.getName() + " getFrameValues: " + CollectionUtilities.toString(collection));
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Frame frame : collection) {
            LinkedHashMap linkedHashMap2;
            long l = 0L;
            if (log.isLoggable(Level.FINE)) {
                l = System.currentTimeMillis();
                log.fine("Started getting values for frame (" + frame.getFrameID() + ")");
            }
            if ((linkedHashMap2 = (LinkedHashMap)((HashMap)linkedHashMap).get(frame)) == null) {
                linkedHashMap2 = new LinkedHashMap();
                linkedHashMap.put(frame, linkedHashMap2);
            }
            this.insertOwnSlots(linkedHashMap2, frame, bl);
            if (frame instanceof Cls) {
                this.insertTemplateValues(linkedHashMap2, (Cls)frame);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Got frame value in " + (System.currentTimeMillis() - l) + " milliseconds");
        }
        return linkedHashMap;
    }

    private void insertOwnSlots(Map map, Frame frame, boolean bl) {
        for (Slot slot : this.getDelegate().getOwnSlots(frame)) {
            int n = this.getDelegate().getDirectOwnSlotValuesCount(frame, slot);
            if (bl || n < 20) {
                List list = this.getDelegate().getDirectOwnSlotValues(frame, slot);
                this.insertValues(map, slot, null, false, list);
                continue;
            }
            this.insertNullValues(map, slot, null, false);
        }
    }

    private void insertTemplateValues(Map map, Cls cls) {
        for (Slot slot : this.getDelegate().getTemplateSlots(cls)) {
            List list = this.getDelegate().getDirectTemplateSlotValues(cls, slot);
            this.insertValues(map, slot, null, true, list);
            this.insertFacets(map, cls, slot);
        }
    }

    private void insertFacets(Map map, Cls cls, Slot slot) {
        for (Facet facet : this.getDelegate().getTemplateFacets(cls, slot)) {
            List list = this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
            this.insertValues(map, slot, facet, true, list);
        }
    }

    private void insertValues(Map map, Slot slot, Facet facet, boolean bl, Collection arrayList) {
        if (arrayList == null || !arrayList.isEmpty()) {
            if (arrayList != null) {
                arrayList = new ArrayList(arrayList);
            }
            map.put(this.getSft(slot, facet, bl), arrayList);
        }
    }

    private Sft getSft(Slot slot, Facet facet, boolean bl) {
        Sft sft = new Sft(slot, facet, bl);
        Sft sft2 = this.sftMap.get(sft);
        if (sft2 == null) {
            this.sftMap.put(sft, sft);
            sft2 = sft;
        }
        return sft2;
    }

    private void insertNullValues(Map map, Slot slot, Facet facet, boolean bl) {
        this.insertValues(map, slot, facet, bl, null);
    }

    @Override
    public synchronized Map preload(boolean bl, RemoteSession remoteSession) {
        LinkedHashSet linkedHashSet;
        this.recordCall(remoteSession);
        if (bl || this.getDelegate().getFrameCount() < MIN_PRELOAD_FRAMES) {
            linkedHashSet = this.getDelegate().getFrames();
        } else {
            linkedHashSet = new LinkedHashSet();
            linkedHashSet.addAll(this.getDelegate().getSlots());
            linkedHashSet.addAll(this.getDelegate().getFacets());
            this.addHierarchy(linkedHashSet, ":META-CLASS");
            this.addHierarchy(linkedHashSet, ":CONSTRAINT");
            this.addHierarchy(linkedHashSet, ":ANNOTATION");
            this.addHierarchy(linkedHashSet, ":RELATION");
            this.addFrame(linkedHashSet, ":SYSTEM-CLASS");
            this.addRootHierarchy(linkedHashSet, this._kb.getRootCls());
            Project project = this._kb.getProject();
            if (project != null) {
                linkedHashSet.addAll(project.getClsesWithCustomizedForms());
                linkedHashSet.addAll(project.getClsesWithDirectBrowserSlots());
                linkedHashSet.addAll(project.getHiddenFrames());
            }
        }
        return this.getFrameValues(linkedHashSet, bl);
    }

    private void addFrame(Collection collection, String string) {
        Cls cls = (Cls)this.getDelegate().getFrame(string);
        collection.add(cls);
    }

    private void addHierarchy(Collection collection, String string) {
        Cls cls = (Cls)this.getDelegate().getFrame(string);
        collection.add(cls);
        collection.addAll(this.getDelegate().getSubclasses(cls));
    }

    private void addRootHierarchy(Collection collection, Cls cls) {
        collection.add(cls);
        for (Cls cls2 : this.getDelegate().getDirectSubclasses(cls)) {
            if (cls2.isSystem()) continue;
            collection.add(cls2);
            collection.addAll(this.getDelegate().getDirectSubclasses(cls2));
        }
    }
}

