/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.storage.database.DatabaseUtils;
import edu.stanford.smi.protege.storage.database.RobustConnection;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseFrameDb
implements NarrowFrameStore {
    private static Logger log = Log.getLogger(DatabaseFrameDb.class);
    int projectId = FrameID.allocateMemoryProjectPart();
    private static final String FRAME_COLUMN = "frame";
    private static final String FRAME_TYPE_COLUMN = "frame_type";
    private static final String SLOT_COLUMN = "slot";
    private static final String FACET_COLUMN = "facet";
    private static final String IS_TEMPLATE_COLUMN = "is_template";
    private static final String VALUE_INDEX_COLUMN = "value_index";
    private static final String VALUE_TYPE_COLUMN = "value_type";
    private static final String SHORT_VALUE_COLUMN = "short_value";
    private static final String LONG_VALUE_COLUMN = "long_value";
    private final Map _connections = new HashMap();
    private String _table;
    private String _driver;
    private String _url;
    private String _user;
    private String _password;
    private boolean _isInclude;
    private FrameFactory _frameFactory;
    private static boolean _isModifiable = true;
    private static int lastReturnedFrameID = 9999;
    private String frameDbName;
    private static int traceCount = 0;
    private String _referencesText;
    private String _matchingReferencesText;
    private String _removeValueText;
    private String _removeValuesText;
    private String _addValuesText;
    private String _maxIndexText;
    private String _framesText;
    private String _framesWithAnyValueText;
    private String _valuesText;
    private String _valuesCountText;
    private String _frameValuesText;
    private String _allFrameValuesText;
    private String _longValueText;
    private PreparedStatement _addValuesBatchStmt;
    private int _addValuesBatchCounter;
    private static final int MAX_BATCH = 1000;
    private static final Map slotToFacetsCacheMap = new HashMap();
    private static final int LOOP_SIZE = 1000;
    private int loopcount;
    private int nFrames;
    private long previousTime;
    private String queryFrameTypeIdCommand;
    private String replaceFrameTypeCommand;
    private String replaceValueTypeCommand;
    private String _countFramesText;
    private String _getFramesText;
    private String _getFrameFromIdText;

    @Override
    public String getName() {
        return this.frameDbName;
    }

    @Override
    public void setName(String string) {
        this.frameDbName = string;
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        throw new UnsupportedOperationException();
    }

    private Object getCurrentSession() {
        return ServerFrameStore.getCurrentSession();
    }

    protected RobustConnection getCurrentConnection() throws SQLException {
        Object object = this.getCurrentSession();
        RobustConnection robustConnection = (RobustConnection)this._connections.get(object);
        if (robustConnection == null) {
            robustConnection = this.createConnection();
            this._connections.put(object, robustConnection);
        }
        return robustConnection;
    }

    @Override
    public void close() {
        this._frameFactory = null;
        try {
            for (Map.Entry entry : this._connections.entrySet()) {
                Object k = entry.getKey();
                RobustConnection robustConnection = (RobustConnection)entry.getValue();
                robustConnection.close();
                Log.getLogger().info("Closed connection for session: " + k);
            }
            this._connections.clear();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    protected void setMemoryProjectId(int n) {
        this.projectId = n;
    }

    public void initialize(FrameFactory frameFactory, String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Constructing database frame narrow frame store for " + string + " " + string2 + " " + string5);
            log.fine("No delegates");
        }
        this._isInclude = bl;
        this._table = string5;
        this._frameFactory = frameFactory;
        this._driver = string;
        this._url = string2;
        this._user = string3;
        this._password = string4;
        try {
            this.createConnection();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    public FrameFactory getFrameFactory() {
        return this._frameFactory;
    }

    public String getTable() {
        return this._table;
    }

    private void clearDeadConnections() throws SQLException {
        Iterator iterator = this._connections.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Session session = (Session)entry.getKey();
            if (!this.isDead(session)) continue;
            RobustConnection robustConnection = (RobustConnection)entry.getValue();
            robustConnection.close();
            iterator.remove();
        }
    }

    private boolean isDead(Session session) {
        return session != null && !Server.getInstance().isActive(session);
    }

    private RobustConnection createConnection() throws SQLException {
        this.clearDeadConnections();
        Object object = this.getCurrentSession();
        RobustConnection robustConnection = new RobustConnection(this._driver, this._url, this._user, this._password);
        this._connections.put(object, robustConnection);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created connection for " + object);
        }
        return robustConnection;
    }

    public static void setModifiable(boolean bl) {
        _isModifiable = bl;
    }

    public String getTableName() {
        return this._table;
    }

    private RuntimeException createRuntimeException(SQLException sQLException) {
        try {
            if (this.getCurrentConnection() != null) {
                this.getCurrentConnection().checkConnection();
            }
        }
        catch (SQLException sQLException2) {
            // empty catch block
        }
        Log.getLogger().info(Log.toString(sQLException));
        return new RuntimeException(sQLException.getMessage());
    }

    public boolean tableExists() {
        boolean bl = false;
        String string = "SELECT frame, frame_type FROM " + this._table;
        string = string + " WHERE slot = " + DatabaseFrameDb.getValue(Model.SlotID.NAME);
        string = string + " AND short_value = ':THING'";
        try {
            ResultSet resultSet = this.executeQuery(string);
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    public void createNewTableAndIndices() {
        try {
            this.ensureEmptyTableExists();
            this.createIndices();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private void ensureEmptyTableExists() throws SQLException {
        this.dropTableIfItExists();
        this.createTable();
    }

    private void dropTableIfItExists() {
        try {
            this.getCurrentConnection().closeStatements();
            String string = "DROP TABLE " + this._table;
            this.executeUpdate(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createTable() throws SQLException {
        String string = "CREATE TABLE " + this._table + " (";
        string = string + "frame " + this.getFrameDataType() + " NOT NULL, ";
        string = string + "frame_type " + this.getFrameTypeDataType() + " NOT NULL, ";
        string = string + "slot " + this.getFrameDataType() + " NOT NULL, ";
        string = string + "facet " + this.getFrameDataType() + " NOT NULL, ";
        string = string + "is_template " + this.getIsTemplateDataType() + " NOT NULL, ";
        string = string + "value_index " + this.getValueIndexDataType() + " NOT NULL, ";
        string = string + "value_type " + this.getFrameTypeDataType() + " NOT NULL, ";
        string = string + "short_value " + this.getShortValueDataType() + ", ";
        string = string + "long_value " + this.getLongValueDataType();
        string = string + ")";
        if (this.checkMySQLBug()) {
            string = string + " ENGINE = INNODB";
        }
        try {
            this.executeUpdate(string);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Created table with command '" + string + "'");
            }
        }
        catch (SQLException sQLException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Failed to create table on database ");
            stringBuffer.append(this.getCurrentConnection().getDatabaseProductName());
            stringBuffer.append(" with command '");
            stringBuffer.append(string);
            stringBuffer.append("' :");
            stringBuffer.append(sQLException.getMessage());
            Log.getLogger().warning(stringBuffer.toString());
            throw sQLException;
        }
    }

    private String getFrameDataType() throws SQLException {
        return this.getCurrentConnection().getIntegerTypeName();
    }

    private String getFrameTypeDataType() throws SQLException {
        return this.getCurrentConnection().getSmallIntTypeName();
    }

    private String getIsTemplateDataType() throws SQLException {
        return this.getCurrentConnection().getBitTypeName();
    }

    private String getValueIndexDataType() throws SQLException {
        return this.getCurrentConnection().getIntegerTypeName();
    }

    private String getShortValueDataType() throws SQLException {
        return this.getCurrentConnection().getVarcharTypeName() + "(" + this.getCurrentConnection().getMaxVarcharSize() + ")";
    }

    private String getLongValueDataType() throws SQLException {
        return this.getCurrentConnection().getLongvarcharTypeName();
    }

    public boolean checkMySQLBug() {
        try {
            if (this.getCurrentConnection().isMySql() && this.getCurrentConnection().getDatabaseMajorVersion() == 5) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Found mysql 5.0 - correcting for mysql bug 16121.");
                }
                return true;
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Exception caught checking database version", exception);
            Log.getLogger().warning("Unable to check database version with this jdbc driver");
            Log.getLogger().warning("If this database is mysql 5 then protege will perform incorrectly");
        }
        return false;
    }

    private void createIndices() throws SQLException {
        String string = "CREATE INDEX " + this._table + "_I1 ON " + this._table;
        string = string + " (frame, slot, facet, is_template, value_index)";
        this.executeUpdate(string);
        string = "CREATE INDEX " + this._table + "_I2 ON " + this._table;
        string = string + " (short_value)";
        this.executeUpdate(string);
        string = "CREATE INDEX " + this._table + "_I3 ON " + this._table;
        string = string + " (slot, frame_type)";
        this.executeUpdate(string);
        if (this.needsIndexOnLowerValue()) {
            this.createIndexOnLowerValue();
        }
    }

    private boolean needsIndexOnLowerValue() throws SQLException {
        return !this.getCurrentConnection().supportsCaseInsensitiveMatches() && this.getCurrentConnection().supportsIndexOnFunction();
    }

    private void createIndexOnLowerValue() throws SQLException {
        String string = "CREATE INDEX " + this._table + "_IV ON " + this._table + "(LOWER(" + SHORT_VALUE_COLUMN + "))";
        this.executeUpdate(string);
    }

    private static void traceUpdate(PreparedStatement preparedStatement) {
        DatabaseFrameDb.traceUpdate(preparedStatement, "");
    }

    private static void traceUpdate(PreparedStatement preparedStatement, String string) {
        if (log.isLoggable(Level.FINE)) {
            DatabaseFrameDb.trace(preparedStatement, string, Level.FINE);
        }
    }

    private static void traceQuery(PreparedStatement preparedStatement) {
        if (log.isLoggable(Level.FINER)) {
            DatabaseFrameDb.trace(preparedStatement, "", Level.FINER);
        }
    }

    private static void trace(PreparedStatement preparedStatement, String string, Level level) {
        if (log.isLoggable(level)) {
            int n;
            String string2 = preparedStatement.toString();
            if (string2.indexOf("PreparedStatement") != -1 && (n = string2.indexOf(32)) != -1) {
                string2 = string2.substring(n);
            }
            DatabaseFrameDb.trace(string2 + string, level);
        }
    }

    private static void trace(String string, Level level) {
        log.log(level, ++traceCount + " SQL: " + string);
    }

    private static void traceQuery(String string) {
        if (log.isLoggable(Level.FINER)) {
            DatabaseFrameDb.trace(string, Level.FINER);
        }
    }

    private static void traceUpdate(String string) {
        if (log.isLoggable(Level.FINE)) {
            DatabaseFrameDb.trace(string, Level.FINE);
        }
    }

    private static ResultSet executeQuery(PreparedStatement preparedStatement) throws SQLException {
        long l = 0L;
        DatabaseFrameDb.traceQuery(preparedStatement);
        if (log.isLoggable(Level.FINER)) {
            l = System.nanoTime();
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        if (log.isLoggable(Level.FINER)) {
            log.finer("Query took " + (double)(System.nanoTime() - l) / 1000000.0 + " milliseconds (more or less)");
        }
        return resultSet;
    }

    private ResultSet executeQuery(String string) throws SQLException {
        return this.executeQuery(string, 0);
    }

    private ResultSet executeQuery(String string, int n) throws SQLException {
        long l = 0L;
        DatabaseFrameDb.traceQuery(string);
        Statement statement = this.getCurrentConnection().getStatement();
        if (log.isLoggable(Level.FINER)) {
            l = System.nanoTime();
        }
        ResultSet resultSet = statement.executeQuery(string);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Query took " + (double)(System.nanoTime() - l) / 1000000.0 + " milliseconds (more or less)");
        }
        return resultSet;
    }

    private static void executeUpdate(PreparedStatement preparedStatement) throws SQLException {
        DatabaseFrameDb.traceUpdate(preparedStatement);
        preparedStatement.executeUpdate();
    }

    private void executeUpdate(String string) throws SQLException {
        DatabaseFrameDb.traceUpdate(string);
        this.getCurrentConnection().getStatement().executeUpdate(string);
    }

    @Override
    public void deleteFrame(Frame frame) {
        DatabaseFrameDb.checkModifiability();
        try {
            this.deleteFrameSQL(frame);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private void deleteFrameSQL(Frame frame) throws SQLException {
        String string = "DELETE FROM " + this._table + " WHERE " + FRAME_COLUMN + " = ?";
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(string);
        DatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DatabaseFrameDb.executeUpdate(preparedStatement);
        String string2 = "DELETE FROM " + this._table;
        string2 = string2 + " WHERE short_value = ? AND value_type = ?";
        PreparedStatement preparedStatement2 = this.getCurrentConnection().getPreparedStatement(string2);
        this.setShortValue(preparedStatement2, 1, 2, frame);
        DatabaseFrameDb.executeUpdate(preparedStatement2);
        if (frame instanceof Slot) {
            String string3 = "DELETE FROM " + this._table + " WHERE " + SLOT_COLUMN + " = ?";
            PreparedStatement preparedStatement3 = this.getCurrentConnection().getPreparedStatement(string3);
            DatabaseFrameDb.setFrame(preparedStatement3, 1, frame);
            DatabaseFrameDb.executeUpdate(preparedStatement3);
        } else if (frame instanceof Facet) {
            String string4 = "DELETE FROM " + this._table + " WHERE " + FACET_COLUMN + " = ?";
            PreparedStatement preparedStatement4 = this.getCurrentConnection().getPreparedStatement(string4);
            DatabaseFrameDb.setFrame(preparedStatement4, 1, frame);
            DatabaseFrameDb.executeUpdate(preparedStatement4);
        }
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        try {
            return this.getReferencesSQL(object);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private Set<Reference> getReferencesSQL(Object object) throws SQLException {
        if (this._referencesText == null) {
            this._referencesText = "SELECT short_value, frame, frame_type, slot, facet, is_template";
            this._referencesText = this._referencesText + " FROM " + this._table;
            this._referencesText = this._referencesText + " WHERE short_value = ?";
            this._referencesText = this._referencesText + " AND value_type = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._referencesText);
        this.setShortValue(preparedStatement, 1, 2, object);
        HashSet<Reference> hashSet = new HashSet<Reference>();
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        while (resultSet.next()) {
            Object object2;
            boolean bl = true;
            if (object instanceof String) {
                object2 = resultSet.getString(1);
                bl = object.toString().equals(object2);
            }
            if (!bl) continue;
            object2 = this.getFrame(resultSet, 2, 3);
            Slot slot = this.getSlot(resultSet, 4);
            Facet facet = this.getFacet(resultSet, 5);
            boolean bl2 = DatabaseFrameDb.getIsTemplate(resultSet, 6);
            hashSet.add(new ReferenceImpl((Frame)object2, slot, facet, bl2));
        }
        resultSet.close();
        return hashSet;
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int n) {
        try {
            return this.getMatchingReferencesSQL(string, n);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private Set<Reference> getMatchingReferencesSQL(String string, int n) throws SQLException {
        if (this._matchingReferencesText == null) {
            this._matchingReferencesText = "SELECT frame, frame_type, slot, facet";
            this._matchingReferencesText = this._matchingReferencesText + ", is_template";
            this._matchingReferencesText = this._matchingReferencesText + " FROM " + this._table;
            this._matchingReferencesText = this._matchingReferencesText + " WHERE value_type = " + DatabaseUtils.getStringValueType();
            this._matchingReferencesText = this._matchingReferencesText + " AND " + this.getShortValueMatchColumn();
            this._matchingReferencesText = this._matchingReferencesText + " LIKE '";
        }
        String string2 = this._matchingReferencesText + this.getMatchString(string) + "' " + this.getEscapeClause();
        HashSet<Reference> hashSet = new HashSet<Reference>();
        ResultSet resultSet = this.executeQuery(string2, n);
        while (resultSet.next()) {
            Frame frame = this.getFrame(resultSet, 1, 2);
            Slot slot = this.getSlot(resultSet, 3);
            Facet facet = this.getFacet(resultSet, 4);
            boolean bl = DatabaseFrameDb.getIsTemplate(resultSet, 5);
            hashSet.add(new ReferenceImpl(frame, slot, facet, bl));
        }
        resultSet.close();
        return hashSet;
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        DatabaseFrameDb.checkModifiability();
        try {
            this.removeValueSQL(frame, slot, facet, bl, object);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private void removeValueSQL(Frame frame, Slot slot, Facet facet, boolean bl, Object object) throws SQLException {
        if (this._removeValueText == null) {
            this._removeValueText = "DELETE FROM " + this._table;
            this._removeValueText = this._removeValueText + " WHERE frame = ?";
            this._removeValueText = this._removeValueText + " AND slot = ?";
            this._removeValueText = this._removeValueText + " AND facet = ?";
            this._removeValueText = this._removeValueText + " AND is_template = ?";
            this._removeValueText = this._removeValueText + " AND short_value = ?";
            this._removeValueText = this._removeValueText + " AND value_type = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._removeValueText);
        DatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        this.setShortValue(preparedStatement, 5, 6, object);
        DatabaseFrameDb.executeUpdate(preparedStatement);
    }

    public void removeValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        DatabaseFrameDb.checkModifiability();
        try {
            this.removeValuesSQL(frame, slot, facet, bl);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private void removeValuesSQL(Frame frame, Slot slot, Facet facet, boolean bl) throws SQLException {
        if (this._removeValuesText == null) {
            this._removeValuesText = "DELETE FROM " + this._table;
            this._removeValuesText = this._removeValuesText + " WHERE frame = ?";
            this._removeValuesText = this._removeValuesText + " AND slot = ?";
            this._removeValuesText = this._removeValuesText + " AND facet = ?";
            this._removeValuesText = this._removeValuesText + " AND is_template = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._removeValuesText);
        DatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        DatabaseFrameDb.executeUpdate(preparedStatement);
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        try {
            int n = this.getMaxIndex(frame, slot, facet, bl);
            this.addValuesSQL(frame, slot, facet, bl, collection, n + 1);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private PreparedStatement getAddValuesStatement() throws SQLException {
        if (this._addValuesText == null) {
            this._addValuesText = "INSERT INTO " + this._table;
            this._addValuesText = this._addValuesText + " (frame, frame_type, slot, facet, is_template, ";
            this._addValuesText = this._addValuesText + "value_index, short_value, long_value, value_type)";
            this._addValuesText = this._addValuesText + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }
        return this.getCurrentConnection().getPreparedStatement(this._addValuesText);
    }

    private void addValuesSQL(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection, int n) throws SQLException {
        PreparedStatement preparedStatement = this.getAddValuesStatement();
        boolean bl2 = collection.size() > 1 && this.getCurrentConnection().supportsBatch();
        DatabaseFrameDb.setFrame(preparedStatement, 1, 2, frame, this._frameFactory);
        DatabaseFrameDb.setSlot(preparedStatement, 3, slot);
        DatabaseFrameDb.setFacet(preparedStatement, 4, facet);
        DatabaseFrameDb.setIsTemplate(preparedStatement, 5, bl);
        for (Object e : collection) {
            if (DatabaseFrameDb.isNullValue(e)) {
                Log.getLogger().warning("Skiping null value");
                continue;
            }
            DatabaseFrameDb.setValueIndex(preparedStatement, 6, n);
            this.setValue(preparedStatement, 7, 8, 9, e);
            if (bl2) {
                preparedStatement.addBatch();
            } else {
                DatabaseFrameDb.executeUpdate(preparedStatement);
            }
            ++n;
        }
        if (bl2) {
            preparedStatement.executeBatch();
        }
    }

    private static boolean isNullValue(Object object) {
        boolean bl;
        boolean bl2 = bl = object == null;
        if (object instanceof String) {
            String string = (String)object;
            bl = string.trim().length() == 0;
        }
        return bl;
    }

    private int getMaxIndex(Frame frame, Slot slot, Facet facet, boolean bl) throws SQLException {
        if (this._maxIndexText == null) {
            this._maxIndexText = "SELECT MAX(value_index)";
            this._maxIndexText = this._maxIndexText + " FROM " + this._table;
            this._maxIndexText = this._maxIndexText + " WHERE frame = ?";
            this._maxIndexText = this._maxIndexText + " AND slot = ? ";
            this._maxIndexText = this._maxIndexText + " AND facet = ? ";
            this._maxIndexText = this._maxIndexText + " AND is_template = ? ";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._maxIndexText);
        DatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        int n = -1;
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        return n;
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        DatabaseFrameDb.checkModifiability();
        List list = this.getValues(frame, slot, facet, bl);
        Object e = list.remove(n);
        list.add(n2, e);
        this.setValues(frame, slot, facet, bl, list);
    }

    @Override
    public Set executeQuery(Query query) {
        return null;
    }

    public Set getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        try {
            return this.getMatchingFramesSQL(slot, facet, bl, string);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private String getShortValueMatchColumn() throws SQLException {
        String string = this.getCurrentConnection().supportsCaseInsensitiveMatches() ? SHORT_VALUE_COLUMN : "LOWER(short_value)";
        return string;
    }

    private Set getMatchingFramesSQL(Slot slot, Facet facet, boolean bl, String string) throws SQLException {
        String string2 = "SELECT frame, frame_type, slot, facet, is_template";
        string2 = string2 + " FROM " + this._table;
        string2 = string2 + " WHERE value_type = " + DatabaseUtils.getStringValueType();
        string2 = string2 + " AND " + this.getShortValueMatchColumn() + " LIKE '" + this.getMatchString(string) + "' " + this.getEscapeClause();
        HashSet<Frame> hashSet = new HashSet<Frame>();
        ResultSet resultSet = this.executeQuery(string2);
        while (resultSet.next()) {
            Frame frame = this.getFrame(resultSet, 1, 2);
            int n = resultSet.getInt(3);
            int n2 = resultSet.getInt(4);
            boolean bl2 = resultSet.getBoolean(5);
            if (!DatabaseFrameDb.equals(n, slot) || !DatabaseFrameDb.equals(n2, facet) || bl2 != bl) continue;
            hashSet.add(frame);
        }
        resultSet.close();
        return hashSet;
    }

    private static boolean equals(int n, Frame frame) {
        int n2 = frame == null ? 0 : DatabaseFrameDb.getValue(frame.getFrameID());
        return n == n2;
    }

    private String getMatchString(String string) throws SQLException {
        return DatabaseUtils.getMatchString(string, this.getCurrentConnection().getEscapeCharacter());
    }

    private String getEscapeClause() throws SQLException {
        return this.getCurrentConnection().getEscapeClause();
    }

    public Set getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        try {
            return this.getFramesSQL(slot, facet, bl, object);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private Set getFramesSQL(Slot slot, Facet facet, boolean bl, Object object) throws SQLException {
        if (this._framesText == null) {
            this._framesText = "SELECT short_value, frame, frame_type FROM " + this._table;
            this._framesText = this._framesText + " WHERE slot = ?";
            this._framesText = this._framesText + " AND facet = ?";
            this._framesText = this._framesText + " AND is_template = ?";
            this._framesText = this._framesText + " AND short_value = ?";
            this._framesText = this._framesText + " AND value_type = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._framesText);
        DatabaseFrameDb.setSlot(preparedStatement, 1, slot);
        DatabaseFrameDb.setFacet(preparedStatement, 2, facet);
        DatabaseFrameDb.setIsTemplate(preparedStatement, 3, bl);
        this.setShortValue(preparedStatement, 4, 5, object);
        HashSet<Object> hashSet = new HashSet<Object>();
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        while (resultSet.next()) {
            Object object2;
            boolean bl2 = true;
            if (object instanceof String) {
                object2 = resultSet.getString(1);
                bl2 = object.equals(object2);
            }
            if (!bl2) continue;
            object2 = this.getFrame(resultSet, 2, 3);
            hashSet.add(object2);
        }
        resultSet.close();
        return hashSet;
    }

    public Set getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        try {
            return this.getFramesWithAnyValueSQL(slot, facet, bl);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private Set getFramesWithAnyValueSQL(Slot slot, Facet facet, boolean bl) throws SQLException {
        if (this._framesWithAnyValueText == null) {
            this._framesWithAnyValueText = "SELECT frame, frame_type FROM " + this._table;
            this._framesWithAnyValueText = this._framesWithAnyValueText + " WHERE slot = ?";
            this._framesWithAnyValueText = this._framesWithAnyValueText + " AND facet = ?";
            this._framesWithAnyValueText = this._framesWithAnyValueText + " AND is_template = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._framesWithAnyValueText);
        DatabaseFrameDb.setSlot(preparedStatement, 1, slot);
        DatabaseFrameDb.setFacet(preparedStatement, 2, facet);
        DatabaseFrameDb.setIsTemplate(preparedStatement, 3, bl);
        HashSet<Frame> hashSet = new HashSet<Frame>();
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        while (resultSet.next()) {
            Frame frame = this.getFrame(resultSet, 1, 2);
            hashSet.add(frame);
        }
        resultSet.close();
        return hashSet;
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        DatabaseFrameDb.checkModifiability();
        try {
            this.removeValuesSQL(frame, slot, facet, bl);
            this.addValuesSQL(frame, slot, facet, bl, collection, 0);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        List list;
        try {
            list = this.getValuesSQL(frame, slot, facet, bl);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
        return list;
    }

    private List getValuesSQL(Frame frame, Slot slot, Facet facet, boolean bl) throws SQLException {
        if (this._valuesText == null) {
            this._valuesText = "SELECT short_value, value_type, value_index";
            this._valuesText = this._valuesText + " FROM " + this._table;
            this._valuesText = this._valuesText + " WHERE frame = ?";
            this._valuesText = this._valuesText + " AND slot = ?";
            this._valuesText = this._valuesText + " AND facet = ?";
            this._valuesText = this._valuesText + " AND is_template = ?";
            this._valuesText = this._valuesText + " ORDER BY value_index";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._valuesText);
        DatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        while (resultSet.next()) {
            int n;
            Object object = this.getShortValue(resultSet, 1, 2);
            if (object == null && (object = this.getLongValue(frame, slot, facet, bl, n = DatabaseFrameDb.getIndex(resultSet, 3))) == null) {
                object = "";
            }
            arrayList.add(object);
        }
        resultSet.close();
        return arrayList;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        int n = 0;
        try {
            n = this.getValuesCountSQL(frame, slot, facet, bl);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
        return n;
    }

    private int getValuesCountSQL(Frame frame, Slot slot, Facet facet, boolean bl) throws SQLException {
        if (this._valuesCountText == null) {
            this._valuesCountText = "SELECT COUNT(*) ";
            this._valuesCountText = this._valuesCountText + " FROM " + this._table;
            this._valuesCountText = this._valuesCountText + " WHERE frame = ?";
            this._valuesCountText = this._valuesCountText + " AND slot = ?";
            this._valuesCountText = this._valuesCountText + " AND facet = ?";
            this._valuesCountText = this._valuesCountText + " AND is_template = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._valuesCountText);
        DatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        int n = 0;
        while (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        return n;
    }

    public CacheMap getFrameValues() {
        try {
            return this.getFrameValuesSQL();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    public Map getFrameValues(Frame frame) {
        try {
            return this.getFrameValuesSQL(frame);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private static int getValue(FrameID frameID) {
        return DatabaseUtils.getValue(frameID);
    }

    private Map getFrameValuesSQL(Frame frame) throws SQLException {
        if (this._frameValuesText == null) {
            this._frameValuesText = "SELECT frame, slot, ";
            this._frameValuesText = this._frameValuesText + "facet, is_template, ";
            this._frameValuesText = this._frameValuesText + "short_value, value_type, value_index";
            this._frameValuesText = this._frameValuesText + " FROM " + this._table;
            this._frameValuesText = this._frameValuesText + " WHERE frame = ?";
            this._frameValuesText = this._frameValuesText + " AND slot <> " + DatabaseFrameDb.getValue(Model.SlotID.DIRECT_INSTANCES);
            this._frameValuesText = this._frameValuesText + " ORDER BY frame, slot, facet, is_template, value_index";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._frameValuesText);
        DatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        HashMap hashMap = new HashMap();
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        while (resultSet.next()) {
            int n;
            Slot slot = this.getSlot(resultSet, 2);
            Facet facet = this.getFacet(resultSet, 3);
            boolean bl = DatabaseFrameDb.getIsTemplate(resultSet, 4);
            Object object = this.getShortValue(resultSet, 5, 6);
            if (object == null && (object = this.getLongValue(frame, slot, facet, bl, n = DatabaseFrameDb.getIndex(resultSet, 7))) == null) {
                object = "";
            }
            DatabaseFrameDb.addToMap(hashMap, slot, facet, bl, object);
        }
        resultSet.close();
        return hashMap;
    }

    private CacheMap getFrameValuesSQL() throws SQLException {
        if (this._allFrameValuesText == null) {
            this._allFrameValuesText = "SELECT frame, frame_type";
            this._allFrameValuesText = this._allFrameValuesText + ", slot, facet, is_template";
            this._allFrameValuesText = this._allFrameValuesText + ", short_value, value_type, value_index";
            this._allFrameValuesText = this._allFrameValuesText + ", long_value";
            this._allFrameValuesText = this._allFrameValuesText + " FROM " + this._table;
            this._allFrameValuesText = this._allFrameValuesText + " ORDER BY slot, facet, is_template, value_index";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._allFrameValuesText);
        CacheMap cacheMap = new CacheMap();
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        while (resultSet.next()) {
            Frame frame = this.getFrame(resultSet, 1, 2);
            Slot slot = this.getSlot(resultSet, 3);
            Facet facet = this.getFacet(resultSet, 4);
            boolean bl = DatabaseFrameDb.getIsTemplate(resultSet, 5);
            Object object = this.getShortValue(resultSet, 6, 7);
            if (object == null && (object = DatabaseFrameDb.getLongValue(resultSet, 9)) == null) {
                object = "";
            }
            DatabaseFrameDb.addToMap(cacheMap, frame, slot, facet, bl, object);
        }
        resultSet.close();
        return cacheMap;
    }

    private static void addToMap(Map map, Slot slot, Facet facet, boolean bl, Object object) {
        Sft sft = new Sft(slot, facet, bl);
        ArrayList<Object> arrayList = (ArrayList<Object>)map.get(sft);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            map.put(sft, arrayList);
        }
        arrayList.add(object);
    }

    private static void addToMap(CacheMap cacheMap, Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        Map map = (Map)cacheMap.get(frame);
        if (map == null) {
            map = DatabaseFrameDb.createInitialMap(frame);
            cacheMap.put(frame, map);
        }
        DatabaseFrameDb.addToMap(map, slot, facet, bl, object);
    }

    private static Map createInitialMap(Frame frame) {
        HashMap hashMap = new HashMap();
        if (frame instanceof Cls) {
            Slot slot = frame.getKnowledgeBase().getSystemFrames().getDirectInstancesSlot();
            hashMap.put(new Sft(slot, null, false), new ArrayList());
        }
        return hashMap;
    }

    private Object getLongValue(Frame frame, Slot slot, Facet facet, boolean bl, int n) throws SQLException {
        if (this._longValueText == null) {
            this._longValueText = "SELECT long_value";
            this._longValueText = this._longValueText + " FROM " + this._table;
            this._longValueText = this._longValueText + " WHERE frame = ?";
            this._longValueText = this._longValueText + " AND slot = ?";
            this._longValueText = this._longValueText + " AND facet = ?";
            this._longValueText = this._longValueText + " AND is_template = ?";
            this._longValueText = this._longValueText + " AND value_index = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._longValueText);
        DatabaseFrameDb.setFrame(preparedStatement, 1, frame);
        DatabaseFrameDb.setSlot(preparedStatement, 2, slot);
        DatabaseFrameDb.setFacet(preparedStatement, 3, facet);
        DatabaseFrameDb.setIsTemplate(preparedStatement, 4, bl);
        DatabaseFrameDb.setValueIndex(preparedStatement, 5, n);
        Object object = null;
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        if (resultSet.next()) {
            object = DatabaseFrameDb.getLongValue(resultSet, 1);
        }
        resultSet.close();
        return object;
    }

    private static void setFrame(PreparedStatement preparedStatement, int n, Frame frame) throws SQLException {
        DatabaseUtils.setFrame(preparedStatement, n, frame);
    }

    private static void setFrame(PreparedStatement preparedStatement, int n, int n2, Frame frame, FrameFactory frameFactory) throws SQLException {
        DatabaseUtils.setFrame(preparedStatement, n, n2, frame, frameFactory);
    }

    private static void setSlot(PreparedStatement preparedStatement, int n, Slot slot) throws SQLException {
        DatabaseUtils.setSlot(preparedStatement, n, slot);
    }

    private static void setFacet(PreparedStatement preparedStatement, int n, Facet facet) throws SQLException {
        DatabaseUtils.setFacet(preparedStatement, n, facet);
    }

    private static void setIsTemplate(PreparedStatement preparedStatement, int n, boolean bl) throws SQLException {
        DatabaseUtils.setIsTemplate(preparedStatement, n, bl);
    }

    private void setShortValue(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        DatabaseUtils.setShortValue(preparedStatement, n, n2, object, this._frameFactory);
    }

    private void setValue(PreparedStatement preparedStatement, int n, int n2, int n3, Object object) throws SQLException {
        DatabaseUtils.setValue(preparedStatement, n, n2, n3, object, this.getCurrentConnection().getMaxVarcharSize(), this._frameFactory);
    }

    private static void setValueIndex(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        DatabaseUtils.setValueIndex(preparedStatement, n, n2);
    }

    private Frame getFrame(ResultSet resultSet, int n, int n2) throws SQLException {
        return DatabaseUtils.getFrame(resultSet, n, n2, this._frameFactory, this.projectId, this._isInclude);
    }

    private Slot getSlot(ResultSet resultSet, int n) throws SQLException {
        return DatabaseUtils.getSlot(resultSet, n, this._frameFactory, this.projectId, this._isInclude);
    }

    private Facet getFacet(ResultSet resultSet, int n) throws SQLException {
        return DatabaseUtils.getFacet(resultSet, n, this._frameFactory, this.projectId, this._isInclude);
    }

    private static int getIndex(ResultSet resultSet, int n) throws SQLException {
        return DatabaseUtils.getIndex(resultSet, n);
    }

    private static boolean getIsTemplate(ResultSet resultSet, int n) throws SQLException {
        return DatabaseUtils.getIsTemplate(resultSet, n);
    }

    private Object getShortValue(ResultSet resultSet, int n, int n2) throws SQLException {
        return DatabaseUtils.getShortValue(resultSet, n, n2, this._frameFactory, this.projectId, this._isInclude);
    }

    private static Object getLongValue(ResultSet resultSet, int n) throws SQLException {
        return DatabaseUtils.getLongValue(resultSet, n);
    }

    protected void beginBatch() throws SQLException {
        this._addValuesBatchStmt = this.getAddValuesStatement();
        this.getCurrentConnection().setAutoCommit(false);
        this._addValuesBatchCounter = 0;
    }

    protected void endBatch() throws SQLException {
        if (this._addValuesBatchCounter > 0) {
            this.executeBatch();
        }
        this._addValuesBatchStmt = null;
        this.getCurrentConnection().setAutoCommit(true);
    }

    public void overwriteKB(KnowledgeBase knowledgeBase, boolean bl) throws SQLException {
        slotToFacetsCacheMap.clear();
        this.ensureEmptyTableExists();
        boolean bl2 = knowledgeBase.setCallCachingEnabled(false);
        if (bl) {
            this.beginBatch();
            this.saveFrames(knowledgeBase);
            this.endBatch();
        }
        this.createIndices();
        knowledgeBase.setCallCachingEnabled(bl2);
    }

    protected void saveFrames(KnowledgeBase knowledgeBase) throws SQLException {
        this.nFrames = knowledgeBase.getFrameCount();
        this.loopcount = 0;
        this.previousTime = System.currentTimeMillis();
        if (this.nFrames > 1000) {
            Log.getLogger().info("Getting " + this.nFrames + " frames, please be patient, " + new Date());
        }
        Iterator<Frame> iterator = knowledgeBase.getFrames().iterator();
        while (iterator.hasNext()) {
            Frame frame = iterator.next();
            this.printTraceMessage();
            this.saveDirectOwnSlotValues(frame);
            if (frame instanceof Cls) {
                Cls cls = (Cls)frame;
                this.saveDirectTemplateSlotInformation(cls);
            }
            iterator.remove();
        }
    }

    private void printTraceMessage() {
        ++this.loopcount;
        if (this.loopcount % 1000 == 0) {
            long l = System.currentTimeMillis();
            long l2 = (l - this.previousTime) / 1000L;
            this.previousTime = l;
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            String string = this.loopcount + "/" + this.nFrames;
            string = string + ", " + new Date();
            string = string + ", delta=" + l2;
            string = string + ", mem(f/t/m)=" + runtime.freeMemory() / 1000L;
            string = string + "/" + runtime.totalMemory() / 1000L;
            string = string + "/" + runtime.maxMemory() / 1000L;
            Log.getLogger().info(string);
        }
    }

    protected void saveValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) throws SQLException {
        DatabaseFrameDb.setFrame(this._addValuesBatchStmt, 1, 2, frame, this._frameFactory);
        DatabaseFrameDb.setSlot(this._addValuesBatchStmt, 3, slot);
        DatabaseFrameDb.setFacet(this._addValuesBatchStmt, 4, facet);
        DatabaseFrameDb.setIsTemplate(this._addValuesBatchStmt, 5, bl);
        boolean bl2 = DatabaseFrameDb.locationIsSystem(frame, slot, facet);
        int n = 0;
        for (Object e : collection) {
            if (bl2 && DatabaseFrameDb.valueIsSystem(e)) continue;
            DatabaseFrameDb.setValueIndex(this._addValuesBatchStmt, 6, n);
            this.setValue(this._addValuesBatchStmt, 7, 8, 9, e);
            this.addBatch();
            ++n;
        }
    }

    private static boolean locationIsSystem(Frame frame, Slot slot, Facet facet) {
        boolean bl;
        boolean bl2 = bl = frame.isSystem() && slot.isSystem();
        if (bl && facet != null) {
            bl = facet.isSystem();
        }
        return bl;
    }

    private static boolean valueIsSystem(Object object) {
        boolean bl = true;
        if (object instanceof Frame) {
            Frame frame = (Frame)object;
            bl = frame.isSystem();
        }
        return bl;
    }

    private void addBatch() throws SQLException {
        this._addValuesBatchStmt.addBatch();
        ++this._addValuesBatchCounter;
        if (this._addValuesBatchCounter == 1000) {
            this.executeBatch();
        }
    }

    private void executeBatch() throws SQLException {
        this._addValuesBatchStmt.executeBatch();
        this._addValuesBatchCounter = 0;
        this.getCurrentConnection().commit();
    }

    private void saveDirectOwnSlotValues(Frame frame) throws SQLException {
        for (Slot slot : frame.getOwnSlots()) {
            List list = frame.getDirectOwnSlotValues(slot);
            this.saveValues(frame, slot, null, false, list);
        }
    }

    private void saveDirectTemplateSlotInformation(Cls cls) throws SQLException {
        for (Slot slot : cls.getTemplateSlots()) {
            List list = cls.getDirectTemplateSlotValues(slot);
            this.saveValues(cls, slot, null, true, list);
            this.saveDirectTemplateFacetValues(cls, slot);
        }
    }

    private void saveDirectTemplateFacetValues(Cls cls, Slot slot) throws SQLException {
        for (Facet facet : DatabaseFrameDb.getTemplateFacets(cls, slot)) {
            List list = cls.getDirectTemplateFacetValues(slot, facet);
            this.saveValues(cls, slot, facet, true, list);
        }
    }

    private static Collection getTemplateFacets(Cls cls, Slot slot) {
        Collection<Facet> collection = (Collection<Facet>)slotToFacetsCacheMap.get(slot);
        if (collection == null) {
            collection = cls.getTemplateFacets(slot);
            slotToFacetsCacheMap.put(slot, collection);
        }
        return collection;
    }

    @Override
    public boolean beginTransaction(String string) {
        DatabaseFrameDb.checkModifiability();
        try {
            return this.getCurrentConnection().beginTransaction();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    @Override
    public boolean commitTransaction() {
        DatabaseFrameDb.checkModifiability();
        try {
            return this.getCurrentConnection().commitTransaction();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    @Override
    public boolean rollbackTransaction() {
        DatabaseFrameDb.checkModifiability();
        try {
            return this.getCurrentConnection().rollbackTransaction();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private static void checkModifiability() {
        if (!_isModifiable) {
            throw new IllegalStateException("Database is not modifiable");
        }
    }

    @Override
    public void replaceFrame(Frame frame) {
        try {
            int n = DatabaseUtils.valueType(frame, this._frameFactory);
            this.replaceFrameTypeSQL(frame, n);
            this.replaceValueTypeSQL(frame, n);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private int getFrameTypeIdSQL(Frame frame) {
        try {
            if (this.queryFrameTypeIdCommand == null) {
                this.queryFrameTypeIdCommand = "SELECT frame_type";
                this.queryFrameTypeIdCommand = this.queryFrameTypeIdCommand + " FROM " + this._table;
                this.queryFrameTypeIdCommand = this.queryFrameTypeIdCommand + " WHERE frame = ?";
            }
            int n = -1;
            PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this.queryFrameTypeIdCommand);
            DatabaseFrameDb.setFrame(preparedStatement, 1, frame);
            preparedStatement.setMaxRows(1);
            ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            return n;
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
    }

    private void replaceFrameTypeSQL(Frame frame, int n) throws SQLException {
        if (this.replaceFrameTypeCommand == null) {
            this.replaceFrameTypeCommand = "UPDATE " + this._table + " SET " + FRAME_TYPE_COLUMN + " = ?";
            this.replaceFrameTypeCommand = this.replaceFrameTypeCommand + " WHERE frame = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this.replaceFrameTypeCommand);
        DatabaseUtils.setValueType(preparedStatement, 1, n);
        DatabaseUtils.setFrame(preparedStatement, 2, frame);
        DatabaseFrameDb.executeUpdate(preparedStatement);
    }

    private void replaceValueTypeSQL(Frame frame, int n) throws SQLException {
        if (this.replaceValueTypeCommand == null) {
            this.replaceValueTypeCommand = "UPDATE " + this._table + " SET " + VALUE_TYPE_COLUMN + " = ?";
            this.replaceValueTypeCommand = this.replaceValueTypeCommand + " WHERE short_value = ?";
            this.replaceValueTypeCommand = this.replaceValueTypeCommand + " AND value_type > 4";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this.replaceValueTypeCommand);
        DatabaseUtils.setValueType(preparedStatement, 1, n);
        DatabaseUtils.setFrame(preparedStatement, 2, frame);
        DatabaseFrameDb.executeUpdate(preparedStatement);
    }

    public String toString() {
        return "DatabaseFrameDb";
    }

    @Override
    public int getClsCount() {
        return this.countUniqueFrames(this._frameFactory.getClsJavaClassIds());
    }

    @Override
    public int getSlotCount() {
        return this.countUniqueFrames(this._frameFactory.getSlotJavaClassIds());
    }

    @Override
    public int getFacetCount() {
        return this.countUniqueFrames(this._frameFactory.getFacetJavaClassIds());
    }

    @Override
    public int getFrameCount() {
        return this.countUniqueFrames();
    }

    public Set getFrames() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Calling get frames...");
        }
        Set set = null;
        try {
            set = this.getFramesSQL();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
        return set;
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.countUniqueFrames(this._frameFactory.getSimpleInstanceJavaClassIds());
    }

    private int countUniqueFrames(Collection collection) {
        int n = -1;
        try {
            n = this.countFramesSQL(collection);
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
        return n;
    }

    private int countFramesSQL(Collection collection) throws SQLException {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT COUNT(*) FROM " + this._table);
        stringBuffer.append(" WHERE slot = " + DatabaseFrameDb.getValue(Model.SlotID.NAME));
        stringBuffer.append(" AND facet = 0");
        stringBuffer.append(" AND is_template = ?");
        stringBuffer.append(" AND (");
        boolean bl = true;
        for (Object object2 : collection) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" OR ");
            }
            stringBuffer.append("frame_type = ");
            stringBuffer.append((Integer)object2);
        }
        stringBuffer.append(")");
        object2 = this.getCurrentConnection().getPreparedStatement(stringBuffer.toString());
        DatabaseFrameDb.setIsTemplate((PreparedStatement)object2, 1, false);
        int n = -1;
        ResultSet resultSet = DatabaseFrameDb.executeQuery((PreparedStatement)object2);
        while (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        return n;
    }

    private int countUniqueFrames() {
        int n = -1;
        try {
            n = this.countFramesSQL();
        }
        catch (SQLException sQLException) {
            throw this.createRuntimeException(sQLException);
        }
        return n;
    }

    private int countFramesSQL() throws SQLException {
        if (this._countFramesText == null) {
            this._countFramesText = "SELECT COUNT(*) FROM " + this._table;
            this._countFramesText = this._countFramesText + " WHERE slot = " + DatabaseFrameDb.getValue(Model.SlotID.NAME);
            this._countFramesText = this._countFramesText + " AND facet = 0";
            this._countFramesText = this._countFramesText + " AND is_template = ?";
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._countFramesText);
        DatabaseFrameDb.setIsTemplate(preparedStatement, 1, false);
        int n = -1;
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        while (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        return n;
    }

    private Set getFramesSQL() throws SQLException {
        if (this._getFramesText == null) {
            this._getFramesText = "SELECT DISTINCT frame, frame_type";
            this._getFramesText = this._getFramesText + " FROM " + this._table;
        }
        PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._getFramesText);
        HashSet<Frame> hashSet = new HashSet<Frame>();
        ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
        while (resultSet.next()) {
            Frame frame = this.getFrame(resultSet, 1, 2);
            hashSet.add(frame);
        }
        resultSet.close();
        return hashSet;
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        Frame frame = null;
        if (this._getFrameFromIdText == null) {
            this._getFrameFromIdText = "SELECT DISTINCT frame, frame_type FROM " + this._table + " WHERE " + FRAME_COLUMN + " = ?";
        }
        try {
            if (frameID != null) {
                PreparedStatement preparedStatement = this.getCurrentConnection().getPreparedStatement(this._getFrameFromIdText);
                preparedStatement.setInt(1, frameID.getLocalPart());
                ResultSet resultSet = DatabaseFrameDb.executeQuery(preparedStatement);
                while (resultSet.next()) {
                    frame = this.getFrame(resultSet, 1, 2);
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            this.createRuntimeException(sQLException);
        }
        return frame;
    }

    @Override
    public FrameID generateFrameID() {
        return FrameID.createLocal(this.projectId, this.getNextFrameID());
    }

    private int getNextFrameID() {
        try {
            int n = 0;
            String string = "SELECT MAX(frame) FROM " + this._table;
            ResultSet resultSet = this.executeQuery(string);
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            lastReturnedFrameID = Math.max(n + 1, lastReturnedFrameID + 1);
        }
        catch (SQLException sQLException) {
            this.createRuntimeException(sQLException);
        }
        return lastReturnedFrameID;
    }

    @Override
    public NarrowFrameStore getDelegate() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Column {
        frame,
        frame_type,
        slot,
        facet,
        is_template,
        value_index,
        value_type,
        short_value,
        long_value;

    }
}

