/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class RobustConnection {
    private static final int ALLOWANCE = 100;
    private static final int ORACLE_MAX_VARCHAR_SIZE = 3066;
    private static final int SQLSERVER_MAX_VARCHAR_SIZE = 800;
    private static final int DEFAULT_MAX_VARCHAR_SIZE = 255;
    private Map _stringToPreparedStatementMap = new HashMap();
    private Connection _connection;
    private Statement _genericStatement;
    private String _url;
    private String _username;
    private String _password;
    private boolean _supportsBatch;
    private char _escapeChar;
    private String _escapeClause;
    private boolean _supportsTransactions;
    private int _maxVarcharSize;
    private int _nestedTransactionLevel;
    private String _driverLongvarcharTypeName;
    private String _driverTinyIntTypeName;
    private String _driverBitTypeName;
    private String _driverSmallIntTypeName;
    private String _driverIntegerTypeName;
    private String _driverVarcharTypeName;
    private String _driverCharTypeName;
    private static final String OLD_PROPERTY_LONGVARCHAR_TYPE_NAME = "SimpleJdbcDatabaseManager.longvarcharname";
    private static final String PROPERTY_LONGVARCHAR_TYPE_NAME = "Database.typename.longvarchar";
    private static final String PROPERTY_VARCHAR_TYPE_NAME = "Database.typename.varchar";
    private static final String PROPERTY_INTEGER_TYPE_NAME = "Database.typename.integer";
    private static final String PROPERTY_SMALL_INTEGER_TYPE_NAME = "Database.typename.small_integer";
    private static final String PROPERTY_BIT_TYPE_NAME = "Database.typename.bit";
    private static final String PROPERTY_CHAR_TYPE_NAME = "Database.typename.char";

    public RobustConnection(String string, String string2, String string3, String string4) throws SQLException {
        this._url = string2;
        this._username = string3;
        this._password = string4;
        Class clazz = SystemUtilities.forName(string);
        if (clazz == null) {
            throw new RuntimeException("class not found: " + string);
        }
        this.setupConnection();
        this.initializeMaxVarcharSize();
        this.initializeSupportsBatch();
        this.initializeSupportsEscapeSyntax();
        this.initializeDriverTypeNames();
        this.initializeSupportsTransactions();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this._connection.setAutoCommit(bl);
    }

    public void commit() throws SQLException {
        this._connection.commit();
    }

    private void setupConnection() throws SQLException {
        this._connection = DriverManager.getConnection(this._url, this._username, this._password);
    }

    public void close() throws SQLException {
        this.closeStatements();
        this._connection.close();
        this._connection = null;
    }

    public void closeStatements() throws SQLException {
        for (PreparedStatement preparedStatement : this._stringToPreparedStatementMap.values()) {
            preparedStatement.close();
        }
        this._stringToPreparedStatementMap.clear();
        if (this._genericStatement != null) {
            this._genericStatement.close();
            this._genericStatement = null;
        }
    }

    private void initializeMaxVarcharSize() throws SQLException {
        String string = SystemUtilities.getSystemProperty("database.varcharsize");
        this._maxVarcharSize = string != null && string.length() != 0 ? Integer.parseInt(string) : (this.isOracle() ? 3066 : (this.isSqlServer() ? 800 : 255));
    }

    private void initializeSupportsBatch() throws SQLException {
        this._supportsBatch = this._connection.getMetaData().supportsBatchUpdates();
        if (!this._supportsBatch) {
            String string = "This JDBC driver does not support batch update.";
            string = string + " For much better performance try using a newer driver";
            Log.getLogger().warning(string);
        }
    }

    private void initializeSupportsTransactions() throws SQLException {
        this._supportsTransactions = this._connection.getMetaData().supportsTransactions();
        if (!this._supportsTransactions) {
            Log.getLogger().warning("This database does not support transactions");
        }
    }

    private void initializeSupportsEscapeSyntax() throws SQLException {
        this._escapeChar = '\u0000';
        this._escapeClause = "";
        boolean bl = this._connection.getMetaData().supportsLikeEscapeClause();
        if (bl) {
            if (this.isMySql()) {
                this._escapeChar = (char)92;
            } else {
                this._escapeChar = (char)124;
                this._escapeClause = "{ESCAPE '" + this._escapeChar + "'}";
            }
        } else {
            Log.getLogger().warning("This driver does not support SQL Escape processing.");
        }
    }

    public char getEscapeCharacter() {
        return this._escapeChar;
    }

    public String getEscapeClause() {
        return this._escapeClause;
    }

    public boolean supportsBatch() {
        return this._supportsBatch;
    }

    public PreparedStatement getPreparedStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this._stringToPreparedStatementMap.get(string);
        if (preparedStatement == null) {
            preparedStatement = this._connection.prepareStatement(string);
            this._stringToPreparedStatementMap.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    public Statement getStatement() throws SQLException {
        if (this._genericStatement == null) {
            this._genericStatement = this._connection.createStatement();
        }
        return this._genericStatement;
    }

    public void checkConnection() throws SQLException {
        if (this._connection == null) {
            this.setupConnection();
        } else if (this._connection.isClosed()) {
            Log.getLogger().warning("Found closed connection, reinitializing...");
            this.close();
            this.setupConnection();
        }
    }

    public boolean isOracle() throws SQLException {
        return this.getDatabaseProductName().equalsIgnoreCase("oracle");
    }

    public boolean isSqlServer() throws SQLException {
        return this.getDatabaseProductName().equalsIgnoreCase("Microsoft SQL Server");
    }

    public boolean isMsAccess() throws SQLException {
        return this.getDatabaseProductName().equalsIgnoreCase("access");
    }

    public boolean isMySql() throws SQLException {
        return this.getDatabaseProductName().equalsIgnoreCase("mysql");
    }

    public boolean isPostgres() throws SQLException {
        return this.getDatabaseProductName().equalsIgnoreCase("PostgreSQL");
    }

    public String getDatabaseProductName() throws SQLException {
        return this._connection.getMetaData().getDatabaseProductName();
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this._connection.getMetaData().getDatabaseMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this._connection.getMetaData().getDatabaseMinorVersion();
    }

    public int getMaxVarcharSize() {
        return this._maxVarcharSize;
    }

    private void initializeDriverTypeNames() throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = null;
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTypeInfo();
        while (resultSet.next()) {
            String string4 = resultSet.getString("TYPE_NAME");
            int n = resultSet.getInt("DATA_TYPE");
            if (string4.length() == 0) continue;
            switch (n) {
                case -1: {
                    if (this._driverLongvarcharTypeName != null) break;
                    this._driverLongvarcharTypeName = string4;
                    break;
                }
                case -4: {
                    if (string != null) break;
                    string = string4;
                    break;
                }
                case 2005: {
                    if (string3 != null) break;
                    string3 = string4;
                    break;
                }
                case 2004: {
                    if (string2 != null) break;
                    string2 = string4;
                    break;
                }
                case -6: {
                    if (this._driverTinyIntTypeName != null) break;
                    this._driverTinyIntTypeName = string4;
                    break;
                }
                case -7: {
                    if (this._driverBitTypeName != null) break;
                    this._driverBitTypeName = string4;
                    break;
                }
                case 5: {
                    if (this._driverSmallIntTypeName != null) break;
                    this._driverSmallIntTypeName = string4;
                    break;
                }
                case 4: {
                    if (this._driverIntegerTypeName != null) break;
                    this._driverIntegerTypeName = string4;
                    break;
                }
                case 12: {
                    if (this._driverVarcharTypeName != null) break;
                    this._driverVarcharTypeName = string4;
                    break;
                }
                case 1: {
                    if (this._driverCharTypeName != null) break;
                    this._driverCharTypeName = string4;
                    break;
                }
            }
        }
        resultSet.close();
        if (this._driverLongvarcharTypeName == null) {
            this._driverLongvarcharTypeName = string == null ? (string3 == null ? string2 : string3) : string;
            if (this._driverLongvarcharTypeName == null && this.isPostgres()) {
                this._driverLongvarcharTypeName = "TEXT";
            }
        }
        if (this._driverIntegerTypeName == null) {
            this._driverIntegerTypeName = "INTEGER";
        }
        if (this._driverSmallIntTypeName == null) {
            this._driverSmallIntTypeName = this._driverIntegerTypeName;
        }
        if (this._driverTinyIntTypeName == null) {
            this._driverTinyIntTypeName = this._driverSmallIntTypeName;
        }
        if (this._driverBitTypeName == null) {
            this._driverBitTypeName = this._driverTinyIntTypeName;
        }
        if (this._driverVarcharTypeName == null || this.isPostgres()) {
            this._driverVarcharTypeName = "VARCHAR";
        }
    }

    private static String getName(String string, String string2) {
        String string3 = ApplicationProperties.getApplicationOrSystemProperty(string);
        return string3 == null || string3.length() == 0 ? string2 : string3;
    }

    public String getLongvarcharTypeName() {
        String string = SystemUtilities.getSystemProperty(OLD_PROPERTY_LONGVARCHAR_TYPE_NAME);
        if (string == null || string.length() == 0) {
            string = RobustConnection.getName(PROPERTY_LONGVARCHAR_TYPE_NAME, this._driverLongvarcharTypeName);
        }
        if (string == null) {
            string = this.getVarcharTypeName();
            Log.getLogger().warning("Using VARCHAR in place of LONGVARCHAR, long strings will be truncated.");
        }
        return string;
    }

    public String getSmallIntTypeName() {
        return RobustConnection.getName(PROPERTY_SMALL_INTEGER_TYPE_NAME, this._driverSmallIntTypeName);
    }

    public String getIntegerTypeName() {
        return RobustConnection.getName(PROPERTY_INTEGER_TYPE_NAME, this._driverIntegerTypeName);
    }

    public String getBitTypeName() {
        return RobustConnection.getName(PROPERTY_BIT_TYPE_NAME, this._driverBitTypeName);
    }

    public String getVarcharTypeName() {
        return RobustConnection.getName(PROPERTY_VARCHAR_TYPE_NAME, this._driverVarcharTypeName);
    }

    public String getCharTypeName() {
        return RobustConnection.getName(PROPERTY_CHAR_TYPE_NAME, this._driverCharTypeName);
    }

    public boolean supportsCaseInsensitiveMatches() throws SQLException {
        return !this.isOracle() && !this.isPostgres();
    }

    public boolean supportsIndexOnFunction() throws SQLException {
        return this.isOracle() || this.isPostgres();
    }

    public boolean beginTransaction() {
        boolean bl = false;
        try {
            if (this._supportsTransactions) {
                if (this._nestedTransactionLevel == 0) {
                    if (this.isMsAccess()) {
                        this.closeStatements();
                    }
                    this._connection.setAutoCommit(false);
                }
                ++this._nestedTransactionLevel;
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            Log.getLogger().warning(sQLException.toString());
        }
        return bl;
    }

    public boolean commitTransaction() {
        boolean bl = false;
        try {
            if (this._supportsTransactions) {
                --this._nestedTransactionLevel;
                if (this._nestedTransactionLevel == 0) {
                    this._connection.commit();
                    this._connection.setAutoCommit(true);
                }
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            Log.getLogger().warning(sQLException.toString());
        }
        return bl;
    }

    public boolean rollbackTransaction() {
        boolean bl = false;
        try {
            if (this._supportsTransactions) {
                --this._nestedTransactionLevel;
                if (this._nestedTransactionLevel == 0) {
                    this._connection.rollback();
                    this._connection.setAutoCommit(true);
                }
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            Log.getLogger().warning(sQLException.toString());
        }
        return bl;
    }
}

