/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.BrowserComparator;
import edu.stanford.smi.protege.ui.Finder;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import edu.stanford.smi.protege.util.StringMatcher;
import edu.stanford.smi.protege.util.WaitCursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;

public abstract class FrameTreeFinder
extends Finder {
    private JTree tree;
    private KnowledgeBase knowledgeBase;

    protected KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    protected FrameTreeFinder(KnowledgeBase knowledgeBase, JTree jTree, ResourceKey resourceKey) {
        super(resourceKey);
        this.tree = jTree;
        this.knowledgeBase = knowledgeBase;
    }

    protected FrameTreeFinder(KnowledgeBase knowledgeBase, JTree jTree, String string) {
        super(string);
        this.tree = jTree;
        this.knowledgeBase = knowledgeBase;
    }

    protected FrameTreeFinder(KnowledgeBase knowledgeBase, JTree jTree, String string, Icon icon) {
        super(string, icon);
        this.tree = jTree;
        this.knowledgeBase = knowledgeBase;
    }

    protected int getBestMatch(List list, String string) {
        Instance instance;
        String string2;
        int n;
        int n2 = Collections.binarySearch(list, string, new BrowserComparator());
        if (n2 < 0 && (n = -(n2 + 1)) < list.size() && (string2 = (instance = (Instance)list.get(n)).getBrowserText().toLowerCase()).startsWith(string.toLowerCase())) {
            n2 = n;
        }
        return n2;
    }

    protected void select(Object object) {
        WaitCursor waitCursor = new WaitCursor(this);
        Frame frame = (Frame)object;
        ArrayList arrayList = new ArrayList();
        this.getVisiblePathToRoot(frame, arrayList);
        Collections.reverse(arrayList);
        ComponentUtilities.setSelectedObjectPath(this.tree, arrayList);
        waitCursor.hide();
    }

    protected List getMatches(String string, int n) {
        Object object;
        Cls cls = this.knowledgeBase.getRootCls();
        Set set = this.getMatchingFrames(string, n);
        LazyTreeRoot lazyTreeRoot = (LazyTreeRoot)this.tree.getModel().getRoot();
        HashSet hashSet = new HashSet((Collection)lazyTreeRoot.getUserObject());
        if (hashSet.size() != 1 || !FrameTreeFinder.equals(CollectionUtilities.getFirstItem(hashSet), cls)) {
            object = set.iterator();
            while (object.hasNext()) {
                Frame frame = (Frame)object.next();
                boolean bl = hashSet.contains(frame);
                if (!bl) {
                    HashSet hashSet2 = new HashSet(this.getAncestors(frame));
                    bl = hashSet2.removeAll(hashSet);
                }
                if (bl) continue;
                object.remove();
            }
        }
        object = new ArrayList(set);
        Collections.sort(object, new FrameComparator());
        return object;
    }

    protected StringMatcher getStringMatcher(String string) {
        return new SimpleStringMatcher(string);
    }

    protected Set getMatchingFrames(String string, int n) {
        if (!string.endsWith("*")) {
            string = string + '*';
        }
        StringMatcher stringMatcher = this.getStringMatcher(string);
        LinkedHashSet<Frame> linkedHashSet = new LinkedHashSet<Frame>();
        Collection collection = this.knowledgeBase.getMatchingReferences(string, n);
        for (Reference reference : collection) {
            Frame frame = reference.getFrame();
            if (!this.isCorrectType(frame) || !stringMatcher.isMatch(frame.getBrowserText())) continue;
            linkedHashSet.add(frame);
        }
        return linkedHashSet;
    }

    protected void getVisiblePathToRoot(Frame frame, Collection collection) {
        boolean bl;
        ArrayList arrayList = new ArrayList((Collection)((LazyTreeNode)this.tree.getModel().getRoot()).getUserObject());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Frame frame2 = (Frame)iterator.next();
            if (frame2.isVisible()) continue;
            iterator.remove();
        }
        collection.add(frame);
        if (!arrayList.contains(frame) && !(bl = this.getVisiblePathToRoot(frame, arrayList, collection))) {
            Log.getLogger().warning("No visible path found for " + frame);
        }
    }

    protected boolean getVisiblePathToRoot(Frame frame, Collection collection, Collection collection2) {
        boolean bl = false;
        Iterator iterator = this.getParents(frame).iterator();
        while (iterator.hasNext() && !bl) {
            Frame frame2 = (Frame)iterator.next();
            if (!frame2.isVisible() || collection2.contains(frame2)) continue;
            collection2.add(frame2);
            bl = collection.contains(frame2) ? true : this.getVisiblePathToRoot(frame2, collection, collection2);
            if (bl) continue;
            collection2.remove(frame2);
        }
        return bl;
    }

    protected abstract Collection getParents(Frame var1);

    protected abstract Collection getAncestors(Frame var1);

    protected abstract boolean isCorrectType(Frame var1);

    protected abstract Slot getBrowserSlot(KnowledgeBase var1);
}

