/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectFromFilePlugin;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerPanel;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ExtensionFilter;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.URLPanel;
import edu.stanford.smi.protege.util.Validatable;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ProjectChooser
extends JFileChooser {
    private static Logger log = Log.getLogger(ProjectChooser.class);
    private JPanel pane;
    private CardLayout layout = new CardLayout();
    public static final String FILE_CARD = "File";
    public static final String URL_CARD = "URL";
    public static final String SERVER_CARD = "Server";
    private ButtonGroup buttonGroup = new ButtonGroup();
    private static final String CARD_NAME_PROPERTY = "project_chooser.selected_card";
    private JDialog dialog;
    private URLPanel urlPanel;
    private ServerPanel serverPanel;
    private int returnValue = 1;

    public ProjectChooser() {
        this.setControlButtonsAreShown(false);
        this.setDialogTitle("Open Project");
        String string = Text.getProgramName() + " Project";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(".pprj");
        Collection collection = PluginUtilities.getAvailableCreateProjectFromFilePluginClassNames();
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            string = "Supported Files";
        }
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            try {
                CreateProjectFromFilePlugin createProjectFromFilePlugin = (CreateProjectFromFilePlugin)clazz.newInstance();
                String[] stringArray = createProjectFromFilePlugin.getSuffixes();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    arrayList.add(string2);
                }
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.INFO, "Exception caught", exception);
            }
        }
        this.setFileFilter(new ExtensionFilter(arrayList.iterator(), string));
        this.setCurrentDirectory(ApplicationProperties.getLastFileDirectory());
        this.setName(FILE_CARD);
    }

    protected JDialog createDialog(Component component) {
        this.dialog = super.createDialog(component);
        Container container = this.dialog.getContentPane();
        container.remove(this);
        container.setLayout(new BorderLayout());
        this.pane = new JPanel(this.layout);
        this.pane.add(FILE_CARD, this);
        this.urlPanel = new URLPanel();
        this.pane.add(URL_CARD, this.urlPanel);
        this.serverPanel = new ServerPanel();
        this.pane.add(SERVER_CARD, this.serverPanel);
        this.urlPanel.setBorder(this.getBorder());
        this.serverPanel.setBorder(this.getBorder());
        this.serverPanel.setName(SERVER_CARD);
        this.layout.show(this.pane, ApplicationProperties.getString(CARD_NAME_PROPERTY, FILE_CARD));
        container.add((Component)this.createSelectionButtonPane(), "West");
        container.add((Component)this.pane, "Center");
        container.add((Component)this.createOKCancelButtonPane(), "South");
        return this.dialog;
    }

    private Component getActiveCard() {
        Component component = null;
        for (int i = 0; i < this.pane.getComponentCount(); ++i) {
            Component component2 = this.pane.getComponent(i);
            if (!component2.isVisible()) continue;
            component = component2;
            break;
        }
        return component;
    }

    private void attemptClose(int n) {
        if (this.canClose(n)) {
            this.returnValue = n;
            this.dialog.setVisible(false);
        }
    }

    public boolean canClose(int n) {
        Component component;
        boolean bl = true;
        if (n == 0 && (component = this.getActiveCard()) instanceof Validatable) {
            Validatable validatable = (Validatable)((Object)component);
            bl = validatable.validateContents();
        }
        return bl;
    }

    public int showOpenDialog(Component component) {
        int n = super.showOpenDialog(component);
        if (n == 0) {
            this.returnValue = 0;
        }
        Component component2 = this.getActiveCard();
        ApplicationProperties.setString(CARD_NAME_PROPERTY, component2.getName());
        return this.returnValue;
    }

    private JPanel createSelectionButtonPane() {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.add(this.createSelectionButton(FILE_CARD));
        jPanel.add(this.createSelectionButton(URL_CARD));
        jPanel.add(this.createSelectionButton(SERVER_CARD));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private AbstractButton createSelectionButton(final String string) {
        AbstractAction abstractAction = new AbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectChooser.this.layout.show(ProjectChooser.this.pane, string);
            }
        };
        JToggleButton jToggleButton = new JToggleButton(abstractAction);
        int n = 75;
        jToggleButton.setPreferredSize(new Dimension(n, n));
        this.buttonGroup.add(jToggleButton);
        if (this.getActiveCard().getName().equals(string)) {
            jToggleButton.setSelected(true);
        }
        return jToggleButton;
    }

    private JComponent createOKCancelButtonPane() {
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 10, 10));
        jPanel.add(this.createButton(0, ResourceKey.OK_BUTTON_LABEL));
        jPanel.add(this.createButton(1, ResourceKey.CANCEL_BUTTON_LABEL));
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private JButton createButton(final int n, ResourceKey resourceKey) {
        StandardAction standardAction = new StandardAction(resourceKey){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectChooser.this.attemptClose(n);
            }
        };
        JButton jButton = ComponentFactory.createButton(standardAction);
        jButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        ProjectChooser.this.attemptClose(n);
                        break;
                    }
                    case 27: {
                        ProjectChooser.this.attemptClose(1);
                        break;
                    }
                }
            }
        });
        return jButton;
    }

    public Project getProject() {
        Project project = null;
        Component component = this.getActiveCard();
        if (component == this) {
            Object object;
            File file = this.getSelectedFile();
            String string = file.toString();
            int n = string.lastIndexOf(46);
            if (n > 0 && n < string.length() - 1) {
                object = string.substring(n + 1);
                Iterator iterator = PluginUtilities.getAvailableCreateProjectFromFilePluginClassNames().iterator();
                while (iterator.hasNext() && project == null) {
                    Class clazz = (Class)iterator.next();
                    project = this.useCreateProjectFromFilePlugin(clazz, (String)object, string);
                    if (project == null) continue;
                    String string2 = string.substring(0, n) + ".pprj";
                    project.setProjectFilePath(string2);
                }
            }
            if (project == null) {
                object = this.getSelectedFile().toURI();
                project = this.loadProject((URI)object);
            }
            ApplicationProperties.setLastFileDirectory(this.getCurrentDirectory());
        } else if (component == this.urlPanel) {
            URI uRI = this.urlPanel.getURI();
            if (uRI != null) {
                ApplicationProperties.setLastLoadedURI(uRI);
                project = this.loadProject(uRI);
            }
        } else if (component == this.serverPanel) {
            project = this.getRemoteProject();
        } else {
            Log.getLogger().warning("bad component: " + component);
        }
        return project;
    }

    private Project getRemoteProject() {
        RemoteServer remoteServer = this.serverPanel.getServer();
        RemoteSession remoteSession = this.serverPanel.getSession();
        return RemoteProjectManager.getInstance().getServerProject(this, remoteServer, remoteSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project loadProject(URI uRI) {
        Project project = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        long l = System.currentTimeMillis();
        WaitCursor waitCursor = new WaitCursor(this);
        try {
            project = Project.loadProjectFromURI(uRI, arrayList);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Error loading project kb", exception);
            arrayList.add(exception);
        }
        finally {
            waitCursor.hide();
        }
        long l2 = System.currentTimeMillis();
        Log.getLogger().info("Project load time for " + uRI + ": " + (l2 - l) / 1000L + " sec");
        if (project != null && project.getProjectInstance() == null) {
            String string = "Unable to load file: " + uRI + "\nPossible reasons:\n- The file has an unsupported file format\n- The file is not well-formed\n- The project file is corrupt";
            Log.getLogger().severe(string);
            arrayList.add(string);
            JOptionPane.showMessageDialog(ProjectManager.getProjectManager().getMainPanel(), string, "Invalid project file", 2);
        }
        ProjectManager.getProjectManager().displayErrors("Load Project Errors", arrayList);
        return project;
    }

    public Project useCreateProjectFromFilePlugin(Class clazz, String string, String string2) {
        if (clazz != null) {
            try {
                CreateProjectFromFilePlugin createProjectFromFilePlugin;
                Object t = clazz.newInstance();
                if (t instanceof CreateProjectFromFilePlugin && PluginUtilities.isSuitableCreateProjectFromFilePlugin(createProjectFromFilePlugin = (CreateProjectFromFilePlugin)t, string)) {
                    File file = new File(string2);
                    ArrayList arrayList = new ArrayList();
                    Project project = createProjectFromFilePlugin.createProject(file, arrayList);
                    if (!arrayList.isEmpty()) {
                        for (Object e : arrayList) {
                            System.err.println("Error with file " + string2 + ": " + e);
                        }
                    }
                    return project;
                }
            }
            catch (Exception exception) {
                log.log(Level.WARNING, "Warning: Failed handle argument with " + clazz, exception);
            }
        }
        return null;
    }
}

