/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JList;

public class InstanceFieldWidget
extends AbstractSlotWidget {
    private JList _list;
    private Instance _instance;
    private AllowableAction _createAction;
    private AllowableAction _addAction;
    private AllowableAction _removeAction;
    private AllowableAction _deleteAction;
    private boolean _showNewInstances = true;
    private FrameListener _instanceListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent frameEvent) {
            InstanceFieldWidget.this._list.repaint();
        }
    };

    protected void addButton(LabeledComponent labeledComponent, Action action, boolean bl) {
        if (action != null) {
            this.addButtonConfiguration(action, bl);
            if (this.displayButton(action)) {
                labeledComponent.addHeaderButton(action);
            }
        }
    }

    protected void addButtons(LabeledComponent labeledComponent) {
        this.addButton(labeledComponent, this.getViewInstanceAction(), true);
        this.addButton(labeledComponent, new ReferencersAction(this), false);
        this.addButton(labeledComponent, this.getCreateInstanceAction(), true);
        this.addButton(labeledComponent, this.getSelectInstanceAction(), true);
        this.addButton(labeledComponent, this.getRemoveInstanceAction(), true);
        this.addButton(labeledComponent, this.getDeleteInstancesAction(), false);
    }

    public JList createList() {
        SelectableList selectableList = ComponentFactory.createSingleItemList(this.getDoubleClickAction());
        selectableList.setCellRenderer(FrameRenderer.createInstance());
        return selectableList;
    }

    public void dispose() {
        if (this._instance != null) {
            this._instance.removeFrameListener(this._instanceListener);
        }
        super.dispose();
    }

    protected Action getCreateInstanceAction() {
        this._createAction = new CreateAction(ResourceKey.INSTANCE_CREATE){

            public void onCreate() {
                InstanceFieldWidget.this.handleCreateAction();
            }
        };
        return this._createAction;
    }

    protected Action getDeleteInstancesAction() {
        this._deleteAction = new DeleteInstancesAction(this);
        return this._deleteAction;
    }

    protected Action getRemoveInstanceAction() {
        this._removeAction = new RemoveAction(ResourceKey.INSTANCE_REMOVE, (Selectable)this){

            public void onRemove(Object object) {
                InstanceFieldWidget.this.handleRemoveAction();
            }
        };
        return this._removeAction;
    }

    protected Action getSelectInstanceAction() {
        this._addAction = new AddAction(ResourceKey.INSTANCE_ADD){

            public void onAdd() {
                InstanceFieldWidget.this.handleAddAction();
            }
        };
        return this._addAction;
    }

    public Collection getSelection() {
        return CollectionUtilities.createCollection(this._instance);
    }

    public Collection getValues() {
        return CollectionUtilities.createList(this._instance);
    }

    protected Action getViewInstanceAction() {
        return new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){

            public void onView(Object object) {
                InstanceFieldWidget.this.handleViewAction((Instance)object);
            }
        };
    }

    protected void handleAddAction() {
        Collection collection = this.getCls().getTemplateSlotAllowedClses(this.getSlot());
        Instance instance = DisplayUtilities.pickInstance((Component)this, collection);
        if (instance != null) {
            this.setDisplayedInstance(instance);
        }
    }

    protected void handleCreateAction() {
        Collection collection = this.getCls().getTemplateSlotAllowedClses(this.getSlot());
        Cls cls = DisplayUtilities.pickConcreteCls((Component)this, this.getKnowledgeBase(), collection);
        if (cls != null) {
            Cls cls2;
            Instance instance = this.getKnowledgeBase().createInstance(null, cls);
            if (instance instanceof Cls && (cls2 = (Cls)instance).getDirectSuperclassCount() == 0) {
                cls2.addDirectSuperclass(this.getKnowledgeBase().getRootCls());
            }
            if (this._showNewInstances) {
                this.showInstance(instance);
            }
            this.setDisplayedInstance(instance);
        }
    }

    protected void handleRemoveAction() {
        this.removeDisplayedInstance();
    }

    protected void handleViewAction(Instance instance) {
        this.showInstance(instance);
    }

    public void initialize() {
        this._list = this.createList();
        LabeledComponent labeledComponent = new LabeledComponent(this.getLabel(), this._list);
        this.addButtons(labeledComponent);
        this.add(labeledComponent);
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        boolean bl;
        if (cls == null || slot == null) {
            bl = false;
        } else {
            boolean bl2 = cls.getTemplateSlotValueType(slot) == ValueType.INSTANCE;
            boolean bl3 = cls.getTemplateSlotAllowsMultipleValues(slot);
            bl = bl2 && !bl3;
        }
        return bl;
    }

    protected void removeDisplayedInstance() {
        this.replaceInstance(null);
        this.updateList();
        this.valueChanged();
    }

    protected void replaceInstance(Instance instance) {
        if (this._instance != null) {
            this._instance.removeFrameListener(this._instanceListener);
        }
        this._instance = instance;
        if (this._instance != null) {
            this._instance.addFrameListener(this._instanceListener);
        }
        this.notifySelectionListeners();
    }

    protected void setDisplayedInstance(Instance instance) {
        this.replaceInstance(instance);
        this.updateList();
        this.valueChanged();
    }

    public void setEditable(boolean bl) {
        InstanceFieldWidget.setAllowed(this._createAction, bl);
        InstanceFieldWidget.setAllowed(this._addAction, bl);
        InstanceFieldWidget.setAllowed(this._removeAction, bl);
        InstanceFieldWidget.setAllowed(this._deleteAction, bl);
    }

    public void setValues(Collection collection) {
        Instance instance = (Instance)CollectionUtilities.getFirstItem(collection);
        this.replaceInstance(instance);
        this.updateList();
    }

    protected void updateList() {
        ComponentUtilities.setListValues(this._list, CollectionUtilities.createCollection(this._instance));
    }

    public boolean getShowNewInstances() {
        return this._showNewInstances;
    }

    public void setShowNewInstances(boolean bl) {
        this._showNewInstances = bl;
    }
}

