/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.database.CreateOWLDatabaseProjectPlugin;
import edu.stanford.smi.protegex.owl.database.InitOWLDatabaseFromFileWizardPage;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;

public class CreateOWLDatabaseFromFileProjectPlugin
extends CreateOWLDatabaseProjectPlugin {
    public CreateOWLDatabaseFromFileProjectPlugin() {
        super("OWL File (.owl or .rdf)");
    }

    protected Project buildNewProject(KnowledgeBaseFactory factory) {
        JenaKnowledgeBaseFactory.useStandalone = false;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        Project project = super.createNewProject(factory);
        this.initializeSources(project.getSources());
        try {
            File tempProjectFile = File.createTempFile("protege", "temp");
            project.setProjectFilePath(tempProjectFile.getPath());
            project.save(errors);
            project = Project.loadProjectFromFile((String)tempProjectFile.getPath(), errors);
            OWLDatabaseModel owlModel = (OWLDatabaseModel)project.getKnowledgeBase();
            this.updateTripleStores(owlModel);
            ProtegeOWLParser parser = new ProtegeOWLParser(owlModel, false);
            try {
                parser.run(this.ontologyFileURI);
            }
            catch (Exception ex) {
                Log.getLogger().severe("Could not load OWL file into database: " + ex);
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                errors.add(ex);
            }
            owlModel.resetTripleStoreModel();
            this.handleErrors(errors);
            project.setProjectFilePath(null);
            tempProjectFile.delete();
            this.updateTripleStores(owlModel);
        }
        catch (IOException e) {
            Log.getLogger().severe(Log.toString((Throwable)e));
        }
        return project;
    }

    private void updateTripleStores(OWLDatabaseModel owlModel) {
        owlModel.resetTripleStoreModel();
        TripleStore topTripleStore = owlModel.getTripleStoreModel().getTopTripleStore();
        owlModel.getTripleStoreModel().setActiveTripleStore(topTripleStore);
        MergingNarrowFrameStore mnfs = MergingNarrowFrameStore.get((KnowledgeBase)owlModel);
        mnfs.setTopFrameStore(mnfs.getActiveFrameStore().getName());
    }

    public boolean canCreateProject(KnowledgeBaseFactory factory, boolean useExistingSources) {
        return super.canCreateProject(factory, useExistingSources) && useExistingSources;
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard wizard, boolean useExistingSources) {
        return new InitOWLDatabaseFromFileWizardPage((Wizard)wizard, this);
    }
}

