/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.translator;

import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.Collection;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultDIGQueryResponse
implements DIGQueryResponse {
    private Element element;
    private OWLModel kb;

    public DefaultDIGQueryResponse(OWLModel kb) {
        this.kb = kb;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String getID() {
        return this.element.getAttribute("id");
    }

    public Collection getConcepts() {
        NodeList synonymsList = this.element.getElementsByTagName("synonyms");
        HashSet<OWLNamedClass> conceptList = new HashSet<OWLNamedClass>(synonymsList.getLength());
        int i = 0;
        while (i < synonymsList.getLength()) {
            NodeList catomList = ((Element)synonymsList.item(i)).getElementsByTagName("catom");
            int j = 0;
            while (j < catomList.getLength()) {
                String name = ((Element)catomList.item(j)).getAttribute("name");
                OWLNamedClass aClass = this.kb.getOWLNamedClass(name);
                if (aClass != null) {
                    conceptList.add(aClass);
                }
                ++j;
            }
            if (((Element)synonymsList.item(i)).getElementsByTagName("top").getLength() != 0) {
                conceptList.add(this.kb.getOWLThingClass());
            }
            ++i;
        }
        return conceptList;
    }

    public Collection getIndividuals() {
        HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
        NodeList individualElementList = this.element.getElementsByTagName("individual");
        int i = 0;
        while (i < individualElementList.getLength()) {
            Element individualElement = (Element)individualElementList.item(i);
            OWLIndividual curInd = this.kb.getOWLIndividual(individualElement.getAttribute("name"));
            if (curInd != null) {
                individuals.add(curInd);
            }
            ++i;
        }
        return individuals;
    }

    public boolean getBoolean() {
        String val = this.element.getTagName();
        boolean b = true;
        if (val.equals("false")) {
            b = false;
        }
        return b;
    }
}

