/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslator;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.CollectionResultReasonerTask;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Document;

public class GetConceptIntersectionSuperclassesTask
extends AbstractReasonerTask
implements CollectionResultReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;
    private OWLClass[] clses;
    private HashSet result;

    public GetConceptIntersectionSuperclassesTask(OWLClass[] clses, ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.clses = clses;
        this.result = new HashSet();
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        this.setProgress(0);
        DIGTranslator translator = this.getTranslator();
        Document doc = translator.createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        translator.createDirectSuperConceptsQuery(doc, "q0", this.clses);
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(doc);
        Iterator it = translator.getDIGQueryResponseIterator(this.protegeOWLReasoner.getKnowledgeBase(), responseDoc);
        while (it.hasNext()) {
            DIGQueryResponse response = (DIGQueryResponse)it.next();
            this.result.addAll(response.getConcepts());
        }
        this.setProgress(1);
        this.setTaskCompleted();
    }

    public Collection getResult() {
        return this.result;
    }
}

