/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.model.impl.Util;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParserLogger;
import edu.stanford.smi.protegex.owl.jena.parser.URI2NameConverter;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultURI2NameConverter
implements URI2NameConverter {
    private int externalResourceIndex = 1;
    private boolean firstDefaultNamespaceHandled = false;
    private ProtegeOWLParserLogger logger;
    private OWLModel owlModel;
    private Map prefix2URI = new HashMap();
    private Map uri2Prefix = new HashMap();
    private Set ontologyURIs;
    private static final String ANONYMOUS_PREFIX = "@";
    private static final String EXTERNAL_RESOURCE_PREFIX = "&";
    private static final String TEMPORARY_PREFIX = "^";
    private static final String PREFIX_BASE = "p";

    public DefaultURI2NameConverter(OWLModel owlModel, ProtegeOWLParserLogger logger, boolean incremental) {
        this.owlModel = owlModel;
        this.logger = logger;
        this.firstDefaultNamespaceHandled = incremental;
        this.updateInternalState();
        this.initPrefixesFromOWLModel();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String addPrefix(String uri, String prefix) {
        String existingURI = this.getNamespace(prefix);
        if (existingURI != null) {
            if (prefix.length() == 0) {
                if (this.firstDefaultNamespaceHandled) return prefix;
                this.addPrefixHelper(uri, prefix);
                this.firstDefaultNamespaceHandled = true;
                return prefix;
            }
            if (uri.equals(existingURI)) return prefix;
            this.logger.logWarning("Conflicting prefix found " + prefix + ":" + "\n  Existing namespace: " + existingURI + "\n  New namespace: " + uri);
            return prefix;
        }
        String existingPrefix = this.getPrefix(uri);
        if (existingPrefix == null) {
            this.addPrefixHelper(uri, prefix);
            return prefix;
        }
        if (existingPrefix.equals(prefix)) return prefix;
        if (this.isPreferredPrefix(prefix, uri)) {
            this.addPrefixHelper(uri, prefix);
            return prefix;
        }
        if (existingPrefix.length() <= 0) return existingPrefix;
        this.logger.logWarning("Ignoring namespace prefix \"" + prefix + "\" for existing prefix \"" + existingPrefix + "\"");
        return existingPrefix;
    }

    private void addPrefixHelper(String uri, String prefix) {
        this.uri2Prefix.put(uri, prefix);
        this.prefix2URI.put(prefix, uri);
    }

    public String createAnonymousRDFResourceName() {
        return this.owlModel.getNextAnonymousResourceName();
    }

    private String createNewPrefixHelper(String namespace) {
        String prefix;
        int index = 1;
        do {
            prefix = PREFIX_BASE + index;
            ++index;
        } while (this.uri2Prefix.containsValue(prefix));
        return prefix;
    }

    public String createNewPrefix(String uri) {
        int index = Util.splitNamespace((String)uri);
        String namespace = uri.substring(0, index);
        String prefix = this.createNewPrefixHelper(namespace);
        this.addPrefixHelper(namespace, prefix);
        return prefix;
    }

    private String getNamespace(String prefix) {
        return (String)this.prefix2URI.get(prefix);
    }

    private String getPrefix(String uri) {
        return (String)this.uri2Prefix.get(uri);
    }

    public String getRDFExternalResourceName() {
        String name;
        while (this.owlModel.getFrame(name = EXTERNAL_RESOURCE_PREFIX + this.externalResourceIndex++) != null) {
        }
        return name;
    }

    public String getRDFResourceName(String uri) {
        String name;
        String l;
        if (this.ontologyURIs.contains(uri)) {
            String prefix = this.getPrefix(uri = Jena.getNamespaceFromURI(uri));
            if (prefix == null) {
                return null;
            }
            return String.valueOf(prefix) + ":";
        }
        int lindex = uri.lastIndexOf(35);
        if (lindex > 0 && lindex < uri.length() - 1 && !this.owlModel.isValidResourceName(l = uri.substring(lindex + 1), null)) {
            l = AbstractOWLModel.getValidOWLFrameName(null, l);
            uri = String.valueOf(uri.substring(0, lindex + 1)) + l;
        }
        int index = Util.splitNamespace((String)uri);
        String namespace = uri.substring(0, index);
        String localName = uri.substring(index);
        if (ProtegeNames.NS.equals(namespace) && localName.length() > 0 && this.owlModel.getFrame(name = ":" + localName) != null) {
            return name;
        }
        String prefix = this.getPrefix(namespace);
        if (prefix == null) {
            return null;
        }
        if (prefix.length() == 0) {
            if (localName.length() == 0) {
                return ":";
            }
            return localName;
        }
        return String.valueOf(prefix) + ":" + localName;
    }

    public String getResourceNamespace(String uri) {
        int index = Util.splitNamespace((String)uri);
        return uri.substring(0, index);
    }

    public String getTemporaryRDFResourceName(String uri) {
        return TEMPORARY_PREFIX + uri;
    }

    public String getTemporaryRDFResourceName(AResource node) {
        if (node.isAnonymous()) {
            return ANONYMOUS_PREFIX + node.toString();
        }
        return this.getTemporaryRDFResourceName(node.getURI());
    }

    public String getURIFromTemporaryName(String temporaryName) {
        return temporaryName.substring(TEMPORARY_PREFIX.length());
    }

    private void initPrefixesFromOWLModel() {
        NamespaceManager nsm = this.owlModel.getNamespaceManager();
        this.addPrefixHelper(nsm.getDefaultNamespace(), "");
        for (String prefix : nsm.getPrefixes()) {
            String namespace = nsm.getNamespaceForPrefix(prefix);
            this.addPrefixHelper(namespace, prefix);
        }
    }

    public boolean isAnonymousRDFResourceName(String name) {
        return name.startsWith(ANONYMOUS_PREFIX);
    }

    protected boolean isPreferredPrefix(String prefix, String uri) {
        return prefix.equals("owl") || prefix.equals("rdf") || prefix.equals("rdfs") || prefix.equals("swrl");
    }

    public boolean isTemporaryRDFResourceName(String name) {
        return name.startsWith(TEMPORARY_PREFIX);
    }

    public void updateInternalState() {
        this.ontologyURIs = new HashSet();
        for (Object next : this.owlModel.getOWLOntologies()) {
            String uri;
            RDFResource ontology;
            String name;
            if (!(next instanceof RDFResource)) {
                next = new DefaultOWLOntology(this.owlModel, ((Frame)next).getFrameID());
            }
            if ((name = (ontology = (RDFResource)next).getName()).length() <= 0) continue;
            if (this.isTemporaryRDFResourceName(name)) {
                uri = this.getURIFromTemporaryName(name);
                this.ontologyURIs.add(uri);
                continue;
            }
            uri = ontology.getURI();
            this.ontologyURIs.add(uri);
        }
        ArrayList<String> prefixes = new ArrayList<String>(this.owlModel.getNamespaceManager().getPrefixes());
        prefixes.add("");
        for (String prefix : prefixes) {
            String ns = this.owlModel.getNamespaceManager().getNamespaceForPrefix(prefix);
            if (ns == null) continue;
            if (ns.endsWith("#") || ns.endsWith(":")) {
                ns = ns.substring(0, ns.length() - 1);
            }
            this.ontologyURIs.add(ns);
        }
    }
}

