/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultClassFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchAdapter;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LoadNamespacesTestCase
extends AbstractJenaTestCase {
    private URI tempSavedFileURI = new File(ProtegeOWL.getPluginFolder(), "temp.owl").toURI();
    private static final String TEST_1 = "http://www.co-ode.org/ontology/test1.owl#";
    private static final String TEST_2 = "http://www.co-ode.org/ontology/test2.owl#";
    private static final String TEST_1_PREFIX = "test1";
    private static final String TEST_2_PREFIX = "test2";
    private static final String AUTO_1_PREFIX = "p1";
    private static final String AUTO_2_PREFIX = "p2";
    private boolean searching = true;

    public void testLoadOntologyWithSameDefaultNSAndXMLBase() throws Exception {
        this.loadRemoteOntology("namespaces/nsAndBaseSame.owl");
        HashMap<String, String> expectedNamespaces = new HashMap<String, String>();
        expectedNamespaces.put("Class_1", TEST_1);
        expectedNamespaces.put("Class_2", TEST_1);
        expectedNamespaces.put("Class_3", TEST_2);
        HashMap<String, String> expectedPrefixes = new HashMap<String, String>();
        expectedPrefixes.put("Class_1", null);
        expectedPrefixes.put("Class_2", null);
        expectedPrefixes.put("Class_3", TEST_2_PREFIX);
        this.assertOntologyIsAsExpected(expectedNamespaces, expectedPrefixes);
        LoadNamespacesTestCase.assertEquals((String)"http://www.co-ode.org/ontology/test1.owl", (String)this.owlModel.getDefaultOWLOntology().getURI());
        this.owlModel.save(this.tempSavedFileURI);
        System.out.println("saved to " + this.tempSavedFileURI);
        this.loadTestOntology(this.tempSavedFileURI);
        this.assertOntologyIsAsExpected(expectedNamespaces, expectedPrefixes);
        LoadNamespacesTestCase.assertEquals((String)"http://www.co-ode.org/ontology/test1.owl", (String)this.owlModel.getDefaultOWLOntology().getURI());
    }

    public void testLoadOntologyWithDifferentDefaultNSAndXMLBase() throws Exception {
        this.loadRemoteOntology("namespaces/nsAndBaseDiff.owl");
        HashMap<String, String> expectedNamespaces = new HashMap<String, String>();
        expectedNamespaces.put("Class_1", TEST_1);
        expectedNamespaces.put("Class_2", TEST_1);
        expectedNamespaces.put("Class_3", TEST_2);
        HashMap<String, String> expectedPrefixes = new HashMap<String, String>();
        expectedPrefixes.put("Class_1", AUTO_1_PREFIX);
        expectedPrefixes.put("Class_2", AUTO_1_PREFIX);
        expectedPrefixes.put("Class_3", TEST_2_PREFIX);
        this.assertOntologyIsAsExpected(expectedNamespaces, expectedPrefixes);
        this.owlModel.save(this.tempSavedFileURI);
        System.out.println("saved to " + this.tempSavedFileURI);
        this.loadTestOntology(this.tempSavedFileURI);
        this.assertOntologyIsAsExpected(expectedNamespaces, expectedPrefixes);
    }

    public void testLoadOntologyWithNoDefaultNSOrXMLBase() throws Exception {
        this.loadRemoteOntology("namespaces/noDefaultNSNoBase.owl");
        HashMap<String, String> expectedNamespaces = new HashMap<String, String>();
        expectedNamespaces.put("Class_1", TEST_1);
        expectedNamespaces.put("Class_2", TEST_1);
        expectedNamespaces.put("Class_3", TEST_2);
        HashMap<String, String> expectedPrefixes = new HashMap<String, String>();
        expectedPrefixes.put("Class_1", AUTO_1_PREFIX);
        expectedPrefixes.put("Class_2", AUTO_1_PREFIX);
        expectedPrefixes.put("Class_3", TEST_2_PREFIX);
        this.assertOntologyIsAsExpected(expectedNamespaces, expectedPrefixes);
        LoadNamespacesTestCase.assertEquals((String)"http://www.co-ode.org/ontology/test1.owl", (String)this.owlModel.getDefaultOWLOntology().getURI());
        this.owlModel.save(this.tempSavedFileURI);
        System.out.println("saved to " + this.tempSavedFileURI);
        this.loadTestOntology(this.tempSavedFileURI);
        this.assertOntologyIsAsExpected(expectedNamespaces, expectedPrefixes);
    }

    public void testDefaultNamespaces() throws Exception {
        Collection oldOntologies = this.owlModel.getOWLOntologies();
        LoadNamespacesTestCase.assertSize(1, oldOntologies);
        JenaOWLModel newModel = LoadNamespacesTestCase.reload(this.owlModel);
        Collection ontologies = newModel.getOWLOntologies();
        LoadNamespacesTestCase.assertSize(1, ontologies);
        LoadNamespacesTestCase.assertContains((Object)newModel.getDefaultOWLOntology(), ontologies);
        NamespaceManager nsm = newModel.getNamespaceManager();
        LoadNamespacesTestCase.assertEquals((String)"http://www.owl-ontologies.com/unnamed.owl#", (String)nsm.getDefaultNamespace());
        LoadNamespacesTestCase.assertEquals((String)OWL.getURI(), (String)nsm.getNamespaceForPrefix("owl"));
        LoadNamespacesTestCase.assertEquals((String)RDF.getURI(), (String)nsm.getNamespaceForPrefix("rdf"));
        LoadNamespacesTestCase.assertEquals((String)RDFS.getURI(), (String)nsm.getNamespaceForPrefix("rdfs"));
    }

    public void testMissingPrefixForImport() throws Exception {
        this.loadRemoteOntology("importTravelNoPrefix.owl");
    }

    public void testMissingPrefix() throws Exception {
        this.loadRemoteOntology("concepts.owl");
        LoadNamespacesTestCase.assertNotNull((Object)this.owlModel.getDefaultOWLOntology());
    }

    private void assertOntologyIsAsExpected(Map expectedNamespaces, Map expectedPrefixes) {
        DefaultClassFind find = new DefaultClassFind(this.owlModel, 2);
        find.addResultListener(new SearchAdapter(){

            public void searchCompleteEvent(int numResults, Find source) {
                LoadNamespacesTestCase.this.searching = false;
            }
        });
        for (String current : expectedNamespaces.keySet()) {
            System.out.println("current = " + current);
            this.searching = true;
            find.startSearch(current);
            while (this.searching) {
                Thread.yield();
            }
            Set results = find.getResultResources();
            LoadNamespacesTestCase.assertTrue((results.size() > 0 ? 1 : 0) != 0);
            OWLNamedClass c = (OWLNamedClass)CollectionUtilities.getFirstItem((Collection)results);
            System.out.println("current URI = " + c.getURI());
            LoadNamespacesTestCase.assertNotNull((Object)c);
            LoadNamespacesTestCase.assertEquals(expectedNamespaces.get(current), (Object)c.getNamespace());
            LoadNamespacesTestCase.assertEquals(expectedPrefixes.get(current), (Object)c.getNamespacePrefix());
        }
        LoadNamespacesTestCase.assertNotNull((Object)this.owlModel.getDefaultOWLOntology());
    }
}

