/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Restriction;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;

public class CreateHasValueRestrictionsTestCase
extends AbstractProtege2JenaTestCase {
    public void testHasValueRestrictionWithIndividual() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        RDFResource instance = cls.createInstance("instance");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        cls.addSuperclass(this.owlModel.createOWLHasValue(property, instance));
        OntModel ontModel = this.createOntModel();
        Restriction restriction = this.getRestriction(ontModel.getOntClass(cls.getURI()));
        CreateHasValueRestrictionsTestCase.assertTrue((boolean)restriction.canAs(HasValueRestriction.class));
        HasValueRestriction hr = restriction.asHasValueRestriction();
        CreateHasValueRestrictionsTestCase.assertEquals((Object)ontModel.getOntProperty(property.getURI()), (Object)hr.getOnProperty());
        CreateHasValueRestrictionsTestCase.assertEquals((Object)ontModel.getIndividual(instance.getURI()), (Object)hr.getHasValue());
    }

    public void testHasValueRestrictionWithLiteral() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        cls.addSuperclass(this.owlModel.createOWLHasValue(property, "A"));
        OntModel ontModel = this.createOntModel();
        Restriction restriction = this.getRestriction(ontModel.getOntClass(cls.getURI()));
        CreateHasValueRestrictionsTestCase.assertTrue((boolean)restriction.canAs(HasValueRestriction.class));
        HasValueRestriction hr = restriction.asHasValueRestriction();
        CreateHasValueRestrictionsTestCase.assertEquals((Object)ontModel.getOntProperty(property.getURI()), (Object)hr.getOnProperty());
        CreateHasValueRestrictionsTestCase.assertEquals((Object)ontModel.createTypedLiteral((Object)"A"), (Object)hr.getHasValue());
    }
}

