/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.dl;

import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.classparser.dl.DLSyntaxParser;
import edu.stanford.smi.protegex.owl.model.classparser.dl.DLSyntaxParserUtil;
import edu.stanford.smi.protegex.owl.model.classparser.dl.ParseException;

public class DLSyntaxClassParser
implements OWLClassParser {
    public void checkClass(OWLModel owlModel, String expression) throws OWLClassParseException {
        this.parse(owlModel, expression, false);
    }

    public void checkHasValueFiller(OWLModel owlModel, String expression) throws OWLClassParseException {
        this.parse(owlModel, expression, false);
    }

    public void checkQuantifierFiller(OWLModel owlModel, String expression) throws OWLClassParseException {
        this.parse(owlModel, expression, false);
    }

    public RDFSClass parseClass(OWLModel owlModel, String expression) throws OWLClassParseException {
        return this.parse(owlModel, expression, true);
    }

    public Object parseHasValueFiller(OWLModel owlModel, String expression) throws OWLClassParseException {
        return this.parse(owlModel, expression, true);
    }

    public RDFResource parseQuantifierFiller(OWLModel owlModel, String expression) throws OWLClassParseException {
        return this.parse(owlModel, expression, true);
    }

    private OWLClass parse(OWLModel owlModel, String expression, boolean create) throws OWLClassParseException {
        try {
            String parsableExpr = DLSyntaxParserUtil.getParseableString(expression);
            OWLClass cls = DLSyntaxParser.parseExpression(owlModel, parsableExpr, create);
            return cls;
        }
        catch (ParseException e) {
            throw this.wrapAndThrowException(e);
        }
    }

    private OWLClassParseException wrapAndThrowException(ParseException e) {
        OWLClassParseException parseException = new OWLClassParseException(e.getMessage());
        parseException.nextCouldBeClass = this.contains(e.expectedTokenSequences, 25);
        parseException.nextCouldBeProperty = this.contains(e.expectedTokenSequences, 27) | this.contains(e.expectedTokenSequences, 26);
        parseException.nextCouldBeIndividual = this.contains(e.expectedTokenSequences, 28);
        parseException.nextCouldBeDatatypeName = this.contains(e.expectedTokenSequences, 24);
        return parseException;
    }

    private boolean contains(int[][] tokenSequences, int val) {
        int i = 0;
        while (i < tokenSequences.length) {
            int[] seq = tokenSequences[i];
            int j = 0;
            while (j < seq.length) {
                if (seq[j] == val) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

