/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.dl.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.classparser.dl.DLSyntaxParser;
import edu.stanford.smi.protegex.owl.model.classparser.dl.ParseException;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class DLSyntaxParserTests
extends AbstractJenaTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.owlModel.createOWLNamedClass("A");
        this.owlModel.createOWLNamedClass("B");
        this.owlModel.createOWLNamedClass("C");
        this.owlModel.createOWLObjectProperty("p");
        this.owlModel.createOWLDatatypeProperty("q");
        this.owlModel.getOWLThingClass().createOWLIndividual("i");
        this.owlModel.getOWLThingClass().createOWLIndividual("j");
        this.owlModel.getOWLThingClass().createOWLIndividual("k");
    }

    private void parsePass(String expression, Class c) {
        try {
            OWLClass cls = DLSyntaxParser.parseExpression(this.owlModel, expression, true);
            System.out.println("Class: " + cls.getBrowserText());
            DLSyntaxParserTests.assertTrue((boolean)c.isInstance(cls));
        }
        catch (ParseException e) {
            DLSyntaxParserTests.fail((String)e.getMessage());
        }
    }

    public void testOWLUnionClass() {
        this.parsePass("A | B | C", OWLUnionClass.class);
    }

    public void testOWLIntersectionClass() {
        this.parsePass("A & B & C", OWLIntersectionClass.class);
    }

    public void testOWLAllValuesFromDatatype() {
        this.parsePass("* q int", OWLAllValuesFrom.class);
    }

    public void testOWLAllValuesFrom() {
        this.parsePass("* p A", OWLAllValuesFrom.class);
    }

    public void testOWLSomeValuesFrom() {
        this.parsePass("? p A", OWLSomeValuesFrom.class);
    }

    public void testOWLMinCardinality() {
        this.parsePass("> 3 p", OWLMinCardinality.class);
    }

    public void testOWLMinQCardinality() {
        this.parsePass("> 3 p A", OWLMinCardinality.class);
    }

    public void testOWLCardinality() {
        this.parsePass("= 3 p", OWLCardinality.class);
    }

    public void testOWLQCardinality() {
        this.parsePass("= 3 p A", OWLCardinality.class);
    }

    public void testOWLMaxCardinality() {
        this.parsePass("< 3 p", OWLMaxCardinality.class);
    }

    public void testOWLMaxQCardinality() {
        this.parsePass("< 3 p A", OWLMaxCardinality.class);
    }

    public void testOWLEnumerationClass() {
        this.parsePass("{i j k}", OWLEnumeratedClass.class);
    }

    public void testOWLComplementClass() {
        this.parsePass("!A", OWLComplementClass.class);
    }

    public void testComplexFiller() {
        this.parsePass("? p (! (A | B))", OWLSomeValuesFrom.class);
    }
}

