/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.net.URI;
import java.util.Iterator;

public class DeletePropertyTestCase
extends AbstractJenaTestCase {
    public void testDeletePropertyValues() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        OWLNamedClass subject = this.owlThing;
        subject.addPropertyValue(property, "Test");
        DeletePropertyTestCase.assertSize(1, subject.getPropertyValues(property));
        property.delete();
        Iterator triples = this.owlModel.getTripleStoreModel().getActiveTripleStore().listTriples();
        triples.next();
        DeletePropertyTestCase.assertFalse((boolean)triples.hasNext());
    }

    public void testDeleteEquivalentClassOnPropertyDeleteProgrammatically() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Superclass");
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(property, 1);
        OWLIntersectionClass intersectionClass = this.owlModel.createOWLIntersectionClass();
        intersectionClass.addOperand(superclass);
        intersectionClass.addOperand(restriction);
        c.setDefinition(intersectionClass);
        c.removeSuperclass(this.owlThing);
        DeletePropertyTestCase.assertSize(1, c.getNamedSuperclasses(false));
        DeletePropertyTestCase.assertContains((Object)superclass, c.getNamedSuperclasses(false));
        DeletePropertyTestCase.assertSize(1, c.getPropertyValues(this.owlModel.getRDFSSubClassOfProperty()));
        DeletePropertyTestCase.assertContains((Object)superclass, c.getPropertyValues(this.owlModel.getRDFSSubClassOfProperty()));
        property.delete();
        DeletePropertyTestCase.assertSize(1, c.getNamedSuperclasses(false));
        DeletePropertyTestCase.assertContains((Object)superclass, c.getNamedSuperclasses(false));
        DeletePropertyTestCase.assertSize(1, c.getPropertyValues(this.owlModel.getRDFSSubClassOfProperty()));
        DeletePropertyTestCase.assertContains((Object)superclass, c.getPropertyValues(this.owlModel.getRDFSSubClassOfProperty()));
    }

    public void testDeleteEquivalentClassOnPropertyDeleteFromFile() throws Exception {
        this.loadTestOntology(new URI("http://www.owl-ontologies.com/travel.owl"));
        OWLNamedClass cls = this.owlModel.getOWLNamedClass("BudgetHotelDestination");
        DeletePropertyTestCase.assertTrue((boolean)cls.isDefinedClass());
        RDFProperty s = this.owlModel.getRDFSSubClassOfProperty();
        DeletePropertyTestCase.assertSize(0, cls.getPropertyValues(s));
        RDFProperty property = this.owlModel.getRDFProperty("hasAccommodation");
        property.delete();
        DeletePropertyTestCase.assertSize(1, cls.getPropertyValues(s));
        OWLNamedClass superclass = (OWLNamedClass)cls.getPropertyValues(s).iterator().next();
        DeletePropertyTestCase.assertEquals((String)"Destination", (String)superclass.getName());
    }
}

