/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Set;

public class GetAssociatedPropertiesTestCase
extends AbstractJenaTestCase {
    public void testRDFSNamedClassSimpleProperty() {
        this.owlModel.createRDFProperty("domainless");
        RDFProperty domainful = this.owlModel.createRDFProperty("domainful");
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        domainful.setDomain(cls);
        Set associatedProperties = cls.getAssociatedProperties();
        GetAssociatedPropertiesTestCase.assertSize(1, associatedProperties);
        GetAssociatedPropertiesTestCase.assertContains((Object)domainful, cls.getAssociatedProperties());
    }

    public void testRDFSNamedClassSubclass() {
        this.owlModel.createRDFProperty("domainless");
        RDFProperty domainful = this.owlModel.createRDFProperty("domainful");
        RDFSNamedClass superclass = this.owlModel.createRDFSNamedClass("Superclass");
        RDFSNamedClass cls = this.owlModel.createRDFSNamedSubclass("Class", superclass);
        domainful.setDomain(superclass);
        Set associatedProperties = cls.getAssociatedProperties();
        GetAssociatedPropertiesTestCase.assertSize(1, associatedProperties);
        GetAssociatedPropertiesTestCase.assertContains((Object)domainful, cls.getAssociatedProperties());
    }

    public void testRDFSNamedClassSubproperty() {
        this.owlModel.createRDFProperty("domainless");
        RDFProperty domainful = this.owlModel.createRDFProperty("domainful");
        RDFProperty subproperty = this.owlModel.createRDFProperty("subproperty");
        subproperty.addSuperproperty(domainful);
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        domainful.setDomain(cls);
        Set associatedProperties = cls.getAssociatedProperties();
        GetAssociatedPropertiesTestCase.assertSize(2, associatedProperties);
        GetAssociatedPropertiesTestCase.assertContains((Object)domainful, cls.getAssociatedProperties());
        GetAssociatedPropertiesTestCase.assertContains((Object)subproperty, cls.getAssociatedProperties());
    }

    public void testOWLNamedClassRestriction() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        GetAssociatedPropertiesTestCase.assertSize(0, cls.getAssociatedProperties());
        cls.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1));
        GetAssociatedPropertiesTestCase.assertSize(1, cls.getAssociatedProperties());
        GetAssociatedPropertiesTestCase.assertContains((Object)property, cls.getAssociatedProperties());
    }

    public void testOWLNamedClassWithDomainButMaxCardinality() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        GetAssociatedPropertiesTestCase.assertSize(0, cls.getAssociatedProperties());
        property.setDomain(cls);
        GetAssociatedPropertiesTestCase.assertSize(1, cls.getAssociatedProperties());
        cls.addSuperclass(this.owlModel.createOWLMaxCardinality(property, 0));
        GetAssociatedPropertiesTestCase.assertSize(0, cls.getAssociatedProperties());
    }
}

