/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.patcher;

import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStore;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.patcher.OWLModelPatcher;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultOWLModelPatcher
implements OWLModelPatcher {
    private Map objectTypeMap = new HashMap();

    public DefaultOWLModelPatcher(OWLModel owlModel) {
        this.objectTypeMap.put(owlModel.getRDFSDomainProperty(), owlModel.getRDFSNamedClassClass());
        this.objectTypeMap.put(owlModel.getRDFSRangeProperty(), owlModel.getRDFSNamedClassClass());
        this.objectTypeMap.put(owlModel.getRDFSSubPropertyOfProperty(), owlModel.getRDFPropertyClass());
        this.objectTypeMap.put(owlModel.getRDFSSubClassOfProperty(), owlModel.getRDFSNamedClassClass());
        this.objectTypeMap.put(owlModel.getRDFTypeProperty(), owlModel.getRDFSNamedClassClass());
        this.objectTypeMap.put(owlModel.getRDFProperty("owl:onProperty"), owlModel.getRDFPropertyClass());
    }

    private RDFSNamedClass getRDFType(RDFResource resource) {
        OWLModel kb = resource.getOWLModel();
        for (Reference ref : kb.getReferences(resource, 1000)) {
            RDFSNamedClass type = (RDFSNamedClass)this.objectTypeMap.get(ref.getSlot());
            if (type == null) continue;
            return type;
        }
        DefaultRDFProperty dummy = new DefaultRDFProperty(kb, resource.getFrameID());
        OWLFrameStore owlFS = resource.getOWLModel().getOWLFrameStore();
        Iterator frames = owlFS.getFramesWithAnyDirectOwnSlotValue(dummy).iterator();
        if (frames.hasNext()) {
            return resource.getOWLModel().getRDFPropertyClass();
        }
        return null;
    }

    public void patch(Iterator resources, String namespace) {
        OWLModel owlModel = null;
        TripleStore ts = null;
        while (resources.hasNext()) {
            RDFSNamedClass type;
            RDFResource resource = (RDFResource)resources.next();
            if (!namespace.equals(resource.getNamespace())) continue;
            if (owlModel == null) {
                owlModel = resource.getOWLModel();
                String uri = namespace;
                if (uri.endsWith("#")) {
                    uri = uri.substring(0, uri.length() - 1);
                }
                ts = owlModel.getTripleStoreModel().createTripleStore(uri);
            }
            if ((type = this.getRDFType(resource)) == null) continue;
            ts.add(resource, owlModel.getRDFTypeProperty(), type);
            resource.removeDirectType(owlModel.getRDFUntypedResourcesClass());
            owlModel.getTripleStoreModel().setHomeTripleStore(resource, ts);
        }
    }
}

